import { SkillType, ChooseRule, SkillTarget } from "./SkillConst";
import getSkillData, { SkillId } from "./SkillData";
import { Arms } from "../common/Const";

const {ccclass, property} = cc._decorator;

@ccclass
export default class SkillComponent extends cc.Component {
    private _skillId: SkillId = SkillId.NULL;
    set skillId (id: SkillId) {
        if (this._skillId === id) return;
        this._skillId = id;
        let data = getSkillData(id);
        this.skillName = data.name;
        this.skillIcon = data.icon;
        this.skillDes = data.des;
        this.skillType = data.type;
        this.skillRule = data.rule;
        this.skillTarget = data.target;
        this.doFunc = data.func;
    }
    get skillId () {
        return this._skillId;
    }

    private _skillName: string;         // 名称
    private _skillIcon: string;         // TODO 图标
    private _skillDes: string;          // TODO 描述
    private _skillType: SkillType;      // 技能类型
    private _skillRule: ChooseRule;     // 选取规则
    private _skillTarget: SkillTarget;  // 目标选取分类
    private _doFunc: Function;          // 处理函数

    get skillName () {
        return this._skillName;
    }
    set skillName (value: string) {
        this._skillName = value;
    }
    get skillIcon () {
        return this._skillIcon;
    }
    set skillIcon (value: string) {
        this._skillIcon = value;
    }
    get skillDes () {
        return this._skillDes;
    }
    set skillDes (value: string) {
        this._skillDes = value;
    }
    get skillType () {
        return this._skillType;
    }
    set skillType (value: SkillType) {
        this._skillType = value;
    }
    get skillRule () {
        return this._skillRule;
    }
    set skillRule (value: ChooseRule) {
        this._skillRule = value;
    }
    get skillTarget () {
        return this._skillTarget;
    }
    set skillTarget (value: SkillTarget) {
        this._skillTarget = value;
    }
    get doFunc () {
        return this._doFunc;
    }
    set doFunc (value: Function) {
        this._doFunc = value;
    }

    initSkill (id: SkillId) {
        this.skillId = id;
    }
}
