// 技能类型
export const enum SkillType {
    Before, // 开局技能
    Attack, // 伤害技能
    Recover // 恢复技能
}

// 施法对象
export const enum SkillTarget {
    Self,       // 自己
    One,        // 一个
    Col,        // 一列
    Row,        // 一行
    All,        // 所有
    OtherOne,   // 敌方一个
    OtherCol,   // 敌方一列
    OtherRow,   // 敌方一行
    OtherAll,   // 敌方所有
}

// 选取规则
export const enum ChooseRule {
    Radom,      // 随机
    MaxHp,      // 最大血量
    MinHp,      // 最小血量
    MaxAttack,  // 最大攻击
    MinAttack,  // 最小攻击
    MaxDefence, // 最大防御
    MinDefence, // 最小防御
    Through,    // 穿透 选取随机前排单位及其对应一行
    FirstCol,   // 前排
    SecondCol,  // 中排
    LastCol,    // 后排
}

// buff触发时机
export const enum BuffTime {
    doAttack,   // 自己行动
    onAttack,   // 被攻击时
    onSkill,    // 中技能时
}

// 触发型BUFF类型
export const enum BuffType {
    Reduce,     // 减伤
    Recover,    // 恢复
    Other,      // 其他
}