import { SkillType, ChooseRule, SkillTarget } from "./SkillConst";
import Hero from "../prefab/Hero";
import BuffComponent from "./BuffComponent";
import { BuffId } from "./BuffData";

export const enum SkillId {
    NULL,
    KongCheng,
}

export default function getSkillData (id: SkillId) :SkillData {
    return new SkillData(data[id]);
}

class SkillData {
    name: string;
    icon: string;
    des: string;
    type: SkillType;
    rule: ChooseRule;
    target: SkillTarget;
    func: Function;
    constructor (data) {
        this.name = data.name;
        this.icon = data.icon;
        this.des = data.des;
        this.type = data.type;
        this.rule = data.rule;
        this.target = data.target;
        this.func = data.func;
    }
}

const data = {
    [SkillId.KongCheng]: {
        name: '空城计',
        icon: '',
        des: '进入空城状态，本回合免疫普通攻击伤害',
        type: SkillType.Before,
        rule: ChooseRule.Radom,
        target: SkillTarget.Self,
        func: function (hero:Hero, targets: Array<Hero>) {
            hero.node_buff.addComponent(BuffComponent).initBuff(BuffId.KongCheng);
        }
    }
}
