import Hero from "../prefab/Hero";
import { SkillType, SkillTarget, ChooseRule, BuffTime } from "./SkillConst";
import SkillComponent from "./SkillComponent";
import GameView from "../views/GameView";
import { CAMPS } from "../common/Const";
import BuffComponent from "./BuffComponent";

export default class SkillSystem {
    private static _instance = new SkillSystem();
    private game: GameView;
    public static get instance () {
        return this._instance;
    }

    // 游戏场景
    public initGameView (game: GameView) {
        this.game = game;
    }

    // 查看当前状态是否有能施放的技能
    public doCheckSkill (hero: Hero, type: SkillType): boolean {
        let skills = hero.node_skill.getComponents(SkillComponent);
        let success = false;
        skills.forEach((skill:SkillComponent)=>{
            if (skill.skillType === type) {
                success = true;
                let targets;
                if (skill.skillTarget !== SkillTarget.Self) {   // 施法目标为自己时，不获取施法对象
                    targets = this.getTargetsByType(hero, skill);
                }
                skill.doFunc(hero, targets);
            }
        });
        return success;
    }

    // 查看当前状态是否有能触发的BUFF
    public doCheckBuff (hero: Hero, state: BuffTime): BuffComponent | null {
        let buffs = hero.node_buff.getComponents(BuffComponent);
        let buff: BuffComponent | null = null;
        buffs.forEach((b:BuffComponent)=>{
            if (b.buffTime === state) {
                buff = b;
                return;
            }
        })
        return buff;
    }

    // GameView.getHeroList (camp: CAMPS) {
    //     switch (camp) {
    //         case CAMPS.LEFT:
    //             return this.leftList;
    //         case CAMPS.RIGHT:
    //             return this.rightList;
    //         default:
    //             break;
    //     }
    //     return [];
    // }

    // 获取技能施放对象数组
    private getTargetsByType (hero:Hero, skill:SkillComponent) {
        let targetList;
        switch (skill.skillTarget) {
            case SkillTarget.One:
            case SkillTarget.Col:
            case SkillTarget.Row:
            case SkillTarget.All:
                targetList = this.game.getHeroList(hero.camp);  // 己方阵营 用于给己方加buff或回血类
                break;
            case SkillTarget.OtherOne:
            case SkillTarget.OtherCol:
            case SkillTarget.OtherRow:
            case SkillTarget.OtherAll:
                targetList = this.game.getHeroList(hero.camp === CAMPS.LEFT ? CAMPS.RIGHT : CAMPS.LEFT);    // 敌方阵营 用于伤害技能或debuff
                break;
            default:
                return [];
        }
        return this.getTargets(targetList, skill);
    }

    // 获取对象数组
    private getTargets (list: Array<cc.Node>, skill:SkillComponent) {
        let targets = [];
        switch (skill.skillTarget) {
            case SkillTarget.One:
            case SkillTarget.OtherOne:
                targets.push(this.getTargetByRule(list, skill));
                break;
            case SkillTarget.Col:
            case SkillTarget.OtherCol:
                let cols = this.getCol(list);
                if (skill.skillRule === ChooseRule.Radom) {
                    targets = cols[Math.floor(Math.random() * cols.length)];
                } else if (skill.skillRule === ChooseRule.FirstCol) {
                    targets = cols[0];
                } else if (skill.skillRule === ChooseRule.SecondCol) {
                    targets = cols[1] || cols[0];
                } else if (skill.skillRule === ChooseRule.LastCol) {
                    targets = cols[cols.length-1];
                }
                break;
            case SkillTarget.Row:
            case SkillTarget.OtherRow:
                let rows;
                if (skill.skillRule === ChooseRule.Radom) {
                    rows = this.getRow(list);
                    targets = rows[Math.floor(Math.random() * rows.length)];
                } else if (skill.skillRule === ChooseRule.Through) {
                    let first = this.getCol(list)[0];
                    let t: cc.Node = first[Math.floor(Math.random() * first.length)];
                    rows = this.getRow(list, true);
                    targets = rows[t.getComponent(Hero).row];
                }
                break;
            case SkillTarget.All:
            case SkillTarget.OtherAll:
                targets = list;
                break;
        }
        return targets;
    }

    // 按竖列分类 empty表示是否需要包含空列
    private getCol (list: Array<cc.Node>, empty: boolean = false) {
        let temp = [[],[],[]];
        list.forEach(node=>{
            let h = node.getComponent(Hero);
            if (!h.isdead) {
                temp[h.col].push(h);
            }
        });
        if (!empty) {
            let l = [];
            temp.forEach(t=>{
                if (t.length > 0) {
                    l.push(t);
                }
            });
            return l;
        }
        return temp;
    }

    // 按横行分类 empty表示是否需要包含空行
    private getRow (list: Array<cc.Node>, empty: boolean = false) {
        let temp = [[],[],[]];
        list.forEach(node=>{
            let h = node.getComponent(Hero);
            if (!h.isdead) {
                temp[h.row].push(h);
            }
        });
        if (!empty) {
            let l = [];
            temp.forEach(t=>{
                if (t.length > 0) {
                    l.push(t);
                }
            });
            return l;
        }
        return temp;
    }    

    // 获取单个对象
    private getTargetByRule (list: Array<cc.Node>, skill: SkillComponent) {
        let target, max=0, min=10000000;    // 临时写法，取最大/小值时使用
        switch (skill.skillRule) {
            case ChooseRule.MaxHp:
                list.forEach(node=>{
                    let hero = node.getComponent(Hero);
                    if (!hero.isdead && hero.hp > max) {
                        max = hero.hp;
                        target = node;
                    }
                })
                return target;
            case ChooseRule.MinHp:
                list.forEach(node=>{
                    let hero = node.getComponent(Hero);
                    if (!hero.isdead && hero.hp < min) {
                        min = hero.hp;
                        target = node;
                    }
                })
                return target;
            case ChooseRule.MaxAttack:
                list.forEach(node=>{
                    let hero = node.getComponent(Hero);
                    if (!hero.isdead && hero.attack > max) {
                        max = hero.attack;
                        target = node;
                    }
                })
                return target;
            case ChooseRule.MinAttack:
                list.forEach(node=>{
                    let hero = node.getComponent(Hero);
                    if (!hero.isdead && hero.attack < min) {
                        min = hero.attack;
                        target = node;
                    }
                })
                return target;
            case ChooseRule.MaxDefence:
                list.forEach(node=>{
                    let hero = node.getComponent(Hero);
                    if (!hero.isdead && hero.defence > max) {
                        max = hero.defence;
                        target = node;
                    }
                })
                return target;
            case ChooseRule.MaxDefence:
                list.forEach(node=>{
                    let hero = node.getComponent(Hero);
                    if (!hero.isdead && hero.defence < min) {
                        min = hero.defence;
                        target = node;
                    }
                })
                return target;
            case ChooseRule.Radom:
            default:
                return list[Math.floor(list.length * Math.random())];
        }
    }
}