import { _decorator, Component, Label, Node, UIOpacity } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    @property(Node)
    root1: Node;
    @property(Node)
    root2: Node;
    @property(Node)
    container1: Node;
    @property(Node)
    container2: Node;

    @property(Label)
    label1: Label;
    @property(Label)
    label2: Label;

    @property(UIOpacity)
    uiopacity1: UIOpacity;

    @property(UIOpacity)
    uiopacity2: UIOpacity;


    start() {

    }

    swapChildren(): void {
        let arr1 = this.container1.children.concat();
        let arr2 = this.container2.children.concat();
        this.container1.removeAllChildren();
        this.container2.removeAllChildren();
        for (let child1 of arr1) {
            this.container2.addChild(child1);
        }
        for (let child2 of arr2) {
            this.container1.addChild(child2);
        }
    }

    change1Alpha(): void {
        if (this.uiopacity1.opacity == 120) {
            this.uiopacity1.opacity = 255;
        }
        else {
            this.uiopacity1.opacity = 120;
        }
        this.label1.string = "透明度：" + this.uiopacity1.opacity;
    }

    change2Alpha(): void {
        if (this.uiopacity2.opacity == 120) {
            this.uiopacity2.opacity = 255;
        }
        else {
            this.uiopacity2.opacity = 120;
        }
        this.label2.string = "透明度：" + this.uiopacity2.opacity;
    }
}


