
const { ccclass, property, menu, executeInEditMode, inspector } = cc._decorator;
import * as stringz from "stringz";

@ccclass
@executeInEditMode
@inspector('packages://tail_label/inspector/tail_label.js')
@menu("SharkMarine/TailLabel")
export default class TailLabel extends cc.Label {

    @property()
    _cWidth = 100;
    @property({ type: cc.Integer, displayName: '文本域-宽' })
    get customWidth() {
        return this._cWidth;
    }
    set customWidth(v) {
        if (v != this._cWidth) {
            this._cWidth = v;
            this.node.width = v;
            this.syncMeasureLabel();
        }
    }
    @property()
    _cHeight = 100;
    @property({ type: cc.Integer, displayName: '文本域-高' })
    get customHeight() {
        return this._cHeight;
    }
    set customHeight(v) {
        if (v != this._cHeight) {
            this._cHeight = v;
        }
    }
    @property({ displayName: '结尾字符串' })
    tailString = '...';

    @property({ override: true })
    private _string;
    @property({ override: true, multiline: true })
    //@ts-ignore
    get string() {
        return this._string;
    }
    set string(value) {
        let oldValue = this._string;
        this._string = this.getMeasureString(value);

        if (this.string !== oldValue) {
            //@ts-ignore
            this.setVertsDirty();
        }
        //@ts-ignore
        this._checkStringEmpty();
    }

    @property({ type: cc.Label.HorizontalAlign })
    _horizontalAlign = cc.Label.HorizontalAlign.LEFT;
    @property({ type: cc.Label.HorizontalAlign, override: true, })
    //@ts-ignore
    get horizontalAlign() {
        return this._horizontalAlign;
    }
    set horizontalAlign(value: cc.Label.HorizontalAlign) {
        if (this._horizontalAlign === value) return;
        this._horizontalAlign = value;
        //@ts-ignore
        this.setVertsDirty();
        this.syncMeasureLabel();
    }
    @property({ type: cc.Label.VerticalAlign })
    _verticalAlign = cc.Label.VerticalAlign.TOP;
    @property({ type: cc.Label.VerticalAlign, override: true, })
    //@ts-ignore
    get verticalAlign() {
        return this._verticalAlign;
    }
    set verticalAlign(value: cc.Label.VerticalAlign) {
        if (this._verticalAlign === value) return;
        this._verticalAlign = value;
        //@ts-ignore
        this.setVertsDirty();
        this.syncMeasureLabel();
    }
    @property({ override: true })
    //@ts-ignore
    get fontSize() {
        //@ts-ignore
        return this._fontSize;
    }
    set fontSize(value) {
        //@ts-ignore
        if (this._fontSize === value) return;

        //@ts-ignore
        this._fontSize = value;
        //@ts-ignore
        this.setVertsDirty();
        this.syncMeasureLabel();
    }

    @property({ override: true })
    //@ts-ignore
    get lineHeight() {
        //@ts-ignore
        return this._lineHeight;
    }
    set lineHeight(value) {
        //@ts-ignore
        if (this._lineHeight === value) return;
        //@ts-ignore
        this._lineHeight = value;
        //@ts-ignore
        this.setVertsDirty();
        this.syncMeasureLabel();
    }
    @property({ type: cc.Font, override: true })
    //@ts-ignore
    get font() {
        //@ts-ignore
        return this._N$file;
    }
    set font(value) {
        if (this.font === value) return;

        //if delete the font, we should change isSystemFontUsed to true
        if (!value) {
            //@ts-ignore
            this._isSystemFontUsed = true;
        }

        if (CC_EDITOR && value) {
            //@ts-ignore
            this._userDefinedFont = value;
        }
        //@ts-ignore
        this._N$file = value;
        //@ts-ignore
        if (value && this._isSystemFontUsed)
            //@ts-ignore
            this._isSystemFontUsed = false;

        if (!this.enabledInHierarchy) return;

        //@ts-ignore
        this._forceUpdateRenderData();
        this.syncMeasureLabel();
    }


    //测量文本
    private _measureLb: cc.Label = null;

    private _hasInited = false;

    onLoad() {
        if (CC_EDITOR) {
            cc.director.on('syncMeasureLabel', this.syncMeasureLabel, this);
        }
        this.init();
    }
    init() {
        if (!this._hasInited) {
            this._hasInited = true;
            this.initMeasureLabel();
            this.syncMeasureLabel();
        }
    }

    /**
     * 初始化Label
     */
    initMeasureLabel() {
        if (this.overflow != cc.Label.Overflow.RESIZE_HEIGHT) {
            this.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
        }
        this.node.width = this.customWidth;
        if (this.node.childrenCount > 0) {
            this._measureLb = this.node.children[0].getComponent(cc.Label);
        }
        if (!this._measureLb) {
            let n = new cc.Node('MeasureLabel');
            this._measureLb = n.addComponent(cc.Label);
            n.active = false;
            this.node.addChild(n);
        }
    }

    /**
     * 同步文本信息到测量文本
     */
    syncMeasureLabel() {
        if (this._measureLb) {
            this._measureLb.fontSize = this.fontSize;
            this._measureLb.font = this.font;
            this._measureLb.lineHeight = this.lineHeight;
            this._measureLb.enableBold = this.enableBold;
            this._measureLb.enableItalic = this.enableItalic;
            this._measureLb.enableUnderline = this.enableUnderline;
            this._measureLb.horizontalAlign = this.horizontalAlign;
            this._measureLb.verticalAlign = this.verticalAlign;
            this._measureLb.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
            this._measureLb.node.width = this.customWidth;
            this.log(`同步label属性信息`)
        }
    }

    getMeasureString(str: string) {
        this.init();
        this.log('getMeasureString')
        this._measureLb.node.active = false;
        this._measureLb.string = str;
        //@ts-ignore
        this._measureLb._forceUpdateRenderData();
        if (this._measureLb.node.height <= this.customHeight) {
            this.log(`返回的字符串1:${this._measureLb.string}`)
            return str;
        }
        else {
            let len = stringz.length(str);
            //二分查找间距
            let space = len;
            //符合条件的最长子串
            let top = len;
            //死循环检测
            let count = 0;
            let result;
            while (space != 0) {
                count++;
                this._measureLb.string = stringz.substr(str, 0, top) + this.tailString;
                //@ts-ignore
                this._measureLb._forceUpdateRenderData();
                if (this._measureLb.node.height <= this.customHeight) {
                    result = this._measureLb.string;
                    space = Math.floor(space / 2);
                    top = top + space;
                }
                else {
                    space = Math.floor(space / 2);
                    top = top - space;
                }
                this.log(`space:${space},top:${top}`)
                if (count >= 1000) {
                    this.error(`循环超过1000次`)
                    break;
                }
            }
            this.log(`返回的字符串2:${this._measureLb.string}，循环次数:${count}`)
            return result;
        }
    }

    log(text: string) {
        if (CC_EDITOR) {
            Editor.log(text)
        }
        else {
            cc.log(text)
        }
    }

    error(text: string) {
        if (CC_EDITOR) {
            Editor.error(text)
        }
        else {
            cc.error(text)
        }
    }
}
