"use strict";
Vue.component("cc-label", {
  dependencies: ["packages://inspector/share/blend.js"],
  template: `
    <ui-prop      v-prop="target.string"      :multi-values="multi"
    ></ui-prop>    <ui-prop
      v-prop="target.horizontalAlign"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.verticalAlign"
      :multi-values="multi"
    ></ui-prop>

    <ui-prop
      v-prop="target.actualFontSize"
      v-show="!_hiddenActualFontSize()"
      :multi-values="multi"
    ></ui-prop>
    <div clase="label" style="margin:auto;color:#1CB166">
    ============扩展属性===开始==========
    </div>
      <ui-prop type="number"
        v-prop="target.customWidth">
        :multi-values="multi"
      </ui-prop>
      <ui-prop type="number"
        v-prop="target.customHeight">
        :multi-values="multi"
      </ui-prop>
      <ui-prop type="string"
        v-prop="target.tailString">
        :multi-values="multi"
      </ui-prop>
    <div clase="label" style="margin:auto;color:#1CB166">
    ============扩展属性===结束==========
    </div>
    <ui-prop type="number"
      v-prop="target.fontSize">
      :multi-values="multi"
    </ui-prop>
    <ui-prop
      v-prop="target._bmFontOriginalSize"
      v-show="_isBMFont()"
      :multi-values="multi"
    ></ui-prop>

    <ui-prop
      v-prop="target.lineHeight"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.spacingX"
      v-show="_isBMFont()"  
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.overflow"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.enableWrapText"
      v-show="!_hiddenWrapText()"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.font"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.fontFamily"
      v-show="_isSystemFont()"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.enableBold"
      v-show="!_isBMFont()"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.enableItalic"
      v-show="!_isBMFont()"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.enableUnderline"
      v-show="!_isBMFont()"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.underlineHeight"
      v-show="!_isBMFont() && target.enableUnderline.value === true"
      :indent="1"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.cacheMode"
      v-show="!_isBMFont()"
      :multi-values="multi"
    ></ui-prop>
    <ui-prop
      v-prop="target.useSystemFont"
      :multi-values="multi"
    ></ui-prop>
    
    <cc-blend-section :target.sync="target"></cc-blend-section>
    <cc-array-prop :target.sync="target.materials"></cc-array-prop>
`,
  props: {
    target: {
      twoWay: !0, type: Object
    },
    multi: { type: Boolean }
  },
  methods: {
    T: Editor.T,
    _isBMFont() {
      return this.target._bmFontOriginalSize.value > 0
    },
    _isSystemFont() {
      return this.target.useSystemFont.value
    },
    _hiddenWrapText() {
      let t = this.target.overflow.value;
      return 0 === t || 3 === t
    },
    _hiddenActualFontSize() {
      return 2 !== this.target.overflow.value
    }
  }
});