
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/TailLabel.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b0978gpguNIcYcc2Iso44Uj', 'TailLabel');
// scripts/TailLabel.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu, executeInEditMode = _a.executeInEditMode, inspector = _a.inspector;
var stringz = require("stringz");
var TailLabel = /** @class */ (function (_super) {
    __extends(TailLabel, _super);
    function TailLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._cWidth = 100;
        _this._cHeight = 100;
        _this.tailString = '...';
        _this._horizontalAlign = cc.Label.HorizontalAlign.LEFT;
        _this._verticalAlign = cc.Label.VerticalAlign.TOP;
        //测量文本
        _this._measureLb = null;
        _this._hasInited = false;
        return _this;
    }
    Object.defineProperty(TailLabel.prototype, "customWidth", {
        get: function () {
            return this._cWidth;
        },
        set: function (v) {
            if (v != this._cWidth) {
                this._cWidth = v;
                this.node.width = v;
                this.syncMeasureLabel();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "customHeight", {
        get: function () {
            return this._cHeight;
        },
        set: function (v) {
            if (v != this._cHeight) {
                this._cHeight = v;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "string", {
        get: function () {
            return this._string;
        },
        set: function (value) {
            var oldValue = this._string;
            this._string = this.getMeasureString(value);
            if (this.string !== oldValue) {
                //@ts-ignore
                this.setVertsDirty();
            }
            //@ts-ignore
            this._checkStringEmpty();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "horizontalAlign", {
        get: function () {
            return this._horizontalAlign;
        },
        set: function (value) {
            if (this._horizontalAlign === value)
                return;
            this._horizontalAlign = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "verticalAlign", {
        get: function () {
            return this._verticalAlign;
        },
        set: function (value) {
            if (this._verticalAlign === value)
                return;
            this._verticalAlign = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "fontSize", {
        get: function () {
            //@ts-ignore
            return this._fontSize;
        },
        set: function (value) {
            //@ts-ignore
            if (this._fontSize === value)
                return;
            //@ts-ignore
            this._fontSize = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "lineHeight", {
        get: function () {
            //@ts-ignore
            return this._lineHeight;
        },
        set: function (value) {
            //@ts-ignore
            if (this._lineHeight === value)
                return;
            //@ts-ignore
            this._lineHeight = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "font", {
        get: function () {
            //@ts-ignore
            return this._N$file;
        },
        set: function (value) {
            if (this.font === value)
                return;
            //if delete the font, we should change isSystemFontUsed to true
            if (!value) {
                //@ts-ignore
                this._isSystemFontUsed = true;
            }
            if (CC_EDITOR && value) {
                //@ts-ignore
                this._userDefinedFont = value;
            }
            //@ts-ignore
            this._N$file = value;
            //@ts-ignore
            if (value && this._isSystemFontUsed)
                //@ts-ignore
                this._isSystemFontUsed = false;
            if (!this.enabledInHierarchy)
                return;
            //@ts-ignore
            this._forceUpdateRenderData();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    TailLabel.prototype.onLoad = function () {
        if (CC_EDITOR) {
            cc.director.on('syncMeasureLabel', this.syncMeasureLabel, this);
        }
        this.init();
    };
    TailLabel.prototype.init = function () {
        if (!this._hasInited) {
            this._hasInited = true;
            this.initMeasureLabel();
            this.syncMeasureLabel();
        }
    };
    /**
     * 初始化Label
     */
    TailLabel.prototype.initMeasureLabel = function () {
        if (this.overflow != cc.Label.Overflow.RESIZE_HEIGHT) {
            this.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
        }
        this.node.width = this.customWidth;
        if (this.node.childrenCount > 0) {
            this._measureLb = this.node.children[0].getComponent(cc.Label);
        }
        if (!this._measureLb) {
            var n = new cc.Node('MeasureLabel');
            this._measureLb = n.addComponent(cc.Label);
            n.active = false;
            this.node.addChild(n);
        }
    };
    /**
     * 同步文本信息到测量文本
     */
    TailLabel.prototype.syncMeasureLabel = function () {
        if (this._measureLb) {
            this._measureLb.fontSize = this.fontSize;
            this._measureLb.font = this.font;
            this._measureLb.lineHeight = this.lineHeight;
            this._measureLb.enableBold = this.enableBold;
            this._measureLb.enableItalic = this.enableItalic;
            this._measureLb.enableUnderline = this.enableUnderline;
            this._measureLb.horizontalAlign = this.horizontalAlign;
            this._measureLb.verticalAlign = this.verticalAlign;
            this._measureLb.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
            this._measureLb.node.width = this.customWidth;
            this.log("\u540C\u6B65label\u5C5E\u6027\u4FE1\u606F");
        }
    };
    TailLabel.prototype.getMeasureString = function (str) {
        this.init();
        this.log('getMeasureString');
        this._measureLb.node.active = false;
        this._measureLb.string = str;
        //@ts-ignore
        this._measureLb._forceUpdateRenderData();
        if (this._measureLb.node.height <= this.customHeight) {
            this.log("\u8FD4\u56DE\u7684\u5B57\u7B26\u4E321:" + this._measureLb.string);
            return str;
        }
        else {
            var len = stringz.length(str);
            //二分查找间距
            var space = len;
            //符合条件的最长子串
            var top = len;
            //死循环检测
            var count = 0;
            var result = void 0;
            while (space != 0) {
                count++;
                this._measureLb.string = stringz.substr(str, 0, top) + this.tailString;
                //@ts-ignore
                this._measureLb._forceUpdateRenderData();
                if (this._measureLb.node.height <= this.customHeight) {
                    result = this._measureLb.string;
                    space = Math.floor(space / 2);
                    top = top + space;
                }
                else {
                    space = Math.floor(space / 2);
                    top = top - space;
                }
                this.log("space:" + space + ",top:" + top);
                if (count >= 1000) {
                    this.error("\u5FAA\u73AF\u8D85\u8FC71000\u6B21");
                    break;
                }
            }
            this.log("\u8FD4\u56DE\u7684\u5B57\u7B26\u4E322:" + this._measureLb.string + "\uFF0C\u5FAA\u73AF\u6B21\u6570:" + count);
            return result;
        }
    };
    TailLabel.prototype.log = function (text) {
        if (CC_EDITOR) {
            Editor.log(text);
        }
        else {
            cc.log(text);
        }
    };
    TailLabel.prototype.error = function (text) {
        if (CC_EDITOR) {
            Editor.error(text);
        }
        else {
            cc.error(text);
        }
    };
    __decorate([
        property()
    ], TailLabel.prototype, "_cWidth", void 0);
    __decorate([
        property({ type: cc.Integer, displayName: '文本域-宽' })
    ], TailLabel.prototype, "customWidth", null);
    __decorate([
        property()
    ], TailLabel.prototype, "_cHeight", void 0);
    __decorate([
        property({ type: cc.Integer, displayName: '文本域-高' })
    ], TailLabel.prototype, "customHeight", null);
    __decorate([
        property({ displayName: '结尾字符串' })
    ], TailLabel.prototype, "tailString", void 0);
    __decorate([
        property({ override: true })
    ], TailLabel.prototype, "_string", void 0);
    __decorate([
        property({ override: true, multiline: true })
    ], TailLabel.prototype, "string", null);
    __decorate([
        property({ type: cc.Label.HorizontalAlign })
    ], TailLabel.prototype, "_horizontalAlign", void 0);
    __decorate([
        property({ type: cc.Label.HorizontalAlign, override: true, })
    ], TailLabel.prototype, "horizontalAlign", null);
    __decorate([
        property({ type: cc.Label.VerticalAlign })
    ], TailLabel.prototype, "_verticalAlign", void 0);
    __decorate([
        property({ type: cc.Label.VerticalAlign, override: true, })
    ], TailLabel.prototype, "verticalAlign", null);
    __decorate([
        property({ override: true })
    ], TailLabel.prototype, "fontSize", null);
    __decorate([
        property({ override: true })
    ], TailLabel.prototype, "lineHeight", null);
    __decorate([
        property({ type: cc.Font, override: true })
    ], TailLabel.prototype, "font", null);
    TailLabel = __decorate([
        ccclass,
        executeInEditMode,
        inspector('packages://tail_label/inspector/tail_label.js'),
        menu("SharkMarine/TailLabel")
    ], TailLabel);
    return TailLabel;
}(cc.Label));
exports.default = TailLabel;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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