"use strict";
cc._RF.push(module, 'b0978gpguNIcYcc2Iso44Uj', 'TailLabel');
// scripts/TailLabel.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu, executeInEditMode = _a.executeInEditMode, inspector = _a.inspector;
var stringz = require("stringz");
var TailLabel = /** @class */ (function (_super) {
    __extends(TailLabel, _super);
    function TailLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._cWidth = 100;
        _this._cHeight = 100;
        _this.tailString = '...';
        _this._horizontalAlign = cc.Label.HorizontalAlign.LEFT;
        _this._verticalAlign = cc.Label.VerticalAlign.TOP;
        //测量文本
        _this._measureLb = null;
        _this._hasInited = false;
        return _this;
    }
    Object.defineProperty(TailLabel.prototype, "customWidth", {
        get: function () {
            return this._cWidth;
        },
        set: function (v) {
            if (v != this._cWidth) {
                this._cWidth = v;
                this.node.width = v;
                this.syncMeasureLabel();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "customHeight", {
        get: function () {
            return this._cHeight;
        },
        set: function (v) {
            if (v != this._cHeight) {
                this._cHeight = v;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "string", {
        get: function () {
            return this._string;
        },
        set: function (value) {
            var oldValue = this._string;
            this._string = this.getMeasureString(value);
            if (this.string !== oldValue) {
                //@ts-ignore
                this.setVertsDirty();
            }
            //@ts-ignore
            this._checkStringEmpty();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "horizontalAlign", {
        get: function () {
            return this._horizontalAlign;
        },
        set: function (value) {
            if (this._horizontalAlign === value)
                return;
            this._horizontalAlign = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "verticalAlign", {
        get: function () {
            return this._verticalAlign;
        },
        set: function (value) {
            if (this._verticalAlign === value)
                return;
            this._verticalAlign = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "fontSize", {
        get: function () {
            //@ts-ignore
            return this._fontSize;
        },
        set: function (value) {
            //@ts-ignore
            if (this._fontSize === value)
                return;
            //@ts-ignore
            this._fontSize = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "lineHeight", {
        get: function () {
            //@ts-ignore
            return this._lineHeight;
        },
        set: function (value) {
            //@ts-ignore
            if (this._lineHeight === value)
                return;
            //@ts-ignore
            this._lineHeight = value;
            //@ts-ignore
            this.setVertsDirty();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TailLabel.prototype, "font", {
        get: function () {
            //@ts-ignore
            return this._N$file;
        },
        set: function (value) {
            if (this.font === value)
                return;
            //if delete the font, we should change isSystemFontUsed to true
            if (!value) {
                //@ts-ignore
                this._isSystemFontUsed = true;
            }
            if (CC_EDITOR && value) {
                //@ts-ignore
                this._userDefinedFont = value;
            }
            //@ts-ignore
            this._N$file = value;
            //@ts-ignore
            if (value && this._isSystemFontUsed)
                //@ts-ignore
                this._isSystemFontUsed = false;
            if (!this.enabledInHierarchy)
                return;
            //@ts-ignore
            this._forceUpdateRenderData();
            this.syncMeasureLabel();
        },
        enumerable: false,
        configurable: true
    });
    TailLabel.prototype.onLoad = function () {
        if (CC_EDITOR) {
            cc.director.on('syncMeasureLabel', this.syncMeasureLabel, this);
        }
        this.init();
    };
    TailLabel.prototype.init = function () {
        if (!this._hasInited) {
            this._hasInited = true;
            this.initMeasureLabel();
            this.syncMeasureLabel();
        }
    };
    /**
     * 初始化Label
     */
    TailLabel.prototype.initMeasureLabel = function () {
        if (this.overflow != cc.Label.Overflow.RESIZE_HEIGHT) {
            this.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
        }
        this.node.width = this.customWidth;
        if (this.node.childrenCount > 0) {
            this._measureLb = this.node.children[0].getComponent(cc.Label);
        }
        if (!this._measureLb) {
            var n = new cc.Node('MeasureLabel');
            this._measureLb = n.addComponent(cc.Label);
            n.active = false;
            this.node.addChild(n);
        }
    };
    /**
     * 同步文本信息到测量文本
     */
    TailLabel.prototype.syncMeasureLabel = function () {
        if (this._measureLb) {
            this._measureLb.fontSize = this.fontSize;
            this._measureLb.font = this.font;
            this._measureLb.lineHeight = this.lineHeight;
            this._measureLb.enableBold = this.enableBold;
            this._measureLb.enableItalic = this.enableItalic;
            this._measureLb.enableUnderline = this.enableUnderline;
            this._measureLb.horizontalAlign = this.horizontalAlign;
            this._measureLb.verticalAlign = this.verticalAlign;
            this._measureLb.overflow = cc.Label.Overflow.RESIZE_HEIGHT;
            this._measureLb.node.width = this.customWidth;
            this.log("\u540C\u6B65label\u5C5E\u6027\u4FE1\u606F");
        }
    };
    TailLabel.prototype.getMeasureString = function (str) {
        this.init();
        this.log('getMeasureString');
        this._measureLb.node.active = false;
        this._measureLb.string = str;
        //@ts-ignore
        this._measureLb._forceUpdateRenderData();
        if (this._measureLb.node.height <= this.customHeight) {
            this.log("\u8FD4\u56DE\u7684\u5B57\u7B26\u4E321:" + this._measureLb.string);
            return str;
        }
        else {
            var len = stringz.length(str);
            //二分查找间距
            var space = len;
            //符合条件的最长子串
            var top = len;
            //死循环检测
            var count = 0;
            var result = void 0;
            while (space != 0) {
                count++;
                this._measureLb.string = stringz.substr(str, 0, top) + this.tailString;
                //@ts-ignore
                this._measureLb._forceUpdateRenderData();
                if (this._measureLb.node.height <= this.customHeight) {
                    result = this._measureLb.string;
                    space = Math.floor(space / 2);
                    top = top + space;
                }
                else {
                    space = Math.floor(space / 2);
                    top = top - space;
                }
                this.log("space:" + space + ",top:" + top);
                if (count >= 1000) {
                    this.error("\u5FAA\u73AF\u8D85\u8FC71000\u6B21");
                    break;
                }
            }
            this.log("\u8FD4\u56DE\u7684\u5B57\u7B26\u4E322:" + this._measureLb.string + "\uFF0C\u5FAA\u73AF\u6B21\u6570:" + count);
            return result;
        }
    };
    TailLabel.prototype.log = function (text) {
        if (CC_EDITOR) {
            Editor.log(text);
        }
        else {
            cc.log(text);
        }
    };
    TailLabel.prototype.error = function (text) {
        if (CC_EDITOR) {
            Editor.error(text);
        }
        else {
            cc.error(text);
        }
    };
    __decorate([
        property()
    ], TailLabel.prototype, "_cWidth", void 0);
    __decorate([
        property({ type: cc.Integer, displayName: '文本域-宽' })
    ], TailLabel.prototype, "customWidth", null);
    __decorate([
        property()
    ], TailLabel.prototype, "_cHeight", void 0);
    __decorate([
        property({ type: cc.Integer, displayName: '文本域-高' })
    ], TailLabel.prototype, "customHeight", null);
    __decorate([
        property({ displayName: '结尾字符串' })
    ], TailLabel.prototype, "tailString", void 0);
    __decorate([
        property({ override: true })
    ], TailLabel.prototype, "_string", void 0);
    __decorate([
        property({ override: true, multiline: true })
    ], TailLabel.prototype, "string", null);
    __decorate([
        property({ type: cc.Label.HorizontalAlign })
    ], TailLabel.prototype, "_horizontalAlign", void 0);
    __decorate([
        property({ type: cc.Label.HorizontalAlign, override: true, })
    ], TailLabel.prototype, "horizontalAlign", null);
    __decorate([
        property({ type: cc.Label.VerticalAlign })
    ], TailLabel.prototype, "_verticalAlign", void 0);
    __decorate([
        property({ type: cc.Label.VerticalAlign, override: true, })
    ], TailLabel.prototype, "verticalAlign", null);
    __decorate([
        property({ override: true })
    ], TailLabel.prototype, "fontSize", null);
    __decorate([
        property({ override: true })
    ], TailLabel.prototype, "lineHeight", null);
    __decorate([
        property({ type: cc.Font, override: true })
    ], TailLabel.prototype, "font", null);
    TailLabel = __decorate([
        ccclass,
        executeInEditMode,
        inspector('packages://tail_label/inspector/tail_label.js'),
        menu("SharkMarine/TailLabel")
    ], TailLabel);
    return TailLabel;
}(cc.Label));
exports.default = TailLabel;

cc._RF.pop();