const { ccclass, property } = cc._decorator;

@ccclass
export class MainUI extends cc.Component {

    @property(cc.Prefab)
    private itemPrefab: cc.Prefab = null;

    private itemPool: cc.NodePool = null;

    private item: cc.Node = null;

    onLoad() {
        this.itemPool = new cc.NodePool();
        cc.director.getPhysicsManager().enabled = true;
    }

    private onAddBtnClicked(event: cc.Event, str: string): void {
        if (this.item) return;

        this.item = this.itemPool.get();
        if (!this.item) {
            this.item = cc.instantiate(this.itemPrefab);
        }
        this.node.addChild(this.item);
    }

    private onRemoveBtnClicked(event: cc.Event, str: string): void {
        if (!this.item) return;

        this.itemPool.put(this.item);
        this.item = null;
    }
}
