System.register(["./application.js"], function (_export, _context) {
  "use strict";

  var Application, canvas, $p, bcr, application;
  // var onProgress = null;
  function setLoadingDisplay () {
    // Loading splash scene
    var splash = document.getElementById('splash');
    var progressBar = splash.querySelector('.progress-bar span');
    // onProgress = function (finish, total) {
    //     var percent = 100 * finish / total;
    //     if (progressBar) {
    //         progressBar.style.width = percent.toFixed(2) + '%';
    //     }
    // };
    splash.style.display = 'block';
    progressBar.style.width = '0%';

    cc.director.once(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
        splash.style.display = 'none';
    });
  }
  function onProgress(percent){
    var progressBar = splash.querySelector('.progress-bar span');
    // var percent = 100 * finish / total;
    if (progressBar) {
      progressBar.style.width = percent + '%';
    }
    
  }
  function topLevelImport(url) {
    return System["import"](url);
  }

  return {
    setters: [function (_applicationJs) {
      Application = _applicationJs.Application;
    }],
    execute: function () {
      canvas = document.getElementById('GameCanvas');
      $p = canvas.parentElement;
      bcr = $p.getBoundingClientRect();
      canvas.width = bcr.width;
      canvas.height = bcr.height;
      application = new Application();
      topLevelImport('cc').then(function (engine) {
        setLoadingDisplay();
        return application.init(engine);
      }).then(function () {
        // onProgress(50);
        return application.start();
      })["catch"](function (err) {
        console.error(err);
      });
    }
  };
});