"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unload = exports.load = exports.methods = void 0;
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
const package_json_1 = __importDefault(require("../package.json"));
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
exports.methods = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    openPanel() {
        Editor.Panel.open(package_json_1.default.name);
    },
    /**
     * @en Handle selection change event
     * @zh 处理选择变化事件
     * @param {'asset' | 'node'} type - 选择类型
     * @param {string} _uuid - 选中的 uuid（虽然传入，但我们使用 Editor.Selection 获取所有选中项）
     */
    async onSelectionSelect(type, _uuid) {
        var _a, _b, _c;
        // 只处理资源选择，不处理节点选择
        if (type !== 'asset') {
            return;
        }
        try {
            // 获取选中的所有资源 UUID
            const uuids = Editor.Selection.getSelected('asset');
            if (!uuids || uuids.length === 0 || uuids.length > 1) {
                return;
            }
            const assetUuid = uuids[0];
            // 查询资源信息
            const assetInfo = await Editor.Message.request('asset-db', 'query-asset-info', assetUuid);
            if (!assetInfo) {
                return;
            }
            // 检查是否是 prefab 文件（.prefab 扩展名）
            // 可以通过 path、url 或 name 来检查
            const isPrefab = ((_a = assetInfo.path) === null || _a === void 0 ? void 0 : _a.endsWith('.prefab')) ||
                ((_b = assetInfo.url) === null || _b === void 0 ? void 0 : _b.endsWith('.prefab')) ||
                ((_c = assetInfo.name) === null || _c === void 0 ? void 0 : _c.endsWith('.prefab'));
            if (isPrefab) {
                // 发送 uuid 到面板，让面板解析 prefab
                Editor.Message.broadcast(`${package_json_1.default.name}:prefab-selected`, assetUuid);
            }
            else {
                // 如果不是 prefab，清空面板显示
                Editor.Message.broadcast(`${package_json_1.default.name}:prefab-selected`, '');
            }
        }
        catch (error) {
            console.error('[prefab-analysis] 处理选择事件时出错:', error);
        }
    },
};
/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
function load() { }
exports.load = load;
/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
function unload() { }
exports.unload = unload;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFpbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NvdXJjZS9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLDZEQUE2RDtBQUM3RCxhQUFhO0FBQ2IsbUVBQTBDO0FBQzFDOzs7R0FHRztBQUNVLFFBQUEsT0FBTyxHQUE0QztJQUM1RDs7O09BR0c7SUFDSCxTQUFTO1FBQ0wsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsc0JBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBQ0Q7Ozs7O09BS0c7SUFDSCxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBc0IsRUFBRSxLQUFhOztRQUN6RCxrQkFBa0I7UUFDbEIsSUFBSSxJQUFJLEtBQUssT0FBTyxFQUFFO1lBQ2xCLE9BQU87U0FDVjtRQUVELElBQUk7WUFDQSxpQkFBaUI7WUFDakIsTUFBTSxLQUFLLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7WUFFcEQsSUFBSSxDQUFDLEtBQUssSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDbEQsT0FBTzthQUNWO1lBRUQsTUFBTSxTQUFTLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQzNCLFNBQVM7WUFDVCxNQUFNLFNBQVMsR0FBRyxNQUFNLE1BQU0sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxrQkFBa0IsRUFBRSxTQUFTLENBQUMsQ0FBQztZQUUxRixJQUFJLENBQUMsU0FBUyxFQUFFO2dCQUNaLE9BQU87YUFDVjtZQUVELCtCQUErQjtZQUMvQiwyQkFBMkI7WUFDM0IsTUFBTSxRQUFRLEdBQUcsQ0FBQSxNQUFBLFNBQVMsQ0FBQyxJQUFJLDBDQUFFLFFBQVEsQ0FBQyxTQUFTLENBQUM7aUJBQ3BDLE1BQUEsU0FBUyxDQUFDLEdBQUcsMENBQUUsUUFBUSxDQUFDLFNBQVMsQ0FBQyxDQUFBO2lCQUNsQyxNQUFBLFNBQVMsQ0FBQyxJQUFJLDBDQUFFLFFBQVEsQ0FBQyxTQUFTLENBQUMsQ0FBQSxDQUFDO1lBRXBELElBQUksUUFBUSxFQUFFO2dCQUNWLDJCQUEyQjtnQkFDM0IsTUFBTSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsR0FBRyxzQkFBVyxDQUFDLElBQUksa0JBQWtCLEVBQUUsU0FBUyxDQUFDLENBQUM7YUFDOUU7aUJBQU07Z0JBQ0gscUJBQXFCO2dCQUNyQixNQUFNLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLHNCQUFXLENBQUMsSUFBSSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQzthQUN2RTtTQUVKO1FBQUMsT0FBTyxLQUFLLEVBQUU7WUFDWixPQUFPLENBQUMsS0FBSyxDQUFDLDhCQUE4QixFQUFFLEtBQUssQ0FBQyxDQUFDO1NBQ3hEO0lBQ0wsQ0FBQztDQUNKLENBQUM7QUFFRjs7O0dBR0c7QUFDSCxTQUFnQixJQUFJLEtBQVcsQ0FBQztBQUFoQyxvQkFBZ0M7QUFFaEM7OztHQUdHO0FBQ0gsU0FBZ0IsTUFBTSxLQUFXLENBQUM7QUFBbEMsd0JBQWtDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9iYW4tdHMtY29tbWVudFxuLy8gQHRzLWlnbm9yZVxuaW1wb3J0IHBhY2thZ2VKU09OIGZyb20gJy4uL3BhY2thZ2UuanNvbic7XG4vKipcbiAqIEBlbiBSZWdpc3RyYXRpb24gbWV0aG9kIGZvciB0aGUgbWFpbiBwcm9jZXNzIG9mIEV4dGVuc2lvblxuICogQHpoIOS4uuaJqeWxleeahOS4u+i/m+eoi+eahOazqOWGjOaWueazlVxuICovXG5leHBvcnQgY29uc3QgbWV0aG9kczogeyBba2V5OiBzdHJpbmddOiAoLi4uYW55OiBhbnkpID0+IGFueSB9ID0ge1xuICAgIC8qKlxuICAgICAqIEBlbiBBIG1ldGhvZCB0aGF0IGNhbiBiZSB0cmlnZ2VyZWQgYnkgbWVzc2FnZVxuICAgICAqIEB6aCDpgJrov4cgbWVzc2FnZSDop6blj5HnmoTmlrnms5VcbiAgICAgKi9cbiAgICBvcGVuUGFuZWwoKSB7XG4gICAgICAgIEVkaXRvci5QYW5lbC5vcGVuKHBhY2thZ2VKU09OLm5hbWUpO1xuICAgIH0sXG4gICAgLyoqXG4gICAgICogQGVuIEhhbmRsZSBzZWxlY3Rpb24gY2hhbmdlIGV2ZW50XG4gICAgICogQHpoIOWkhOeQhumAieaLqeWPmOWMluS6i+S7tlxuICAgICAqIEBwYXJhbSB7J2Fzc2V0JyB8ICdub2RlJ30gdHlwZSAtIOmAieaLqeexu+Wei1xuICAgICAqIEBwYXJhbSB7c3RyaW5nfSBfdXVpZCAtIOmAieS4reeahCB1dWlk77yI6Jm954S25Lyg5YWl77yM5L2G5oiR5Lus5L2/55SoIEVkaXRvci5TZWxlY3Rpb24g6I635Y+W5omA5pyJ6YCJ5Lit6aG577yJXG4gICAgICovXG4gICAgYXN5bmMgb25TZWxlY3Rpb25TZWxlY3QodHlwZTogJ2Fzc2V0JyB8ICdub2RlJywgX3V1aWQ6IHN0cmluZyk6IFByb21pc2U8dm9pZD4ge1xuICAgICAgICAvLyDlj6rlpITnkIbotYTmupDpgInmi6nvvIzkuI3lpITnkIboioLngrnpgInmi6lcbiAgICAgICAgaWYgKHR5cGUgIT09ICdhc3NldCcpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICAvLyDojrflj5bpgInkuK3nmoTmiYDmnInotYTmupAgVVVJRFxuICAgICAgICAgICAgY29uc3QgdXVpZHMgPSBFZGl0b3IuU2VsZWN0aW9uLmdldFNlbGVjdGVkKCdhc3NldCcpO1xuICAgICAgICAgICAgXG4gICAgICAgICAgICBpZiAoIXV1aWRzIHx8IHV1aWRzLmxlbmd0aCA9PT0gMCB8fCB1dWlkcy5sZW5ndGggPiAxKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBjb25zdCBhc3NldFV1aWQgPSB1dWlkc1swXTtcbiAgICAgICAgICAgIC8vIOafpeivoui1hOa6kOS/oeaBr1xuICAgICAgICAgICAgY29uc3QgYXNzZXRJbmZvID0gYXdhaXQgRWRpdG9yLk1lc3NhZ2UucmVxdWVzdCgnYXNzZXQtZGInLCAncXVlcnktYXNzZXQtaW5mbycsIGFzc2V0VXVpZCk7XG4gICAgICAgICAgICBcbiAgICAgICAgICAgIGlmICghYXNzZXRJbmZvKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAvLyDmo4Dmn6XmmK/lkKbmmK8gcHJlZmFiIOaWh+S7tu+8iC5wcmVmYWIg5omp5bGV5ZCN77yJXG4gICAgICAgICAgICAvLyDlj6/ku6XpgJrov4cgcGF0aOOAgXVybCDmiJYgbmFtZSDmnaXmo4Dmn6VcbiAgICAgICAgICAgIGNvbnN0IGlzUHJlZmFiID0gYXNzZXRJbmZvLnBhdGg/LmVuZHNXaXRoKCcucHJlZmFiJykgfHwgXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYXNzZXRJbmZvLnVybD8uZW5kc1dpdGgoJy5wcmVmYWInKSB8fCBcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBhc3NldEluZm8ubmFtZT8uZW5kc1dpdGgoJy5wcmVmYWInKTtcbiAgICAgICAgICAgIFxuICAgICAgICAgICAgaWYgKGlzUHJlZmFiKSB7ICAgICAgICAgICAgICAgXG4gICAgICAgICAgICAgICAgLy8g5Y+R6YCBIHV1aWQg5Yiw6Z2i5p2/77yM6K6p6Z2i5p2/6Kej5p6QIHByZWZhYlxuICAgICAgICAgICAgICAgIEVkaXRvci5NZXNzYWdlLmJyb2FkY2FzdChgJHtwYWNrYWdlSlNPTi5uYW1lfTpwcmVmYWItc2VsZWN0ZWRgLCBhc3NldFV1aWQpO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAvLyDlpoLmnpzkuI3mmK8gcHJlZmFi77yM5riF56m66Z2i5p2/5pi+56S6XG4gICAgICAgICAgICAgICAgRWRpdG9yLk1lc3NhZ2UuYnJvYWRjYXN0KGAke3BhY2thZ2VKU09OLm5hbWV9OnByZWZhYi1zZWxlY3RlZGAsICcnKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIFxuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgY29uc29sZS5lcnJvcignW3ByZWZhYi1hbmFseXNpc10g5aSE55CG6YCJ5oup5LqL5Lu25pe25Ye66ZSZOicsIGVycm9yKTtcbiAgICAgICAgfVxuICAgIH0sXG59O1xuXG4vKipcbiAqIEBlbiBNZXRob2QgVHJpZ2dlcmVkIG9uIEV4dGVuc2lvbiBTdGFydHVwXG4gKiBAemgg5omp5bGV5ZCv5Yqo5pe26Kem5Y+R55qE5pa55rOVXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBsb2FkKCk6IHZvaWQgeyB9XG5cbi8qKlxuICogQGVuIE1ldGhvZCB0cmlnZ2VyZWQgd2hlbiB1bmluc3RhbGxpbmcgdGhlIGV4dGVuc2lvblxuICogQHpoIOWNuOi9veaJqeWxleaXtuinpuWPkeeahOaWueazlVxuICovXG5leHBvcnQgZnVuY3Rpb24gdW5sb2FkKCk6IHZvaWQgeyB9XG4iXX0=