// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import packageJSON from '../package.json';
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
export const methods: { [key: string]: (...any: any) => any } = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    openPanel() {
        Editor.Panel.open(packageJSON.name);
    },
    /**
     * @en Handle selection change event
     * @zh 处理选择变化事件
     * @param {'asset' | 'node'} type - 选择类型
     * @param {string} _uuid - 选中的 uuid（虽然传入，但我们使用 Editor.Selection 获取所有选中项）
     */
    async onSelectionSelect(type: 'asset' | 'node', _uuid: string): Promise<void> {
        // 只处理资源选择，不处理节点选择
        if (type !== 'asset') {
            return;
        }

        try {
            // 获取选中的所有资源 UUID
            const uuids = Editor.Selection.getSelected('asset');
            
            if (!uuids || uuids.length === 0 || uuids.length > 1) {
                return;
            }

            const assetUuid = uuids[0];
            // 查询资源信息
            const assetInfo = await Editor.Message.request('asset-db', 'query-asset-info', assetUuid);
            
            if (!assetInfo) {
                return;
            }

            // 检查是否是 prefab 文件（.prefab 扩展名）
            // 可以通过 path、url 或 name 来检查
            const isPrefab = assetInfo.path?.endsWith('.prefab') || 
                            assetInfo.url?.endsWith('.prefab') || 
                            assetInfo.name?.endsWith('.prefab');
            
            if (isPrefab) {               
                // 发送 uuid 到面板，让面板解析 prefab
                Editor.Message.broadcast(`${packageJSON.name}:prefab-selected`, assetUuid);
            } else {
                // 如果不是 prefab，清空面板显示
                Editor.Message.broadcast(`${packageJSON.name}:prefab-selected`, '');
            }
            
        } catch (error) {
            console.error('[prefab-analysis] 处理选择事件时出错:', error);
        }
    },
};

/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
export function load(): void { }

/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
export function unload(): void { }
