import {
    _decorator,
    Camera,
    Component,
    Director,
    director,
    dynamicAtlasManager,
    find,
    gfx,
    ImageAsset,
    instantiate,
    Node,
    NodeEventType,
    RenderTexture,
    size,
    Sprite,
    SpriteFrame,
    Texture2D,
    UITransform,
    v3,
    view,
} from 'cc';

const {ccclass, property, type} = _decorator;

export async function screenshotNode(node: Node) {
    const parent = find('CaptureCanvas');
    const newNode = instantiate(node);
    const layer = parent.layer;
    newNode.layer = layer;
    // removeNotRendererComponent(newNode);
    newNode.walk((n) => {
        n.layer = layer;
        // removeNotRendererComponent(n);
    });
    const ut = newNode.getComponent(UITransform);
    newNode.setPosition(v3(
        ut.width * (ut.anchorX - 0.5),
        ut.height * (ut.anchorY - 0.5),
    ));
    newNode.parent = parent;
    const sf = await screenshot({
        rt: true,
        w: ut.width,
        h: ut.height,
        x: newNode.worldPosition.x - ut.width * ut.anchorX,
        y: newNode.worldPosition.y - ut.height * ut.anchorY,
    });
    // newNode.destroy();
    return sf;
}

export function screenshot({
                               x, y, w, h, rt
                           }: {
    x?: number,
    y?: number,
    w?: number,         // width  需要整数！
    h?: number,         // height 需要整数！
    rt?: boolean,       // 是否翻转图片（截图默认是反过来的，翻转会比较慢 可以改用node.scaleY = -1
} = {}) {
    return new Promise<SpriteFrame>(async function (resolve) {
        const captureCamera = find('CaptureCanvas/CaptureCamera').getComponent(Camera);

        const viewSize = view.getVisibleSize();

        const s = size(
            Math.ceil(w || viewSize.width),
            Math.ceil(h || viewSize.height),
        );

        const renderTexture = new RenderTexture();

        renderTexture.reset(viewSize);
        captureCamera.targetTexture = renderTexture;

        const {width, height} = s;

        await new Promise(function (r) {
            director.once(Director.EVENT_AFTER_DRAW, r);
        });

        var buffer = renderTexture.readPixels(x || 0, y || 0, width, height);

        var rtBuffer = buffer;
        if (rt) {
            rtBuffer = new Uint8Array(width * height * 4);
            for (var i = height - 1; i >= 0; i--) {
                for (var j = 0; j < width; j++) {
                    rtBuffer[((height - 1 - i) * (width) + j) * 4 + 0] = buffer[(i * width + j) * 4 + 0];
                    rtBuffer[((height - 1 - i) * (width) + j) * 4 + 1] = buffer[(i * width + j) * 4 + 1];
                    rtBuffer[((height - 1 - i) * (width) + j) * 4 + 2] = buffer[(i * width + j) * 4 + 2];
                    rtBuffer[((height - 1 - i) * (width) + j) * 4 + 3] = buffer[(i * width + j) * 4 + 3];
                }
            }
        }

        const image = new ImageAsset({
            _data: rtBuffer,
            _compressed: false,
            width,
            height,
            format: gfx.Format.RGBA8,
        });
        const t = new Texture2D();
        t.image = image;

        const sf = new SpriteFrame();
        sf.texture = t;

        captureCamera.targetTexture = null;

        resolve(sf);
    });
}

@ccclass('Test')
export class Test extends Component {
    @type(Sprite)
    sprite: Sprite;

    @type(Node)
    copyNode: Node;

    start() {
        dynamicAtlasManager.enabled = false;
        this.node.getChildByName('Button').on(NodeEventType.TOUCH_END, this.click, this);
    }

    async click() {
        this.sprite.spriteFrame = await screenshotNode(this.copyNode);
    }
}


