"use strict";
cc._RF.push(module, '81a0fX1hB5DTb743hVLsigd', 'TableView');
// scripts/ui/TableView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var TableView = /** @class */ (function (_super) {
    __extends(TableView, _super);
    function TableView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.strokeGfx = null;
        _this.fillGfx = null;
        _this.rects = [];
        return _this;
    }
    TableView.prototype.onLoad = function () {
        this.fillGfx = this.node.getComponent(cc.Graphics);
    };
    TableView.prototype.start = function () {
        this.scheduleOnce(this.initStroke, 0);
    };
    TableView.prototype.initStroke = function () {
        this.strokeGfx.clear();
        this.drawTable(true);
        this.drawTable(false);
        EventManager_1.default.emit(Const_1.EventType.TABLE_INIT_OVER);
    };
    TableView.prototype.checkCross = function (wpos) {
        var boxWidth = 100;
        var cpos = this.node.convertToNodeSpaceAR(wpos);
        var rect = new cc.Rect(cpos.x - boxWidth / 2, cpos.y - boxWidth / 2, boxWidth, boxWidth);
        var gfx = this.fillGfx;
        var max = 0;
        var mid = 0;
        this.rects.forEach(function (r, index) {
            if (r.intersects(rect)) {
                var ri = new cc.Rect();
                r.intersection(ri, rect);
                var rs = ri.width * ri.height;
                max = Math.max(max, rs);
                if (max === rs) {
                    mid = index;
                }
            }
        });
        gfx.clear();
        this.rects.forEach(function (r, index) {
            if (max !== 0 && mid === index) {
                gfx.fillColor = cc.color(0, 255, 0, 255);
                gfx.fillRect(r.x, r.y, r.width, r.height);
            }
        });
    };
    TableView.prototype.drawTable = function (isLeft) {
        var boxWidth = 100;
        var count = 3;
        var gfx = this.strokeGfx;
        var width = this.node.width, height = this.node.height;
        var bottom = -height / 2;
        var delay = width / 2 - count * boxWidth;
        var sign = (isLeft ? -1 : 1);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom);
        gfx.lineTo((delay / 2) * sign, bottom);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth * count);
        gfx.lineTo((width / 2 - delay / 2) * sign, bottom + boxWidth * count);
        gfx.close();
        gfx.moveTo((delay / 2 + boxWidth) * sign, bottom);
        gfx.lineTo((delay / 2 + boxWidth) * sign, bottom + boxWidth * count);
        gfx.moveTo((delay / 2 + boxWidth * 2) * sign, bottom);
        gfx.lineTo((delay / 2 + boxWidth * 2) * sign, bottom + boxWidth * count);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom + boxWidth);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom + boxWidth * 2);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth * 2);
        gfx.stroke();
        for (var i = 0; i < count; ++i) {
            for (var j = 0; j < count; ++j) {
                var x = (delay / 2 + boxWidth * (i + (isLeft ? 1 : 0))) * sign;
                var y = bottom + boxWidth * j;
                var rect = new cc.Rect(x, y, boxWidth, boxWidth);
                this.rects.push(rect);
            }
        }
    };
    TableView.prototype.getRects = function () {
        return this.rects;
    };
    __decorate([
        property(cc.Graphics)
    ], TableView.prototype, "strokeGfx", void 0);
    TableView = __decorate([
        ccclass
    ], TableView);
    return TableView;
}(cc.Component));
exports.default = TableView;

cc._RF.pop();