
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/scripts/common/Const');
require('./assets/scripts/common/EventManager');
require('./assets/scripts/common/Tools');
require('./assets/scripts/model/GameModel');
require('./assets/scripts/prefab/Hero');
require('./assets/scripts/prefab/HeroList');
require('./assets/scripts/ui/ListView');
require('./assets/scripts/ui/TableView');
require('./assets/scripts/views/GameView');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/common/EventManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '846efnL7PFNDoxx7jZsg5Mw', 'EventManager');
// scripts/common/EventManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var EventManager = /** @class */ (function () {
    function EventManager() {
    }
    EventManager.emit = function (event, data) {
        var e = new cc.Event.EventCustom(event, true);
        data !== null && e.setUserData(data);
        this._target.dispatchEvent(e);
    };
    EventManager.on = function (event, func, target, useCapture) {
        this._target.on(event, func, target, useCapture);
    };
    EventManager.off = function (event, func, target) {
        this._target.off(event, func, target);
    };
    EventManager._target = new cc.EventTarget();
    return EventManager;
}());
exports.default = EventManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcY29tbW9uXFxFdmVudE1hbmFnZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTtJQUFBO0lBZ0JBLENBQUM7SUFiaUIsaUJBQUksR0FBbEIsVUFBb0IsS0FBYSxFQUFFLElBQVU7UUFDekMsSUFBSSxDQUFDLEdBQUcsSUFBSSxFQUFFLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDOUMsSUFBSSxLQUFLLElBQUksSUFBSSxDQUFDLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFYSxlQUFFLEdBQWhCLFVBQWlCLEtBQWEsRUFBRSxJQUFjLEVBQUUsTUFBVyxFQUFFLFVBQW1CO1FBQzVFLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFYSxnQkFBRyxHQUFqQixVQUFrQixLQUFhLEVBQUUsSUFBYyxFQUFFLE1BQVc7UUFDeEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBZGMsb0JBQU8sR0FBRyxJQUFJLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQWVsRCxtQkFBQztDQWhCRCxBQWdCQyxJQUFBO2tCQWhCb0IsWUFBWSIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGNsYXNzIEV2ZW50TWFuYWdlciB7XHJcbiAgICBwcml2YXRlIHN0YXRpYyBfdGFyZ2V0ID0gbmV3IGNjLkV2ZW50VGFyZ2V0KCk7XHJcblxyXG4gICAgcHVibGljIHN0YXRpYyBlbWl0IChldmVudDogc3RyaW5nLCBkYXRhPzogYW55KSB7XHJcbiAgICAgICAgbGV0IGUgPSBuZXcgY2MuRXZlbnQuRXZlbnRDdXN0b20oZXZlbnQsIHRydWUpO1xyXG4gICAgICAgIGRhdGEgIT09IG51bGwgJiYgZS5zZXRVc2VyRGF0YShkYXRhKTtcclxuICAgICAgICB0aGlzLl90YXJnZXQuZGlzcGF0Y2hFdmVudChlKTtcclxuICAgIH1cclxuXHJcbiAgICBwdWJsaWMgc3RhdGljIG9uKGV2ZW50OiBzdHJpbmcsIGZ1bmM6IEZ1bmN0aW9uLCB0YXJnZXQ/OmFueSwgdXNlQ2FwdHVyZT86Ym9vbGVhbikge1xyXG4gICAgICAgIHRoaXMuX3RhcmdldC5vbihldmVudCwgZnVuYywgdGFyZ2V0LCB1c2VDYXB0dXJlKTtcclxuICAgIH1cclxuXHJcbiAgICBwdWJsaWMgc3RhdGljIG9mZihldmVudDogc3RyaW5nLCBmdW5jOiBGdW5jdGlvbiwgdGFyZ2V0PzphbnkpIHtcclxuICAgICAgICB0aGlzLl90YXJnZXQub2ZmKGV2ZW50LCBmdW5jLCB0YXJnZXQpO1xyXG4gICAgfVxyXG59XHJcbiJdfQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/prefab/HeroList.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'ccadfXHvMBM54U3BO1u9hS/', 'HeroList');
// scripts/prefab/HeroList.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var HeroList = /** @class */ (function (_super) {
    __extends(HeroList, _super);
    function HeroList() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gfx = null;
        return _this;
    }
    HeroList.prototype.onLoad = function () {
        this.gfx = this.node.getComponent(cc.Graphics);
    };
    HeroList.prototype.start = function () {
        this.scheduleOnce(this.initStroke, 0);
    };
    HeroList.prototype.initStroke = function () {
        this.gfx.fillRect(-this.node.width / 2, -this.node.height / 2, this.node.width, this.node.height);
        this.gfx.fill();
        this.gfx.rect(-this.node.width / 2, -this.node.height / 2, this.node.width, this.node.height);
        this.gfx.stroke();
    };
    HeroList = __decorate([
        ccclass
    ], HeroList);
    return HeroList;
}(cc.Component));
exports.default = HeroList;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/ui/ListView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '9d7b5TdwExE/pkV2ieS6idW', 'ListView');
// scripts/ui/ListView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ListView = /** @class */ (function (_super) {
    __extends(ListView, _super);
    function ListView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gfx = null;
        return _this;
    }
    ListView.prototype.onLoad = function () {
        this.gfx = this.node.getComponent(cc.Graphics);
    };
    ListView.prototype.start = function () {
        this.scheduleOnce(this.initStroke, 0);
    };
    ListView.prototype.initStroke = function () {
        this.gfx.rect(-this.node.width / 2, -this.node.height / 2, this.node.width, this.node.height);
        this.gfx.stroke();
    };
    ListView = __decorate([
        ccclass
    ], ListView);
    return ListView;
}(cc.Component));
exports.default = ListView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcdWlcXExpc3RWaWV3LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUFNLElBQUEsS0FBc0IsRUFBRSxDQUFDLFVBQVUsRUFBbEMsT0FBTyxhQUFBLEVBQUUsUUFBUSxjQUFpQixDQUFDO0FBRzFDO0lBQXNDLDRCQUFZO0lBQWxEO1FBQUEscUVBZUM7UUFkVyxTQUFHLEdBQWdCLElBQUksQ0FBQzs7SUFjcEMsQ0FBQztJQVpHLHlCQUFNLEdBQU47UUFDSSxJQUFJLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRUQsd0JBQUssR0FBTDtRQUNJLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQsNkJBQVUsR0FBVjtRQUNJLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEdBQUMsQ0FBQyxFQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUMsQ0FBQyxFQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDdkYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUN0QixDQUFDO0lBZGdCLFFBQVE7UUFENUIsT0FBTztPQUNhLFFBQVEsQ0FlNUI7SUFBRCxlQUFDO0NBZkQsQUFlQyxDQWZxQyxFQUFFLENBQUMsU0FBUyxHQWVqRDtrQkFmb0IsUUFBUSIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IHtjY2NsYXNzLCBwcm9wZXJ0eX0gPSBjYy5fZGVjb3JhdG9yO1xyXG5cclxuQGNjY2xhc3NcclxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTGlzdFZpZXcgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xyXG4gICAgcHJpdmF0ZSBnZng6IGNjLkdyYXBoaWNzID0gbnVsbDtcclxuXHJcbiAgICBvbkxvYWQgKCkge1xyXG4gICAgICAgIHRoaXMuZ2Z4ID0gdGhpcy5ub2RlLmdldENvbXBvbmVudChjYy5HcmFwaGljcyk7XHJcbiAgICB9XHJcblxyXG4gICAgc3RhcnQgKCkge1xyXG4gICAgICAgIHRoaXMuc2NoZWR1bGVPbmNlKHRoaXMuaW5pdFN0cm9rZSwgMCk7XHJcbiAgICB9XHJcblxyXG4gICAgaW5pdFN0cm9rZSAoKSB7XHJcbiAgICAgICAgdGhpcy5nZngucmVjdCgtdGhpcy5ub2RlLndpZHRoLzIsLXRoaXMubm9kZS5oZWlnaHQvMix0aGlzLm5vZGUud2lkdGgsdGhpcy5ub2RlLmhlaWdodCk7XHJcbiAgICAgICAgdGhpcy5nZnguc3Ryb2tlKCk7XHJcbiAgICB9XHJcbn0iXX0=
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/common/Const.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '9f654Hccu5ES6ZMaIiGjeYn', 'Const');
// scripts/common/Const.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HERO_COUNT = exports.MAX_DEFENCE = exports.MAX_ENERGY = exports.CAMPS = exports.EventType = void 0;
var EventType;
(function (EventType) {
    EventType["TABLE_INIT_OVER"] = "table_init_over";
    EventType["HERO_ATTACK"] = "hero_attack";
    EventType["HERO_ATTACK_OVER"] = "hero_attack_over";
})(EventType = exports.EventType || (exports.EventType = {}));
;
var CAMPS;
(function (CAMPS) {
    CAMPS[CAMPS["LEFT"] = 0] = "LEFT";
    CAMPS[CAMPS["RIGHT"] = 1] = "RIGHT";
})(CAMPS = exports.CAMPS || (exports.CAMPS = {}));
;
exports.MAX_ENERGY = 100;
exports.MAX_DEFENCE = 100;
exports.HERO_COUNT = 5;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcY29tbW9uXFxDb25zdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxJQUFZLFNBSVg7QUFKRCxXQUFZLFNBQVM7SUFDakIsZ0RBQW1DLENBQUE7SUFDbkMsd0NBQTJCLENBQUE7SUFDM0Isa0RBQXFDLENBQUE7QUFDekMsQ0FBQyxFQUpXLFNBQVMsR0FBVCxpQkFBUyxLQUFULGlCQUFTLFFBSXBCO0FBQUEsQ0FBQztBQUVGLElBQWtCLEtBR2pCO0FBSEQsV0FBa0IsS0FBSztJQUNuQixpQ0FBSSxDQUFBO0lBQ0osbUNBQUssQ0FBQTtBQUNULENBQUMsRUFIaUIsS0FBSyxHQUFMLGFBQUssS0FBTCxhQUFLLFFBR3RCO0FBQUEsQ0FBQztBQUVXLFFBQUEsVUFBVSxHQUFHLEdBQUcsQ0FBQztBQUNqQixRQUFBLFdBQVcsR0FBRyxHQUFHLENBQUM7QUFDbEIsUUFBQSxVQUFVLEdBQUcsQ0FBQyxDQUFDIiwiZmlsZSI6IiIsInNvdXJjZVJvb3QiOiIvIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGVudW0gRXZlbnRUeXBlIHtcclxuICAgIFRBQkxFX0lOSVRfT1ZFUiA9IFwidGFibGVfaW5pdF9vdmVyXCIsXHJcbiAgICBIRVJPX0FUVEFDSyA9IFwiaGVyb19hdHRhY2tcIixcclxuICAgIEhFUk9fQVRUQUNLX09WRVIgPSBcImhlcm9fYXR0YWNrX292ZXJcIixcclxufTtcclxuXHJcbmV4cG9ydCBjb25zdCBlbnVtIENBTVBTIHtcclxuICAgIExFRlQsXHJcbiAgICBSSUdIVFxyXG59O1xyXG5cclxuZXhwb3J0IGNvbnN0IE1BWF9FTkVSR1kgPSAxMDA7XHJcbmV4cG9ydCBjb25zdCBNQVhfREVGRU5DRSA9IDEwMDtcclxuZXhwb3J0IGNvbnN0IEhFUk9fQ09VTlQgPSA1OyJdfQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/views/GameView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'cf647gIawpJX6Y5aoFpH4nR', 'GameView');
// scripts/views/GameView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var Tools_1 = require("../common/Tools");
var Hero_1 = require("../prefab/Hero");
var TableView_1 = require("../ui/TableView");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var GameView = /** @class */ (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.bg = null;
        _this.table = null;
        _this.hero = null;
        _this.leftList = [];
        _this.rightList = [];
        _this.isGaming = false;
        return _this;
    }
    GameView.prototype.onLoad = function () {
        EventManager_1.default.on(Const_1.EventType.TABLE_INIT_OVER, this.initHeros, this);
        EventManager_1.default.on(Const_1.EventType.HERO_ATTACK, this.doAttack, this);
        EventManager_1.default.on(Const_1.EventType.HERO_ATTACK, this.checkGameOver, this);
    };
    GameView.prototype.onDestroy = function () {
        EventManager_1.default.off(Const_1.EventType.TABLE_INIT_OVER, this.initHeros, this);
        EventManager_1.default.off(Const_1.EventType.HERO_ATTACK, this.doAttack, this);
        EventManager_1.default.off(Const_1.EventType.HERO_ATTACK_OVER, this.checkGameOver, this);
    };
    GameView.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            Tools_1.default.setOffsetUV(_this.bg);
        }, 0);
    };
    GameView.prototype.initHeros = function () {
        var rects = this.table.getRects();
        var leftRects = rects.slice(0, 9);
        var rightRects = rects.slice(9);
        var id = 10000;
        var _loop_1 = function (i) {
            var heroNode = cc.instantiate(this_1.hero);
            var hero = heroNode.getComponent(Hero_1.default);
            this_1.node.addChild(heroNode);
            var rect = leftRects[Math.floor(Math.random() * leftRects.length)];
            leftRects = leftRects.filter(function (r) { return !r.equals(rect); });
            var wpos = this_1.table.node.convertToWorldSpaceAR(cc.v2(rect.x + rect.width / 2, rect.y + rect.height / 2));
            var npos = this_1.node.convertToNodeSpaceAR(wpos);
            hero.onInit(npos, ++id);
            hero.camp = Const_1.CAMPS.LEFT;
            this_1.leftList.push(heroNode);
        };
        var this_1 = this;
        for (var i = 0; i < Const_1.HERO_COUNT; ++i) {
            _loop_1(i);
        }
        var _loop_2 = function (i) {
            var heroNode = cc.instantiate(this_2.hero);
            var hero = heroNode.getComponent(Hero_1.default);
            this_2.node.addChild(heroNode);
            var rect = rightRects[Math.floor(Math.random() * rightRects.length)];
            rightRects = rightRects.filter(function (r) { return !r.equals(rect); });
            var wpos = this_2.table.node.convertToWorldSpaceAR(cc.v2(rect.x + rect.width / 2, rect.y + rect.height / 2));
            var npos = this_2.node.convertToNodeSpaceAR(wpos);
            hero.onInit(npos, ++id);
            hero.camp = Const_1.CAMPS.RIGHT;
            this_2.rightList.push(heroNode);
        };
        var this_2 = this;
        for (var i = 0; i < Const_1.HERO_COUNT; ++i) {
            _loop_2(i);
        }
        this.isGaming = true;
    };
    GameView.prototype.doAttack = function (event) {
        var data = event.getUserData();
        var _a = this.getAttackHero(data), camp = _a[0], hero = _a[1];
        var target = this.getRandomTarget(camp);
        if (!target) {
            this.isGaming = false;
            return;
        }
        hero.doAttack(target.pos);
        target.onAttack(hero);
    };
    GameView.prototype.getAttackHero = function (data) {
        var camp = data.camp;
        var list, hero;
        switch (camp) {
            case Const_1.CAMPS.LEFT:
                list = this.leftList;
                break;
            case Const_1.CAMPS.RIGHT:
                list = this.rightList;
                break;
            default:
                console.log("get hero error==>", data);
                return;
        }
        list.forEach(function (item) {
            if (item.getComponent(Hero_1.default).hero_id === data.id) {
                hero = item.getComponent(Hero_1.default);
                return;
            }
        });
        return [camp, hero];
    };
    GameView.prototype.getRandomTarget = function (camp) {
        var list, target;
        switch (camp) {
            case Const_1.CAMPS.LEFT:
                list = this.rightList.filter(function (item) {
                    var hero = item.getComponent(Hero_1.default);
                    return !hero.isdead;
                });
                break;
            case Const_1.CAMPS.RIGHT:
                list = this.leftList.filter(function (item) {
                    var hero = item.getComponent(Hero_1.default);
                    return !hero.isdead;
                });
                break;
            default:
                console.log("get target error==>", camp);
                return;
        }
        if (list.length === 0) {
            return;
        }
        target = list[Math.floor(Math.random() * list.length)];
        return target.getComponent(Hero_1.default);
    };
    GameView.prototype.checkGameOver = function () {
        var leftList = this.leftList.filter(function (n) { return !n.getComponent(Hero_1.default).isdead; });
        var rightList = this.rightList.filter(function (n) { return !n.getComponent(Hero_1.default).isdead; });
        this.isGaming = leftList.length > 0 && rightList.length > 0;
    };
    GameView.prototype.update = function (dt) {
        if (this.isGaming) {
            this.leftList.forEach(function (node) {
                node.getComponent(Hero_1.default).getEnergy(dt);
            });
            this.rightList.forEach(function (node) {
                node.getComponent(Hero_1.default).getEnergy(dt);
            });
        }
    };
    __decorate([
        property(cc.Sprite)
    ], GameView.prototype, "bg", void 0);
    __decorate([
        property(TableView_1.default)
    ], GameView.prototype, "table", void 0);
    __decorate([
        property(cc.Prefab)
    ], GameView.prototype, "hero", void 0);
    GameView = __decorate([
        ccclass
    ], GameView);
    return GameView;
}(cc.Component));
exports.default = GameView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/prefab/Hero.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0f1124T45JGQrc2TGpj9mtf', 'Hero');
// scripts/prefab/Hero.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var GameModel_1 = require("../model/GameModel");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Hero = /** @class */ (function (_super) {
    __extends(Hero, _super);
    function Hero() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 节点
        _this.lb_name = null;
        _this.lb_hp = null;
        _this.lb_data = null;
        _this.pb_hp = null;
        _this.pb_eg = null;
        // 人物属性
        _this._hp = 0;
        _this._maxHp = 0;
        _this._hero_name = "";
        _this._attack = 0;
        _this._defence = 0;
        _this._speed = 0;
        _this._dead = false;
        _this._camp = 0;
        _this._pos = cc.v2(0, 0);
        _this._energy = 0;
        _this._hero_id = 0;
        return _this;
    }
    Object.defineProperty(Hero.prototype, "hp", {
        get: function () {
            return this._hp;
        },
        set: function (value) {
            this._hp = Math.min(Math.round(value), this.maxHp);
            if (this.hp <= 0) {
                this.isdead = true;
            }
            else {
                this.lb_hp.string = this.hp + "/" + this.maxHp;
                this.pb_hp.progress = this.hp / this.maxHp;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "maxHp", {
        get: function () {
            return this._maxHp;
        },
        set: function (value) {
            var i_hp = Math.round(value);
            this._maxHp = i_hp;
            this.hp = i_hp;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "heroname", {
        get: function () {
            return this._hero_name;
        },
        set: function (value) {
            this._hero_name = value;
            this.lb_name.string = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "attack", {
        get: function () {
            return this._attack;
        },
        set: function (value) {
            this._attack = Math.round(value);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "defence", {
        get: function () {
            return this._defence;
        },
        set: function (value) {
            this._defence = Math.min(Math.round(value), Const_1.MAX_DEFENCE);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "speed", {
        get: function () {
            return this._speed;
        },
        set: function (value) {
            this._speed = Math.round(value);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "isdead", {
        get: function () {
            return this._dead;
        },
        set: function (value) {
            this._dead = value;
            this.node.active = !value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "camp", {
        get: function () {
            return this._camp;
        },
        set: function (value) {
            this._camp = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "pos", {
        get: function () {
            return this._pos;
        },
        set: function (value) {
            if (!this._pos.equals(value)) {
                this._pos = value;
            }
            this.node.setPosition(this.pos);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "energy", {
        get: function () {
            return this._energy;
        },
        set: function (value) {
            this._energy = Math.min(value, Const_1.MAX_ENERGY);
            this.pb_eg.progress = this.energy / Const_1.MAX_ENERGY;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "hero_id", {
        get: function () {
            return this._hero_id;
        },
        enumerable: false,
        configurable: true
    });
    Hero.prototype.onInit = function (npos, id) {
        var names = ["曹操", "刘备", "孙权", "陆逊", "周瑜", "诸葛亮", "司马懿", "郭嘉", "荀彧", "戏志才", "贾诩", "鲁肃", "法正", "姜维", "赵云", "吕布", "关羽", "张飞"];
        var rand = Math.random();
        this.heroname = names[Math.floor(rand * names.length)];
        this.maxHp = 200 + rand * 100;
        this.attack = 50 + rand * 20;
        this.defence = 20 + rand * 10;
        this.speed = 20 + rand * 5;
        this.isdead = false;
        this.pos = npos;
        this.energy = 0;
        this._hero_id = id;
    };
    Hero.prototype.getEnergy = function (dt) {
        this.energy += this.speed * dt;
        if (this.energy >= Const_1.MAX_ENERGY) {
            var data = { camp: this.camp, id: this.hero_id };
            EventManager_1.default.emit(Const_1.EventType.HERO_ATTACK, data);
            this.energy = 0;
        }
    };
    Hero.prototype.doAttack = function (pos) {
        var sign = this.camp === Const_1.CAMPS.LEFT ? -1 : 1;
        var tpos = pos.add(cc.v2(this.node.width * 0.9 * sign, 0));
        cc.tween(this.node)
            .to(.1, { x: tpos.x, y: tpos.y }, { easing: 'cubicOut' })
            .to(.1, { x: this.pos.x, y: this.pos.y }, { easing: 'cubicOut' })
            .start();
    };
    Hero.prototype.onAttack = function (from) {
        var _this = this;
        var damage = GameModel_1.default.calculateDamage(from.attack, this.defence);
        cc.tween(this.node)
            .delay(.1)
            .to(.05, { scale: .8 })
            .call(function () {
            _this.hp -= damage;
            EventManager_1.default.emit(Const_1.EventType.HERO_ATTACK_OVER);
        })
            .to(.05, { scale: 1 })
            .start();
    };
    Hero.prototype.displayData = function () {
        var str = "\u653B:" + this.attack + " \u9632:" + this.defence + " \u901F:" + this.speed;
        this.lb_data.string = str;
    };
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_name", void 0);
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_hp", void 0);
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_data", void 0);
    __decorate([
        property(cc.ProgressBar)
    ], Hero.prototype, "pb_hp", void 0);
    __decorate([
        property(cc.ProgressBar)
    ], Hero.prototype, "pb_eg", void 0);
    Hero = __decorate([
        ccclass
    ], Hero);
    return Hero;
}(cc.Component));
exports.default = Hero;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/ui/TableView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '81a0fX1hB5DTb743hVLsigd', 'TableView');
// scripts/ui/TableView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var TableView = /** @class */ (function (_super) {
    __extends(TableView, _super);
    function TableView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.strokeGfx = null;
        _this.fillGfx = null;
        _this.rects = [];
        return _this;
    }
    TableView.prototype.onLoad = function () {
        this.fillGfx = this.node.getComponent(cc.Graphics);
    };
    TableView.prototype.start = function () {
        this.scheduleOnce(this.initStroke, 0);
    };
    TableView.prototype.initStroke = function () {
        this.strokeGfx.clear();
        this.drawTable(true);
        this.drawTable(false);
        EventManager_1.default.emit(Const_1.EventType.TABLE_INIT_OVER);
    };
    TableView.prototype.checkCross = function (wpos) {
        var boxWidth = 100;
        var cpos = this.node.convertToNodeSpaceAR(wpos);
        var rect = new cc.Rect(cpos.x - boxWidth / 2, cpos.y - boxWidth / 2, boxWidth, boxWidth);
        var gfx = this.fillGfx;
        var max = 0;
        var mid = 0;
        this.rects.forEach(function (r, index) {
            if (r.intersects(rect)) {
                var ri = new cc.Rect();
                r.intersection(ri, rect);
                var rs = ri.width * ri.height;
                max = Math.max(max, rs);
                if (max === rs) {
                    mid = index;
                }
            }
        });
        gfx.clear();
        this.rects.forEach(function (r, index) {
            if (max !== 0 && mid === index) {
                gfx.fillColor = cc.color(0, 255, 0, 255);
                gfx.fillRect(r.x, r.y, r.width, r.height);
            }
        });
    };
    TableView.prototype.drawTable = function (isLeft) {
        var boxWidth = 100;
        var count = 3;
        var gfx = this.strokeGfx;
        var width = this.node.width, height = this.node.height;
        var bottom = -height / 2;
        var delay = width / 2 - count * boxWidth;
        var sign = (isLeft ? -1 : 1);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom);
        gfx.lineTo((delay / 2) * sign, bottom);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth * count);
        gfx.lineTo((width / 2 - delay / 2) * sign, bottom + boxWidth * count);
        gfx.close();
        gfx.moveTo((delay / 2 + boxWidth) * sign, bottom);
        gfx.lineTo((delay / 2 + boxWidth) * sign, bottom + boxWidth * count);
        gfx.moveTo((delay / 2 + boxWidth * 2) * sign, bottom);
        gfx.lineTo((delay / 2 + boxWidth * 2) * sign, bottom + boxWidth * count);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom + boxWidth);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom + boxWidth * 2);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth * 2);
        gfx.stroke();
        for (var i = 0; i < count; ++i) {
            for (var j = 0; j < count; ++j) {
                var x = (delay / 2 + boxWidth * (i + (isLeft ? 1 : 0))) * sign;
                var y = bottom + boxWidth * j;
                var rect = new cc.Rect(x, y, boxWidth, boxWidth);
                this.rects.push(rect);
            }
        }
    };
    TableView.prototype.getRects = function () {
        return this.rects;
    };
    __decorate([
        property(cc.Graphics)
    ], TableView.prototype, "strokeGfx", void 0);
    TableView = __decorate([
        ccclass
    ], TableView);
    return TableView;
}(cc.Component));
exports.default = TableView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/common/Tools.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'aed90YH+XFPlYsMJTe5Bq8J', 'Tools');
// scripts/common/Tools.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Tools = /** @class */ (function () {
    function Tools() {
    }
    Tools.setOffsetUV = function (sp, offset, rotated) {
        if (offset === void 0) { offset = "u_uvOffset"; }
        if (rotated === void 0) { rotated = "u_uvRotated"; }
        var frame = sp.spriteFrame;
        //@ts-ignore
        var uvs = frame.uv;
        var material = sp.getMaterial(0);
        var l = 0, r = 0, b = 1, t = 1;
        l = uvs[0];
        t = uvs[5];
        r = uvs[6];
        b = uvs[3];
        var u_uvOffset = new cc.Vec4(l, t, r, b);
        var u_uvRotated = frame.isRotated() ? 1.0 : 0.0;
        material.setProperty(offset, u_uvOffset);
        material.setProperty(rotated, u_uvRotated);
    };
    return Tools;
}());
exports.default = Tools;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/model/GameModel.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '07c5fo94rFHc5BOsxT7ODC9', 'GameModel');
// scripts/model/GameModel.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var GameModel = /** @class */ (function () {
    function GameModel() {
    }
    GameModel.calculateDamage = function (attack, defence) {
        return Math.ceil(attack * (Const_1.MAX_DEFENCE - defence) / Const_1.MAX_DEFENCE);
    };
    return GameModel;
}());
exports.default = GameModel;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0c1xcbW9kZWxcXEdhbWVNb2RlbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7OztBQUFBLHlDQUE4QztBQUU5QztJQUFBO0lBS0EsQ0FBQztJQUhpQix5QkFBZSxHQUE3QixVQUErQixNQUFjLEVBQUUsT0FBZTtRQUMxRCxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsbUJBQVcsR0FBRyxPQUFPLENBQUMsR0FBRyxtQkFBVyxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUNMLGdCQUFDO0FBQUQsQ0FMQSxBQUtDLElBQUEiLCJmaWxlIjoiIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBNQVhfREVGRU5DRSB9IGZyb20gXCIuLi9jb21tb24vQ29uc3RcIjtcclxuXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEdhbWVNb2RlbCB7XHJcblxyXG4gICAgcHVibGljIHN0YXRpYyBjYWxjdWxhdGVEYW1hZ2UgKGF0dGFjazogbnVtYmVyLCBkZWZlbmNlOiBudW1iZXIpIHtcclxuICAgICAgICByZXR1cm4gTWF0aC5jZWlsKGF0dGFjayAqIChNQVhfREVGRU5DRSAtIGRlZmVuY2UpIC8gTUFYX0RFRkVOQ0UpO1xyXG4gICAgfVxyXG59XHJcbiJdfQ==
//------QC-SOURCE-SPLIT------
