
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/prefab/Hero.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0f1124T45JGQrc2TGpj9mtf', 'Hero');
// scripts/prefab/Hero.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var GameModel_1 = require("../model/GameModel");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Hero = /** @class */ (function (_super) {
    __extends(Hero, _super);
    function Hero() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 节点
        _this.lb_name = null;
        _this.lb_hp = null;
        _this.lb_data = null;
        _this.pb_hp = null;
        _this.pb_eg = null;
        // 人物属性
        _this._hp = 0;
        _this._maxHp = 0;
        _this._hero_name = "";
        _this._attack = 0;
        _this._defence = 0;
        _this._speed = 0;
        _this._dead = false;
        _this._camp = 0;
        _this._pos = cc.v2(0, 0);
        _this._energy = 0;
        _this._hero_id = 0;
        return _this;
    }
    Object.defineProperty(Hero.prototype, "hp", {
        get: function () {
            return this._hp;
        },
        set: function (value) {
            this._hp = Math.min(Math.round(value), this.maxHp);
            if (this.hp <= 0) {
                this.isdead = true;
            }
            else {
                this.lb_hp.string = this.hp + "/" + this.maxHp;
                this.pb_hp.progress = this.hp / this.maxHp;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "maxHp", {
        get: function () {
            return this._maxHp;
        },
        set: function (value) {
            var i_hp = Math.round(value);
            this._maxHp = i_hp;
            this.hp = i_hp;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "heroname", {
        get: function () {
            return this._hero_name;
        },
        set: function (value) {
            this._hero_name = value;
            this.lb_name.string = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "attack", {
        get: function () {
            return this._attack;
        },
        set: function (value) {
            this._attack = Math.round(value);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "defence", {
        get: function () {
            return this._defence;
        },
        set: function (value) {
            this._defence = Math.min(Math.round(value), Const_1.MAX_DEFENCE);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "speed", {
        get: function () {
            return this._speed;
        },
        set: function (value) {
            this._speed = Math.round(value);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "isdead", {
        get: function () {
            return this._dead;
        },
        set: function (value) {
            this._dead = value;
            this.node.active = !value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "camp", {
        get: function () {
            return this._camp;
        },
        set: function (value) {
            this._camp = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "pos", {
        get: function () {
            return this._pos;
        },
        set: function (value) {
            if (!this._pos.equals(value)) {
                this._pos = value;
            }
            this.node.setPosition(this.pos);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "energy", {
        get: function () {
            return this._energy;
        },
        set: function (value) {
            this._energy = Math.min(value, Const_1.MAX_ENERGY);
            this.pb_eg.progress = this.energy / Const_1.MAX_ENERGY;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "hero_id", {
        get: function () {
            return this._hero_id;
        },
        enumerable: false,
        configurable: true
    });
    Hero.prototype.onInit = function (npos, id) {
        var names = ["曹操", "刘备", "孙权", "陆逊", "周瑜", "诸葛亮", "司马懿", "郭嘉", "荀彧", "戏志才", "贾诩", "鲁肃", "法正", "姜维", "赵云", "吕布", "关羽", "张飞"];
        var rand = Math.random();
        this.heroname = names[Math.floor(rand * names.length)];
        this.maxHp = 200 + rand * 100;
        this.attack = 50 + rand * 20;
        this.defence = 20 + rand * 10;
        this.speed = 20 + rand * 5;
        this.isdead = false;
        this.pos = npos;
        this.energy = 0;
        this._hero_id = id;
    };
    Hero.prototype.getEnergy = function (dt) {
        this.energy += this.speed * dt;
        if (this.energy >= Const_1.MAX_ENERGY) {
            var data = { camp: this.camp, id: this.hero_id };
            EventManager_1.default.emit(Const_1.EventType.HERO_ATTACK, data);
            this.energy = 0;
        }
    };
    Hero.prototype.doAttack = function (pos) {
        var sign = this.camp === Const_1.CAMPS.LEFT ? -1 : 1;
        var tpos = pos.add(cc.v2(this.node.width * 0.9 * sign, 0));
        cc.tween(this.node)
            .to(.1, { x: tpos.x, y: tpos.y }, { easing: 'cubicOut' })
            .to(.1, { x: this.pos.x, y: this.pos.y }, { easing: 'cubicOut' })
            .start();
    };
    Hero.prototype.onAttack = function (from) {
        var _this = this;
        var damage = GameModel_1.default.calculateDamage(from.attack, this.defence);
        cc.tween(this.node)
            .delay(.1)
            .to(.05, { scale: .8 })
            .call(function () {
            _this.hp -= damage;
            EventManager_1.default.emit(Const_1.EventType.HERO_ATTACK_OVER);
        })
            .to(.05, { scale: 1 })
            .start();
    };
    Hero.prototype.displayData = function () {
        var str = "\u653B:" + this.attack + " \u9632:" + this.defence + " \u901F:" + this.speed;
        this.lb_data.string = str;
    };
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_name", void 0);
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_hp", void 0);
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_data", void 0);
    __decorate([
        property(cc.ProgressBar)
    ], Hero.prototype, "pb_hp", void 0);
    __decorate([
        property(cc.ProgressBar)
    ], Hero.prototype, "pb_eg", void 0);
    Hero = __decorate([
        ccclass
    ], Hero);
    return Hero;
}(cc.Component));
exports.default = Hero;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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