
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/ui/TableView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '81a0fX1hB5DTb743hVLsigd', 'TableView');
// scripts/ui/TableView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var TableView = /** @class */ (function (_super) {
    __extends(TableView, _super);
    function TableView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.strokeGfx = null;
        _this.fillGfx = null;
        _this.rects = [];
        return _this;
    }
    TableView.prototype.onLoad = function () {
        this.fillGfx = this.node.getComponent(cc.Graphics);
    };
    TableView.prototype.start = function () {
        this.scheduleOnce(this.initStroke, 0);
    };
    TableView.prototype.initStroke = function () {
        this.strokeGfx.clear();
        this.drawTable(true);
        this.drawTable(false);
        EventManager_1.default.emit(Const_1.EventType.TABLE_INIT_OVER);
    };
    TableView.prototype.checkCross = function (wpos) {
        var boxWidth = 100;
        var cpos = this.node.convertToNodeSpaceAR(wpos);
        var rect = new cc.Rect(cpos.x - boxWidth / 2, cpos.y - boxWidth / 2, boxWidth, boxWidth);
        var gfx = this.fillGfx;
        var max = 0;
        var mid = 0;
        this.rects.forEach(function (r, index) {
            if (r.intersects(rect)) {
                var ri = new cc.Rect();
                r.intersection(ri, rect);
                var rs = ri.width * ri.height;
                max = Math.max(max, rs);
                if (max === rs) {
                    mid = index;
                }
            }
        });
        gfx.clear();
        this.rects.forEach(function (r, index) {
            if (max !== 0 && mid === index) {
                gfx.fillColor = cc.color(0, 255, 0, 255);
                gfx.fillRect(r.x, r.y, r.width, r.height);
            }
        });
    };
    TableView.prototype.drawTable = function (isLeft) {
        var boxWidth = 100;
        var count = 3;
        var gfx = this.strokeGfx;
        var width = this.node.width, height = this.node.height;
        var bottom = -height / 2;
        var delay = width / 2 - count * boxWidth;
        var sign = (isLeft ? -1 : 1);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom);
        gfx.lineTo((delay / 2) * sign, bottom);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth * count);
        gfx.lineTo((width / 2 - delay / 2) * sign, bottom + boxWidth * count);
        gfx.close();
        gfx.moveTo((delay / 2 + boxWidth) * sign, bottom);
        gfx.lineTo((delay / 2 + boxWidth) * sign, bottom + boxWidth * count);
        gfx.moveTo((delay / 2 + boxWidth * 2) * sign, bottom);
        gfx.lineTo((delay / 2 + boxWidth * 2) * sign, bottom + boxWidth * count);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom + boxWidth);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth);
        gfx.moveTo((width / 2 - delay / 2) * sign, bottom + boxWidth * 2);
        gfx.lineTo((delay / 2) * sign, bottom + boxWidth * 2);
        gfx.stroke();
        for (var i = 0; i < count; ++i) {
            for (var j = 0; j < count; ++j) {
                var x = (delay / 2 + boxWidth * (i + (isLeft ? 1 : 0))) * sign;
                var y = bottom + boxWidth * j;
                var rect = new cc.Rect(x, y, boxWidth, boxWidth);
                this.rects.push(rect);
            }
        }
    };
    TableView.prototype.getRects = function () {
        return this.rects;
    };
    __decorate([
        property(cc.Graphics)
    ], TableView.prototype, "strokeGfx", void 0);
    TableView = __decorate([
        ccclass
    ], TableView);
    return TableView;
}(cc.Component));
exports.default = TableView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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