
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/views/GameView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'cf647gIawpJX6Y5aoFpH4nR', 'GameView');
// scripts/views/GameView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var Tools_1 = require("../common/Tools");
var Hero_1 = require("../prefab/Hero");
var TableView_1 = require("../ui/TableView");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var GameView = /** @class */ (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.bg = null;
        _this.table = null;
        _this.hero = null;
        _this.leftList = [];
        _this.rightList = [];
        _this.isGaming = false;
        return _this;
    }
    GameView.prototype.onLoad = function () {
        EventManager_1.default.on(Const_1.EventType.TABLE_INIT_OVER, this.initHeros, this);
        EventManager_1.default.on(Const_1.EventType.HERO_ATTACK, this.doAttack, this);
        EventManager_1.default.on(Const_1.EventType.HERO_ATTACK, this.checkGameOver, this);
    };
    GameView.prototype.onDestroy = function () {
        EventManager_1.default.off(Const_1.EventType.TABLE_INIT_OVER, this.initHeros, this);
        EventManager_1.default.off(Const_1.EventType.HERO_ATTACK, this.doAttack, this);
        EventManager_1.default.off(Const_1.EventType.HERO_ATTACK_OVER, this.checkGameOver, this);
    };
    GameView.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            Tools_1.default.setOffsetUV(_this.bg);
        }, 0);
    };
    GameView.prototype.initHeros = function () {
        var rects = this.table.getRects();
        var leftRects = rects.slice(0, 9);
        var rightRects = rects.slice(9);
        var id = 10000;
        var _loop_1 = function (i) {
            var heroNode = cc.instantiate(this_1.hero);
            var hero = heroNode.getComponent(Hero_1.default);
            this_1.node.addChild(heroNode);
            var rect = leftRects[Math.floor(Math.random() * leftRects.length)];
            leftRects = leftRects.filter(function (r) { return !r.equals(rect); });
            var wpos = this_1.table.node.convertToWorldSpaceAR(cc.v2(rect.x + rect.width / 2, rect.y + rect.height / 2));
            var npos = this_1.node.convertToNodeSpaceAR(wpos);
            hero.onInit(npos, ++id);
            hero.camp = Const_1.CAMPS.LEFT;
            this_1.leftList.push(heroNode);
        };
        var this_1 = this;
        for (var i = 0; i < Const_1.HERO_COUNT; ++i) {
            _loop_1(i);
        }
        var _loop_2 = function (i) {
            var heroNode = cc.instantiate(this_2.hero);
            var hero = heroNode.getComponent(Hero_1.default);
            this_2.node.addChild(heroNode);
            var rect = rightRects[Math.floor(Math.random() * rightRects.length)];
            rightRects = rightRects.filter(function (r) { return !r.equals(rect); });
            var wpos = this_2.table.node.convertToWorldSpaceAR(cc.v2(rect.x + rect.width / 2, rect.y + rect.height / 2));
            var npos = this_2.node.convertToNodeSpaceAR(wpos);
            hero.onInit(npos, ++id);
            hero.camp = Const_1.CAMPS.RIGHT;
            this_2.rightList.push(heroNode);
        };
        var this_2 = this;
        for (var i = 0; i < Const_1.HERO_COUNT; ++i) {
            _loop_2(i);
        }
        this.isGaming = true;
    };
    GameView.prototype.doAttack = function (event) {
        var data = event.getUserData();
        var _a = this.getAttackHero(data), camp = _a[0], hero = _a[1];
        var target = this.getRandomTarget(camp);
        if (!target) {
            this.isGaming = false;
            return;
        }
        hero.doAttack(target.pos);
        target.onAttack(hero);
    };
    GameView.prototype.getAttackHero = function (data) {
        var camp = data.camp;
        var list, hero;
        switch (camp) {
            case Const_1.CAMPS.LEFT:
                list = this.leftList;
                break;
            case Const_1.CAMPS.RIGHT:
                list = this.rightList;
                break;
            default:
                console.log("get hero error==>", data);
                return;
        }
        list.forEach(function (item) {
            if (item.getComponent(Hero_1.default).hero_id === data.id) {
                hero = item.getComponent(Hero_1.default);
                return;
            }
        });
        return [camp, hero];
    };
    GameView.prototype.getRandomTarget = function (camp) {
        var list, target;
        switch (camp) {
            case Const_1.CAMPS.LEFT:
                list = this.rightList.filter(function (item) {
                    var hero = item.getComponent(Hero_1.default);
                    return !hero.isdead;
                });
                break;
            case Const_1.CAMPS.RIGHT:
                list = this.leftList.filter(function (item) {
                    var hero = item.getComponent(Hero_1.default);
                    return !hero.isdead;
                });
                break;
            default:
                console.log("get target error==>", camp);
                return;
        }
        if (list.length === 0) {
            return;
        }
        target = list[Math.floor(Math.random() * list.length)];
        return target.getComponent(Hero_1.default);
    };
    GameView.prototype.checkGameOver = function () {
        var leftList = this.leftList.filter(function (n) { return !n.getComponent(Hero_1.default).isdead; });
        var rightList = this.rightList.filter(function (n) { return !n.getComponent(Hero_1.default).isdead; });
        this.isGaming = leftList.length > 0 && rightList.length > 0;
    };
    GameView.prototype.update = function (dt) {
        if (this.isGaming) {
            this.leftList.forEach(function (node) {
                node.getComponent(Hero_1.default).getEnergy(dt);
            });
            this.rightList.forEach(function (node) {
                node.getComponent(Hero_1.default).getEnergy(dt);
            });
        }
    };
    __decorate([
        property(cc.Sprite)
    ], GameView.prototype, "bg", void 0);
    __decorate([
        property(TableView_1.default)
    ], GameView.prototype, "table", void 0);
    __decorate([
        property(cc.Prefab)
    ], GameView.prototype, "hero", void 0);
    GameView = __decorate([
        ccclass
    ], GameView);
    return GameView;
}(cc.Component));
exports.default = GameView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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