"use strict";
cc._RF.push(module, '0f1124T45JGQrc2TGpj9mtf', 'Hero');
// scripts/prefab/Hero.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var GameModel_1 = require("../model/GameModel");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Hero = /** @class */ (function (_super) {
    __extends(Hero, _super);
    function Hero() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 节点
        _this.lb_name = null;
        _this.lb_hp = null;
        _this.lb_data = null;
        _this.pb_hp = null;
        _this.pb_eg = null;
        // 人物属性
        _this._hp = 0;
        _this._maxHp = 0;
        _this._hero_name = "";
        _this._attack = 0;
        _this._defence = 0;
        _this._speed = 0;
        _this._dead = false;
        _this._camp = 0;
        _this._pos = cc.v2(0, 0);
        _this._energy = 0;
        _this._hero_id = 0;
        return _this;
    }
    Object.defineProperty(Hero.prototype, "hp", {
        get: function () {
            return this._hp;
        },
        set: function (value) {
            this._hp = Math.min(Math.round(value), this.maxHp);
            if (this.hp <= 0) {
                this.isdead = true;
            }
            else {
                this.lb_hp.string = this.hp + "/" + this.maxHp;
                this.pb_hp.progress = this.hp / this.maxHp;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "maxHp", {
        get: function () {
            return this._maxHp;
        },
        set: function (value) {
            var i_hp = Math.round(value);
            this._maxHp = i_hp;
            this.hp = i_hp;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "heroname", {
        get: function () {
            return this._hero_name;
        },
        set: function (value) {
            this._hero_name = value;
            this.lb_name.string = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "attack", {
        get: function () {
            return this._attack;
        },
        set: function (value) {
            this._attack = Math.round(value);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "defence", {
        get: function () {
            return this._defence;
        },
        set: function (value) {
            this._defence = Math.min(Math.round(value), Const_1.MAX_DEFENCE);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "speed", {
        get: function () {
            return this._speed;
        },
        set: function (value) {
            this._speed = Math.round(value);
            this.displayData();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "isdead", {
        get: function () {
            return this._dead;
        },
        set: function (value) {
            this._dead = value;
            this.node.active = !value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "camp", {
        get: function () {
            return this._camp;
        },
        set: function (value) {
            this._camp = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "pos", {
        get: function () {
            return this._pos;
        },
        set: function (value) {
            if (!this._pos.equals(value)) {
                this._pos = value;
            }
            this.node.setPosition(this.pos);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "energy", {
        get: function () {
            return this._energy;
        },
        set: function (value) {
            this._energy = Math.min(value, Const_1.MAX_ENERGY);
            this.pb_eg.progress = this.energy / Const_1.MAX_ENERGY;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Hero.prototype, "hero_id", {
        get: function () {
            return this._hero_id;
        },
        enumerable: false,
        configurable: true
    });
    Hero.prototype.onInit = function (npos, id) {
        var names = ["曹操", "刘备", "孙权", "陆逊", "周瑜", "诸葛亮", "司马懿", "郭嘉", "荀彧", "戏志才", "贾诩", "鲁肃", "法正", "姜维", "赵云", "吕布", "关羽", "张飞"];
        var rand = Math.random();
        this.heroname = names[Math.floor(rand * names.length)];
        this.maxHp = 200 + rand * 100;
        this.attack = 50 + rand * 20;
        this.defence = 20 + rand * 10;
        this.speed = 20 + rand * 5;
        this.isdead = false;
        this.pos = npos;
        this.energy = 0;
        this._hero_id = id;
    };
    Hero.prototype.getEnergy = function (dt) {
        this.energy += this.speed * dt;
        if (this.energy >= Const_1.MAX_ENERGY) {
            var data = { camp: this.camp, id: this.hero_id };
            EventManager_1.default.emit(Const_1.EventType.HERO_ATTACK, data);
            this.energy = 0;
        }
    };
    Hero.prototype.doAttack = function (pos) {
        var sign = this.camp === Const_1.CAMPS.LEFT ? -1 : 1;
        var tpos = pos.add(cc.v2(this.node.width * 0.9 * sign, 0));
        cc.tween(this.node)
            .to(.1, { x: tpos.x, y: tpos.y }, { easing: 'cubicOut' })
            .to(.1, { x: this.pos.x, y: this.pos.y }, { easing: 'cubicOut' })
            .start();
    };
    Hero.prototype.onAttack = function (from) {
        var _this = this;
        var damage = GameModel_1.default.calculateDamage(from.attack, this.defence);
        cc.tween(this.node)
            .delay(.1)
            .to(.05, { scale: .8 })
            .call(function () {
            _this.hp -= damage;
            EventManager_1.default.emit(Const_1.EventType.HERO_ATTACK_OVER);
        })
            .to(.05, { scale: 1 })
            .start();
    };
    Hero.prototype.displayData = function () {
        var str = "\u653B:" + this.attack + " \u9632:" + this.defence + " \u901F:" + this.speed;
        this.lb_data.string = str;
    };
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_name", void 0);
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_hp", void 0);
    __decorate([
        property(cc.Label)
    ], Hero.prototype, "lb_data", void 0);
    __decorate([
        property(cc.ProgressBar)
    ], Hero.prototype, "pb_hp", void 0);
    __decorate([
        property(cc.ProgressBar)
    ], Hero.prototype, "pb_eg", void 0);
    Hero = __decorate([
        ccclass
    ], Hero);
    return Hero;
}(cc.Component));
exports.default = Hero;

cc._RF.pop();