"use strict";
cc._RF.push(module, 'cf647gIawpJX6Y5aoFpH4nR', 'GameView');
// scripts/views/GameView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Const_1 = require("../common/Const");
var EventManager_1 = require("../common/EventManager");
var Tools_1 = require("../common/Tools");
var Hero_1 = require("../prefab/Hero");
var TableView_1 = require("../ui/TableView");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var GameView = /** @class */ (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.bg = null;
        _this.table = null;
        _this.hero = null;
        _this.leftList = [];
        _this.rightList = [];
        _this.isGaming = false;
        return _this;
    }
    GameView.prototype.onLoad = function () {
        EventManager_1.default.on(Const_1.EventType.TABLE_INIT_OVER, this.initHeros, this);
        EventManager_1.default.on(Const_1.EventType.HERO_ATTACK, this.doAttack, this);
        EventManager_1.default.on(Const_1.EventType.HERO_ATTACK, this.checkGameOver, this);
    };
    GameView.prototype.onDestroy = function () {
        EventManager_1.default.off(Const_1.EventType.TABLE_INIT_OVER, this.initHeros, this);
        EventManager_1.default.off(Const_1.EventType.HERO_ATTACK, this.doAttack, this);
        EventManager_1.default.off(Const_1.EventType.HERO_ATTACK_OVER, this.checkGameOver, this);
    };
    GameView.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            Tools_1.default.setOffsetUV(_this.bg);
        }, 0);
    };
    GameView.prototype.initHeros = function () {
        var rects = this.table.getRects();
        var leftRects = rects.slice(0, 9);
        var rightRects = rects.slice(9);
        var id = 10000;
        var _loop_1 = function (i) {
            var heroNode = cc.instantiate(this_1.hero);
            var hero = heroNode.getComponent(Hero_1.default);
            this_1.node.addChild(heroNode);
            var rect = leftRects[Math.floor(Math.random() * leftRects.length)];
            leftRects = leftRects.filter(function (r) { return !r.equals(rect); });
            var wpos = this_1.table.node.convertToWorldSpaceAR(cc.v2(rect.x + rect.width / 2, rect.y + rect.height / 2));
            var npos = this_1.node.convertToNodeSpaceAR(wpos);
            hero.onInit(npos, ++id);
            hero.camp = Const_1.CAMPS.LEFT;
            this_1.leftList.push(heroNode);
        };
        var this_1 = this;
        for (var i = 0; i < Const_1.HERO_COUNT; ++i) {
            _loop_1(i);
        }
        var _loop_2 = function (i) {
            var heroNode = cc.instantiate(this_2.hero);
            var hero = heroNode.getComponent(Hero_1.default);
            this_2.node.addChild(heroNode);
            var rect = rightRects[Math.floor(Math.random() * rightRects.length)];
            rightRects = rightRects.filter(function (r) { return !r.equals(rect); });
            var wpos = this_2.table.node.convertToWorldSpaceAR(cc.v2(rect.x + rect.width / 2, rect.y + rect.height / 2));
            var npos = this_2.node.convertToNodeSpaceAR(wpos);
            hero.onInit(npos, ++id);
            hero.camp = Const_1.CAMPS.RIGHT;
            this_2.rightList.push(heroNode);
        };
        var this_2 = this;
        for (var i = 0; i < Const_1.HERO_COUNT; ++i) {
            _loop_2(i);
        }
        this.isGaming = true;
    };
    GameView.prototype.doAttack = function (event) {
        var data = event.getUserData();
        var _a = this.getAttackHero(data), camp = _a[0], hero = _a[1];
        var target = this.getRandomTarget(camp);
        if (!target) {
            this.isGaming = false;
            return;
        }
        hero.doAttack(target.pos);
        target.onAttack(hero);
    };
    GameView.prototype.getAttackHero = function (data) {
        var camp = data.camp;
        var list, hero;
        switch (camp) {
            case Const_1.CAMPS.LEFT:
                list = this.leftList;
                break;
            case Const_1.CAMPS.RIGHT:
                list = this.rightList;
                break;
            default:
                console.log("get hero error==>", data);
                return;
        }
        list.forEach(function (item) {
            if (item.getComponent(Hero_1.default).hero_id === data.id) {
                hero = item.getComponent(Hero_1.default);
                return;
            }
        });
        return [camp, hero];
    };
    GameView.prototype.getRandomTarget = function (camp) {
        var list, target;
        switch (camp) {
            case Const_1.CAMPS.LEFT:
                list = this.rightList.filter(function (item) {
                    var hero = item.getComponent(Hero_1.default);
                    return !hero.isdead;
                });
                break;
            case Const_1.CAMPS.RIGHT:
                list = this.leftList.filter(function (item) {
                    var hero = item.getComponent(Hero_1.default);
                    return !hero.isdead;
                });
                break;
            default:
                console.log("get target error==>", camp);
                return;
        }
        if (list.length === 0) {
            return;
        }
        target = list[Math.floor(Math.random() * list.length)];
        return target.getComponent(Hero_1.default);
    };
    GameView.prototype.checkGameOver = function () {
        var leftList = this.leftList.filter(function (n) { return !n.getComponent(Hero_1.default).isdead; });
        var rightList = this.rightList.filter(function (n) { return !n.getComponent(Hero_1.default).isdead; });
        this.isGaming = leftList.length > 0 && rightList.length > 0;
    };
    GameView.prototype.update = function (dt) {
        if (this.isGaming) {
            this.leftList.forEach(function (node) {
                node.getComponent(Hero_1.default).getEnergy(dt);
            });
            this.rightList.forEach(function (node) {
                node.getComponent(Hero_1.default).getEnergy(dt);
            });
        }
    };
    __decorate([
        property(cc.Sprite)
    ], GameView.prototype, "bg", void 0);
    __decorate([
        property(TableView_1.default)
    ], GameView.prototype, "table", void 0);
    __decorate([
        property(cc.Prefab)
    ], GameView.prototype, "hero", void 0);
    GameView = __decorate([
        ccclass
    ], GameView);
    return GameView;
}(cc.Component));
exports.default = GameView;

cc._RF.pop();