import { _decorator, Component, Node, Label, assetManager } from 'cc';
import { audioMgr } from '../../scripts/framework/audioMgr';
const { ccclass, property } = _decorator;

@ccclass('LoginView')
export class LoginView extends Component {
    
    @property(Label)
    lab_Num: Label = null!;
    
    
    start() {
        assetManager.loadBundle('game', (err, bundle) => {
            
        })
    }

    bPlayStart: boolean = false;
    timeTotal: number = 0;

    update(deltaTime: number) {
        if (this.bPlayStart) {
            this.timeTotal += deltaTime;
            if (this.timeTotal > 0.1) {
                this.timeTotal = 0;
                this.playSkillAudio();
                this.playAtkAudio();
            }
        }
    }



    nNum: number = 0;



    // update (dt) {}


    playAtkAudio() {
        let nameList = ['heroAtk1', 'heroAtk2', 'heroAtk3', 'heroAtk4', 'heroAtk5', 'heroAtk6', 'heroAtk7', 'heroAtk8', 'heroAtk9', 'heroAtk10'];
        let idx = this.getRandomInt(0, nameList.length);
        let name = nameList[idx];
        let time = this.getRandomInt(1, 10);
        this.scheduleOnce(()=>{
            audioMgr.instance.playSound(['game', name]);
            this.nNum += 1;
            this.lab_Num.string = '' + this.nNum;
        }, time / 20);
    }

    playSkillAudio() {
        let nameList = ['heroSkill2', 'heroSkill3', 'heroSkill6', 'heroSkill7', 'heroSkill9', 'heroSkill10', 'heroSkill11', 'heroSkill15', 'heroSkill16', 'heroSkill21', 'heroSkill33'];
        let idx = this.getRandomInt(0, nameList.length);
        let name = nameList[idx];
        let time = this.getRandomInt(1, 10);
        this.scheduleOnce(()=>{
            audioMgr.instance.playSound(['game', name]);
            this.nNum += 1;
            this.lab_Num.string = '' + this.nNum;
        }, time / 20);
    }

    onBtnPlay() {

        this.bPlayStart = !this.bPlayStart;
    }

    private getRandomInt(minNum: number, maxNum: number): number {
		if (maxNum == minNum) {
			return minNum;
		} else if (maxNum < minNum) {
			return 0;
		}
		let randNum = Math.random() * (maxNum - minNum) + minNum;
		return Math.floor(randNum);
	}


    

}


