import { _decorator, Component, AudioSource, assert } from 'cc';
import { audioMgr } from './audioMgr';

const { ccclass, property } = _decorator;

@ccclass('GameRoot')
export class GameRoot extends Component {

    @property(AudioSource)
    audioMusic: AudioSource = null!;
    @property(AudioSource)
    audioSound: AudioSource = null!;

    onLoad() {
        const audioSource = this.getComponent(AudioSource);
        assert(audioSource);
        this.audioMusic = audioSource;
        // director.addPersistRootNode(this.node);

        audioMgr.instance.init(this.audioMusic, this.audioSound);
    }

    onEnable () {
        // NOTE: 常驻节点在切场景时会暂停音乐，需要在 onEnable 继续播放
        // 之后需要在引擎侧解决这个问题
        audioMgr.instance.playMusic();
        audioMgr.instance.checkState();
    }

}

