import { _decorator, AudioClip, sys, AudioSource, assert, clamp01, warn } from "cc";
import { resourceUtil } from "./resourceUtil";


export class audioMgr {
    private static _instance: audioMgr;
    private static _audioMusic?: AudioSource;
    private static _audioSound?: AudioSource;

    static get instance () {
        if (this._instance) {
            return this._instance;
        }

        this._instance = new audioMgr();
        return this._instance;
    }

    soundVolume: number = 1;
    musicVolume: number = 1;

    private listClipSound: {[id: string]: AudioClip} = {};


    // init audioMgr in GameRoot.
    init (audioMusic: AudioSource, audioSound: AudioSource) {
        // this.soundVolume = this.getConfiguration(false) ? 1 : 0;
        this.soundVolume = 1;
        this.musicVolume = 1;
        

        audioMgr._audioMusic = audioMusic;
        audioMgr._audioSound = audioSound;
    }

    getConfiguration (isMusic: boolean) {
        let state;
        if (isMusic) {
            // state = configuration.instance.getGlobalData('music');
            state = true;
        } else {
            // state = configuration.instance.getGlobalData('sound');
            state =  true;
        }

        // console.log('Config for [' + (isMusic ? 'Music' : 'Sound') + '] is ' + state);
        return state === undefined || state === 'true' || state ? true : false;
    }

    checkState(){
        if (this.getConfiguration(true)) {
            this.openMusic();
        } else {
            this.closeMusic();
        }

        if (this.getConfiguration(false)) {
            this.openSound();
        } else {
            this.closeSound();
        }
    }

    /** 当前播放音乐 */
    curMusicUrl: string[] = null;

    /** 上一首背景音乐 名字 */
    prevMusic: string = ''
    /**
     * 播放音乐
     * @param url [bundleName, musicName] 音乐地址可通过constants.AUDIO_MUSIC 获取
     * @param closeOther 是否关闭其他背景音效 默认 true
     * @param loop 是否循环播放
     * @returns 
     */
    playMusic(url?: string[], loop = true) {
        
        const audioSource = audioMgr._audioMusic!;
        // assert(audioSource, 'audioMgr not inited!');
        if (!url) {
            audioSource.loop = loop;
            if (!audioSource.playing) {
                audioSource.play();
            }
            return;
        }

        this.curMusicUrl = url;

        let bundleName = url[0];
        let musicName = url[1];
        
        if (this.prevMusic == (bundleName + musicName)) {
            return;
        }
        audioSource.stop();
        this.prevMusic = (bundleName + musicName);
        let path = 'res/audio/music/' + musicName;
        resourceUtil.loadAudio(bundleName, path, (clip: AudioClip)=> {
            // TEST
            audioSource.clip = clip;
            audioSource.loop = loop;
            let audioId = audioSource.play();
            return audioId;
            
        });
    }


    /**
     * 播放音效
     * @param url [bundleName, souneName] 音效地址可通过AUDIO_NAME.Sound 获取
     */
    playSound(url: string[]) {
        if (this.soundVolume == 0) {
            return;
        }

        const audioSource = audioMgr._audioSound!;
        if (this.listClipSound[url[1]]) {
        
            audioSource.playOneShot(this.listClipSound[url[1]], this.soundVolume);
            return;
        }
        
        // assert(audioSource, 'audioMgr not inited!');

        let bundleName = url[0];
        let souneName = url[1];
        //音效一般是多个的，不会只有一个
        let path = 'res/audio/sound/' + souneName;
        resourceUtil.loadAudio(bundleName, path, (clip)=> {
            // NOTE: the second parameter is volume scale.
            //TEST 
            this.listClipSound[url[1]] = clip;
            audioSource.playOneShot(clip, this.soundVolume);
        });
    }

    setMusicVolume (flag: number) {
        const audioSource = audioMgr._audioMusic!;
        assert(audioSource, 'audioMgr not inited!');

        flag = clamp01(flag);
        audioSource.volume = flag;
    }

    setSoundVolume (flag: number) {
        this.soundVolume = flag;
        const audioSource = audioMgr._audioSound!;
        assert(audioSource, 'audioMgr not inited!');

        flag = clamp01(flag);
        audioSource.volume = flag;
    }

    openMusic () {
        this.setMusicVolume(0.8);
        // configuration.instance.setGlobalData('music', 'true');
    }

    closeMusic () {
        this.setMusicVolume(0);
        // configuration.instance.setGlobalData('music', 'false');
    }

    openSound () {
        this.setSoundVolume(1);
        // configuration.instance.setGlobalData('sound', 'true');
    }

    closeSound () {
        this.setSoundVolume(0);
        // configuration.instance.setGlobalData('sound', 'false');
    }
}
