import { _decorator, resources, assetManager, AudioClip } from "cc";

const { ccclass } = _decorator;

export type LoadCompleteCallback<T> = (error: Error | null, asset: T) => void;


declare global {
    namespace globalThis {
        var LZString: any;
    }
}

interface ITextAsset{
    text?: string;
    _file?: string;
    json?: string
}



@ccclass("resourceUtil")
export class resourceUtil {
  

    /** 加载音乐文件  */
    public static loadAudio(bundleName: string, paths: string, onComplete?: (assets: AudioClip) => void ) {
        if (bundleName) {
            let hallBundle = assetManager.getBundle(bundleName);
            if (!hallBundle) {
                console.error(`bundle name ${ bundleName} is null !!!`);
                return;
            }
            let info: AudioClip = hallBundle.get(paths, AudioClip);
            if (info) {
                onComplete && onComplete(info);
                return;
            }
            hallBundle.load(paths, AudioClip,  (err, audio: AudioClip)=> {
                if (err) {
                    console.error(err);
                    return;
                }
                onComplete && onComplete(audio);
            });
        } else {
            let info: AudioClip = resources.get(paths, AudioClip);
            if (info) {
                onComplete && onComplete(info);
                return;
            }
            resources.load(paths, AudioClip, (err, audio: AudioClip)=> {
                if (err) {
                    console.error(err);
                    return;
                }
                onComplete && onComplete(audio);
            });
        }
    }




    

}
