import FileList from "./FileList.js";
import * as fs from "fs";

export default class I18FindRichTxt{

    _projectAssetsPath = "";
    _editorFilePath = [];

    constructor( dir ){
        const self = this;
        self._projectAssetsPath = dir;
        self.initData();
    }    

    initData(){
        console.log( "\n----------init file in editor----------" );
        const self = this;
        const fl = new FileList();
        fl.initData( self._projectAssetsPath );

        const allScene = fl.filterByType( "scene" );
        for( let name of allScene ){
            self._editorFilePath.push( self._projectAssetsPath + name );
        }
        const allPrefab = fl.filterByType( "prefab" );
        for( let name of allPrefab ){
            self._editorFilePath.push( self._projectAssetsPath + name );
        }
    }

    readJsonInFile( fileName ){
        const str = fs.readFileSync( fileName, "utf8" );
        let jsonData = null;
        try {        
            jsonData = JSON.parse( str );
        } catch (error) {
            console.error( "JSON parse file error, file:" + fileName );
            console.error( error );
            return null;
        }
        return jsonData;
    }

    checkChinese( str ){
        const pattern = /[\u4E00-\u9FA5]/;
        return pattern.test(str);
    }

    run(){
        console.log( "\n----------start find all rich txt----------" );
        const self = this;
        for( const fileName of self._editorFilePath ){
            const jsonData = self.readJsonInFile( fileName );
            if( jsonData == null ) continue;

            const arrTxt = [];
            for( const data of jsonData ){                
                if( data[ "__type__" ] != "cc.RichText" ) continue;
                if( data[ "_string" ] == null ) continue;

                let strContent = data[ "_string" ];
                if( !self.checkChinese(strContent) ) continue;

                arrTxt.push( strContent );
            }

            if( arrTxt.length > 0 ){
                console.log( fileName );
                for( const txt of arrTxt ){
                    console.log( `"${txt}"` );
                }
                console.log( "" );
            }
        }
        console.log( "\n----------find all rich txt end----------" );
    }

}