import * as fs from "fs";
import FileList from "./FileList.js";

export default class I18TxtInCreator {

    _projectAssetsPath = "";
    _editorFilePath = [];
    _i18CmptData = null;

    _txtJsonPath = "";
    _txtJsonData = null;
    _mapTxtStrKey = new Map();
    _mapTxtKeyStr = new Map();
    _useMapTxt = new Map();
    
    _editorKey = "zzz___editor_txt___";
    _keyBase = "etxt";
    _keyMaxId = 0;

    constructor( assetsPath, i18CmptData, jsonPath ){
        const self = this;
        self._projectAssetsPath = assetsPath;
        self._i18CmptData = i18CmptData;

        self._txtJsonPath = jsonPath;
    }

    initEditorFilePath(){
        console.log( "\n----------init file in editor----------" );
        const self = this;
        const fl = new FileList();
        fl.initData( self._projectAssetsPath );

        const allScene = fl.filterByType( "scene" );
        for( let name of allScene ){
            self._editorFilePath.push( self._projectAssetsPath + name );
        }
        const allPrefab = fl.filterByType( "prefab" );
        for( let name of allPrefab ){
            self._editorFilePath.push( self._projectAssetsPath + name );
        }
    }

    initTxtData( fileName ){
        console.log( "\n----------init txt data----------" );
        const self = this;
        const jsonData = self.readJsonInFile( fileName );
        if( jsonData == null || jsonData[self._editorKey] == null ){
            console.error( `not found ${self._editorKey} in file: ${fileName}` );
            return;
        }

        self._txtJsonData = jsonData;
        const editorData = jsonData[self._editorKey];
        for( const key in editorData ){
            const str = editorData[key];
            if( self._mapTxtKeyStr.get(key) == null ){
                self._mapTxtKeyStr.set( key, str );
            }

            if( self._mapTxtStrKey.get(str) == null ){
                self._mapTxtStrKey.set( str, key );
            }

            const n = Number( key.substring( self._keyBase.length ) );
            if( n != NaN ){
                if( n > self._keyMaxId ){
                    self._keyMaxId = n;
                }
            }
        }
    }

    readJsonInFile( fileName ){
        const str = fs.readFileSync( fileName, "utf8" );
        let jsonData = null;
        try {        
            jsonData = JSON.parse( str );
        } catch (error) {
            console.error( "JSON parse file error, file:" + fileName );
            console.error( error );
            return null;
        }
        return jsonData;
    }

    checkChinese( str ){
        const pattern = /[\u4E00-\u9FA5]/;
        return pattern.test(str);
    }

    buildTxtKey(){
        const self = this;
        ++self._keyMaxId;
        return self._keyBase + self._keyMaxId;
    }

    getI18CmptByNodeId( jsonData, nodeId ){
        const self = this;
        for( const data of jsonData ){
            if( data[ "__type__" ] != self._i18CmptData["__type__"] ) continue;
            if( data[ "node" ] == null ) continue;
            if( data[ "node" ][ "__id__" ] == nodeId )
                return data;
        }
        return null;
    }

    getLabelCmptByNodeId( jsonData, nodeId ){
        for( const data of jsonData ){
            if( !self.checkDataIsLabel(data) ) continue;
            if( data[ "node" ] == null ) continue;
            if( data[ "node" ][ "__id__" ] == nodeId )
                return data;
        }
        return null;
    }

    clone(obj) {
        if (typeof obj !== 'object' || obj === null) {
            return obj;
        }
    
        let newObj = Array.isArray(obj)? [] : {};
    
        for (let key in obj) {
            newObj[key] = this.clone(obj[key]);
        }
    
        return newObj;
    }

    writeUsedTxtToFile(){        
        console.log( "\n----------write txt----------" );
        const self = this;

        const usedData = {};
        self._useMapTxt.forEach((key, strContent)=>{
            usedData[key] = strContent;
        });

        self._txtJsonData[self._editorKey] = usedData;
        fs.writeFileSync( self._projectAssetsPath + self._txtJsonPath, JSON.stringify( self._txtJsonData, null, 2 ) );
    }

    checkDataIsLabel( data ){
        if( data[ "__type__" ] != "cc.Label" ) return true;
        if( data[ "__type__" ] != "cc.RichText" ) return true;
        return false;
    }

    modifyEditorFile(){        
        console.log( "\n----------modify file in editor----------" );
        const self = this;
        for( const fileName of self._editorFilePath ){
            const jsonData = self.readJsonInFile( fileName );
            if( jsonData == null ) continue;

            let bModify = false;
            const arrAddCmpt = [];
            for( const data of jsonData ){
                if( !self.checkDataIsLabel(data) ) continue;
                if( data[ "_string" ] == null ) continue;

                if( data[ "node" ] == null ) continue;
                if( data[ "node" ][ "__id__" ] == null ) continue;

                let strContent = data[ "_string" ];
                if( !self.checkChinese(strContent) ) continue;

                const nodeId = data[ "node" ][ "__id__" ];
                const i18Cmp = self.getI18CmptByNodeId( jsonData, nodeId );
                if( i18Cmp ){                    
                    const cmptKey = i18Cmp[ "_key" ];
                    if( cmptKey != "" ){
                        const strTmp = self._mapTxtKeyStr.get( cmptKey );
                        if( strTmp != null && strTmp != strContent ){
                            strContent = strTmp;
                            self._mapTxtStrKey.set( strTmp, cmptKey );
                            data[ "_string" ] = strTmp;
                            bModify = true;
                        }
                    }
                }

                let txtKey = self._mapTxtStrKey.get( strContent );
                if( txtKey == null ){
                    txtKey = self.buildTxtKey();
                }
                
                self._useMapTxt.set( strContent, txtKey );
                
                if( i18Cmp != null ){
                    if( i18Cmp[ "_key" ] != txtKey ){
                        i18Cmp[ "_key" ] = txtKey;
                        bModify = true;
                    }
                }else{
                    const cmptInfo = self.clone( self._i18CmptData );
                    cmptInfo["node"][ "__id__" ] = nodeId;
                    cmptInfo[ "id" ] = 0;
                    cmptInfo[ "_key" ] = txtKey;
                    arrAddCmpt.push( cmptInfo );
                    bModify = true;
                }
            }


            let cmptId = jsonData.length;
            for( const info of arrAddCmpt ){
                const nodeId = info["node"][ "__id__" ];
                const nodeInfo = jsonData[nodeId];
                if( nodeInfo == null ) continue;
                if( nodeInfo["_components"] == null )
                    nodeInfo[ "_components" ] = [];
                const components = nodeInfo[ "_components" ];
    
                let bExist = false;
                for( const infoTmp of components ){
                    if( infoTmp["__id__"] == cmptId ){
                        bExist = true;
                        break;
                    }
                }
                if( bExist ){
                    console.error( `I18Cmpt is exist already, file: ${fileName} nodeId: ${nodeId}` );
                    continue;
                }
    
                components.push( { "__id__": cmptId } );
                jsonData.push( info );
                ++cmptId;
            }
    
            if( bModify ){
                fs.writeFileSync( fileName, JSON.stringify(jsonData, null, 2) );
                console.warn( "modify file:" + fileName );
            }
        }
    }

    run(){
        console.log( "=========start handle Label=========" );

        const self = this;        
        self.initEditorFilePath();
        self.initTxtData( self._projectAssetsPath + self._txtJsonPath );
        self.modifyEditorFile();
        self.writeUsedTxtToFile();
        
        console.log( "=========handle Label finished=========\n\n" );
    }

}