import I18FindI18Key from "./I18FindI18Key.js";
import I18FindRichTxt from "./I18FindRichTxt.js";
import I18Texture from "./I18Texture.js";
import I18Texture2SpriteFrame from "./I18Texture2SpriteFrame.js";
import I18TxtInCreator from "./I18TxtInCreator.js";
import * as fs from "fs";

//美术目录
const _artPath = "D:/DOC/i18/977_EN/";

//项目Assets目录
const _projectAssetsPath = "D:/Project/921_i18/assets/";
//const _projectAssetsPath = "D:/Test/Test/assets/";

//默认语言目录
const _defaultLanguageDir = "resources/CN/";

//目标语言目录
const _languageDir = "EN/";

//项目中所有多语言目录
const _allLanguageDir = [ "EN" ];

//I18Cmpt UUID
const _i18CmptType = "20b3fmaQTtGwKBF6ApDmo38";
//const _i18CmptType = "ee638wVntZBH5+KNIaasRAt";
const _i18CmptData =   {
    "__type__": _i18CmptType,
    "_name": "",
    "_objFlags": 0,
    "__editorExtras__": {},
    "node": {
        "__id__": 0
    },
    "_enabled": true,
    "__prefab": null,
    "_key": "",
    "_refresh": true,
    "_id": ""
};

const printHelp = function(){
    const str = fs.readFileSync( "./README.txt", "utf-8" );
    console.log( str );
}

const doLabelInCreator = function(){
    const i18 = new I18TxtInCreator( _projectAssetsPath, _i18CmptData, _defaultLanguageDir + "txt.json" );
    i18.run();
}

const doTexture = function(){
    const i18 = new I18Texture();
    i18.init({
        artPath: _artPath,
        assetsPath: _projectAssetsPath,
        defaultDir: _defaultLanguageDir,
        languageDir: _languageDir,
        allLanguageDir: _allLanguageDir,
        i18CmptType: _i18CmptType,
        i18CmptData: _i18CmptData,
    });
    i18.run();
}

const doTexture2SpriteFrame = function(){
    const i18 = new I18Texture2SpriteFrame( _projectAssetsPath + _languageDir );
    i18.run();
}

const doFindRichTxt = function(){
    const tool = new I18FindRichTxt( _projectAssetsPath );
    tool.run();
}

const doFindI18Key = function( key ){
    if( key == null || key == "" ){
        console.log( "please input i18Key !" );
        return;
    }
    const tool = new I18FindI18Key( _projectAssetsPath, key );
    tool.setI18CmptType( _i18CmptType );
    tool.run();
}

const params = process.argv.splice(2);
switch( params[0] ){
    case 1:
    case "1":
        {
            doLabelInCreator();
        }
    break;

    case 2:
    case "2":
        {
            doTexture();
        }
    break;

    case 3:
    case "3":
        {
            doTexture2SpriteFrame();
        }
    break;

    case 4:
    case "4":
        {
            doFindRichTxt();
        }
    break;

    case 5:
    case "5":
        {
            doFindI18Key( params[1] );
        }
    break;    

    default:
        {
            printHelp();
        }
}
console.log( "===========================" );
console.log( "=========ALL FINISHED======" );
console.log( "===========================\n" );