import { _decorator, Component, director, Node, Size, sys } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Launcher1')
export class Launcher1 extends Component {
    start() {
        this.launchGame();
    }
    parseLaunchParams() {
        console.log("解析启动参数");
        // 在这部分解析你的启动参数，注意，这里的实现会根据平台的不同而有不同的处理方式
        // 示例中，我们只是简单地输出信息
        console.log("示例参数解析");
    }
    getDeviceInfo() {
        console.log("获取设备信息");
        // 获取并打印出屏幕大小
        let screenSize: Size = sys.windowPixelResolution;
        console.log(`屏幕大小：宽=${screenSize.width}, 高=${screenSize.height}`);
        // 这里可以根据需要获取更多的设备信息，例如平台、操作系统等
       
    }
    enterGame() {
        console.log("进入游戏");
        // 示例：加载主场景
        director.loadScene("main");
    }
    launchGame() {
        console.log("启动游戏");
        // 解析启动参数
        this.parseLaunchParams();
        // 获取设备信息
        this.getDeviceInfo();
        // 设备信息获取完毕，进入游戏
        this.enterGame();
    }
}

