import { _decorator, Component, director, Node, Size, sys } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Launcher2')
export class Launcher2 extends Component {
    start() {
        this.launchGame();
    }
    parseLaunchParams() {
        console.log("解析启动参数");
        // 在这部分解析你的启动参数，注意，这里的实现会根据平台的不同而有不同的处理方式
        // 示例中，我们只是简单地输出信息
        console.log("示例参数解析");
    }
    getDeviceInfo() {
        console.log("获取设备信息");
        // 获取并打印出屏幕大小
        let screenSize: Size = sys.windowPixelResolution;
        console.log(`屏幕大小：宽=${screenSize.width}, 高=${screenSize.height}`);
        // 这里可以根据需要获取更多的设备信息，例如平台、操作系统等
       
    }
    fetchConfig(callback: Function) {
        console.log("获取游戏配置");
        // 示例：模拟异步获取配置操作
        setTimeout(() => {
            const config = {serverUrl: 'http://example.com', mode: 'production'};
            console.log("配置获取完成");
            callback(null, config); // 成功回调
        }, 1000);
    }

    login(serverUrl: string, callback: Function) {
        console.log(`登录游戏服务器: ${serverUrl}`);
        // 示例：模拟异步登录操作
        setTimeout(() => {
            const loginResult = {userId: 12345, sessionId: 'abcd1234'};
            console.log("登录成功");
            callback(null, loginResult); // 成功回调
        }, 1000);
    }

    enterGame() {
        console.log("进入游戏");
        // 示例：加载主场景
        director.loadScene("main");
    }
    launchGame() {
        console.log("启动游戏");
        // 解析启动参数
        this.parseLaunchParams();
        // 获取设备信息
        this.getDeviceInfo();

        this.fetchConfig((err: Error | null, config?: any) => {
            if (err) {
                console.log("获取配置失败");
                return;
            }
            this.login(config.serverUrl, (loginErr: Error | null, loginResult?: any) => {
                if (loginErr) {
                    console.log("登录失败");
                    return;
                }
                 // 设备信息获取完毕，进入游戏
                this.enterGame();
            });
        });
       
    }
}

