import { _decorator, Component, director, Node, Size, sys } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Launcher3')
export class Launcher3 extends Component {
    start() {
        this.launchGame();
    }
    parseLaunchParams() {
        console.log("解析启动参数");
        // 在这部分解析你的启动参数，注意，这里的实现会根据平台的不同而有不同的处理方式
        // 示例中，我们只是简单地输出信息
        console.log("示例参数解析");
    }
    getDeviceInfo() {
        console.log("获取设备信息");
        // 获取并打印出屏幕大小
        let screenSize: Size = sys.windowPixelResolution;
        console.log(`屏幕大小：宽=${screenSize.width}, 高=${screenSize.height}`);
        // 这里可以根据需要获取更多的设备信息，例如平台、操作系统等
       
    }
    fetchConfig() {
        return new Promise((resolve) => {
            console.log("获取游戏配置");
            setTimeout(() => resolve(true), 500); // 延迟模拟
        });
    }
    fetchResVersion(){
        return new Promise((resolve) => {
            console.log("获取资源版本");
            setTimeout(() => resolve(true), 500); // 延迟模拟
        });
    }
    updateResources() {
        return new Promise((resolve) => {
            console.log("更新资源");
            setTimeout(() => resolve(true), 500); // 延迟模拟
        });
    }
    login() {
        return new Promise((resolve) => {
            console.log("登录游戏服务器");
            setTimeout(() => resolve(true), 500); // 延迟模拟
        });
    }

    fetchUserInfo() {
        return new Promise((resolve) => {
            console.log("拉取用户信息");
            setTimeout(() => resolve(true), 500); // 延迟模拟
        });
    }

    enterGame() {
        console.log("进入游戏");
        // 示例：加载主场景
        director.loadScene("main");
    }
    async launchGame() {
        console.log("启动游戏");
        // 解析启动参数
        this.parseLaunchParams();
        // 获取设备信息
        this.getDeviceInfo();
        let res1 = await Promise.all([this.fetchConfig(),this.fetchResVersion()]);
        console.log(res1);
        if(!res1[0] || !res1[1]){
            return;
        }
        // 更新资源
        let res2 = await this.updateResources();
        if(!res2){
            return;
        }
        // 登陆
        let res3 = await this.login();
        if(!res3){
            return;
        }
        // 拉取用户信息
        let res4 = await this.fetchUserInfo();
        if(!res4){
            return;
        }
        // 获取完毕，进入游戏
        this.enterGame();
       
    }
}

