import { _decorator, Component, Node, Prefab, instantiate, Vec3, dynamicAtlasManager, profiler } from 'cc';
const { ccclass, property } = _decorator;

// macro.CLEANUP_IMAGE_CACHE = false;
// dynamicAtlasManager.enabled = true;
dynamicAtlasManager.enabled = false; // 关闭动态合图

@ccclass('mainlogic')
export class mainlogic extends Component {

    @property([Prefab])
    prefab: Prefab[] = Array<Prefab>(); // 骨骼动画
    @property([Prefab])
    framePrefab: Prefab[] = Array<Prefab>(); // 图集 序列帧

    private count: number = 1000;// 测试数量
    start() {
        profiler.showStats();
        // this.startTestSpines();
        this.startTestFrames();
    }

    update(deltaTime: number) {
        
    }

    startTestSpines() {
        for(let i=0;i<this.count;i++) {
            if (this.prefab) {
                let node = instantiate(this.prefab[i%4]);
                node.position = new Vec3(1200 * Math.random() - 600 ,720*Math.random() - 360,0);
                this.node.addChild(node);

            }
        }       
    }

    startTestFrames() {
        for(let i=0;i<this.count;i++) {
            if (this.prefab) {
                let node = instantiate(this.framePrefab[i%4]);
                node.position = new Vec3(1200 * Math.random() - 600 ,720*Math.random() - 360,0);
                this.node.addChild(node);
            }
        }       
    }
}


