import { _decorator, Component, Node, Skeleton, sp, tween, Vec2, Vec3, Tween } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('spineboy')
export class spineboy extends Component {
    private _sp: sp.Skeleton;
    private _aimBone: sp.spine.Bone;

    start() {
        if (this.node) {
            this._sp = this.node.getComponent(sp.Skeleton);
            this._aimBone = this._sp.findBone('crosshair');
            this._sp.setAnimation(0, 'walk', true);
            this._sp.addAnimation(1, 'aim', true);
            this._sp.addAnimation(2, 'shoot', true);
            //(this.node as unknown as sp.Skeleton).setAnimation(0, 'walk', true);

            tween(this.node).to(10, {position: new Vec3(1200 * Math.random()- 600,720 * Math.random()- 360,0)},{
                onComplete:()=>{
                    this.doTween();
                }
            }).start();
            
        }

    }

    doTween() {
        tween(this.node).to(10, {position: new Vec3(1200 * Math.random() - 600 ,720 * Math.random() - 360,0)},{
            onComplete:()=>{
                this.doTween();
            }
        }).start();
    }
    private isReseve: boolean = false;
    update(deltaTime: number) {
        if (this._aimBone) {
            if (this._aimBone.y > 800 || this._aimBone.y < -200) {
                this.isReseve = !this.isReseve;
            }
            this._aimBone.y += (this.isReseve ? (+1) : (-1)) * (10*Math.random()); 
        }
    }
}

