
/**
 * 脚本基类
 */

import { _decorator, Component, Node } from 'cc';
import { IBindInfo, TBindComp, TQuickBindExt } from 'db://assets/scripts/extension/Decorator';
const { ccclass, property } = _decorator;


export interface ICompBase {
}


@ccclass('CompBase')
export class CompBase extends Component {
    private _uiArgs?: ICompBase;

    protected onLoad(): void {
        this._quickBind();
        this.bindEvents();
    }


    protected onEnable(): void {
        this.registerEvents();
    }

    protected onDisable(): void {
        this.unregisterEvents();
    }

    protected start(): void {

    }

    protected onDestroy(): void {
        this.unscheduleAllCallbacks();
    }

    protected bindEvents(): void {

    }

    get uiArgs(): ICompBase {
        return this._uiArgs;
    }

    initArgs(args?: ICompBase): void {
        this._uiArgs = args;
    }

    protected registerEvents(): void {

    }

    protected unregisterEvents(): void {

    }

    private _quickBind(): void {
        // 要绑定的节点名
        const nodeNameSet = new Set<string>();
        // 收集继承链上的快捷绑定信息
        const bindMap = new Map<string, IBindInfo>();
        let prototype: CompBase & TQuickBindExt = Object.getPrototypeOf(this);
        while (prototype) {
            if (!(prototype instanceof CompBase)) {
                // 只有UIBase的子类支持快捷绑定
                break;
            }
            if (prototype.hasOwnProperty('_$bindMap$_')) {
                prototype._$bindMap$_!.forEach((bindInfo, propertyName) => {
                    if (bindMap.has(propertyName)) {
                        // 保证子类的属性覆盖父类的属性
                        return;
                    }
                    bindMap.set(propertyName, bindInfo);
                    nodeNameSet.add(bindInfo.nodeName);
                });
            }
            prototype = Object.getPrototypeOf(prototype);
        }
        // 没有快捷绑定信息
        if (nodeNameSet.size === 0) {
            return;
        }
        // 递归查找所有需要绑定的节点
        const childNameArr = Array.from(nodeNameSet);
        const childMap = this.node.findChildMapByNameArr(childNameArr);
        if (childMap.size === 0) {
            return;
        }
        // 绑定到实例变量
        bindMap.forEach((bindInfo, propertyName) => {
            const childNode = childMap.get(bindInfo.nodeName);
            if (!childNode) {
                return;
            }
            if (bindInfo.bindType === Node) {
                // @ts-ignore
                this[propertyName] = childNode;
            } else {
                let bindComp = childNode.getComponent(bindInfo.bindType as TBindComp);
                if (!bindComp && bindInfo.isAutoAddComp) {
                    bindComp = childNode.addComponent(bindInfo.bindType as TBindComp);
                }
                // @ts-ignore
                this[propertyName] = bindComp;
            }
        });
    }
}


