import { _decorator, color, Component, Material, math, Sprite, tween } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('DissolveCtrl')
export class DissolveCtrl extends Component {
    _mt: Material = null
    _spCmp: Sprite = null

    start() {
        this._spCmp = this.getComponent(Sprite)
        this._mt = this._spCmp.getMaterial(0)

        this.scheduleOnce(() => {
            this.disove()
        }, 1)
    }


    /**
     * 测试消融
     */
    _disoveTime: number = 1
    disove(cb?: Function) {
       //占用g通道
       let tSpCmp = this._spCmp
       tSpCmp.color = color(this._spCmp.color.r, 1, this._spCmp.color.b, this._spCmp.color.a)
       let tmpColor: math.Color = null
       tween(tSpCmp).to(this._disoveTime, {}, {
           onUpdate(target: Sprite, ratio) {
               tmpColor = color(255, 254 * ratio, 255, 255)
               target.color = tmpColor
           },
       }).call(() => {
           if (cb) {
               cb()
           }
           // tmpColor = color(255, 255, 255, 1)
           // tSpCmp.color = tmpColor
       }).start()
    }
}


