/**
 * SymbolComp 组件的描述
 */

import { _decorator, Label, tween, UIOpacity, UITransform, v3, Vec3 } from 'cc';
import { CompBase, ICompBase } from '../Base/CompBase';
import { quickBind } from '../extension/Decorator';
const { ccclass, property } = _decorator;

export interface ISymbolCompArgs extends ICompBase {

}

@ccclass('SymbolComp')
export class SymbolComp extends CompBase {
    @quickBind('Label', Label)
    private _label!: Label;

    private _isEmpty: boolean = false;


    get isEmpty() {
        return this._isEmpty;
    }

    set isEmpty(value: boolean) {
        this._isEmpty = value;
        this.node.getOrAddComponent(UIOpacity).opacity = value ? 0 : 255;
    }

    /**
    * 在节点首次激活时触发，比如所在的场景被载入，或者所在节点被激活的情况下。
    * 在 onLoad 阶段，保证了你可以获取到场景中的其他节点，以及节点关联的资源数据。
    * 生命周期函数顺序：onLoad => onEnable => start => update => lateUpdate
    */
    protected onLoad(): void {
        super.onLoad();
    }

    /**
    * 当组件的 enabled 属性从 false 变为 true 时，或者所在节点的 active 属性从 false 变为 true 时，会激活 onEnable 回调。
    * 倘若节点第一次被创建且 enabled 为 true，则会在 onLoad 之后，start 之前被调用。
    */
    protected onEnable(): void {
        super.onEnable();
    }

    /**
    * 当组件的 enabled 属性从 true 变为 false 时，或者所在节点的 active 属性从 true 变为 false 时，会激活 onDisable 回调。
    */
    protected onDisable(): void {
        super.onDisable();
    }

    /**
    * 在组件第一次激活前，也就是第一次执行 update 之前触发。
    */
    protected start(): void {
        super.start();
    }

    /**
    * 当组件或者所在节点调用了 destroy()，则会调用 onDestroy 回调，并在当帧结束时统一回收组件。
    */
    protected onDestroy(): void {
        super.onDestroy();
    }

    /**
 * 初始化参数，由 UIMgr 在打开界面时调用
 * @param uiArgs 
 */
    initArgs(uiArgs?: ISymbolCompArgs): void {
        super.initArgs(uiArgs);
    };

    /**
     * 使用 SDK.msgMgr.addMessage 添加所有的监听事件。
     * onEnable 时自动调用，组件失效时自动移除通过 SDK.msgMgr.addMessage 添加的所有事件。
     * 注意：不是用 SDK.msgMgr 添加的事件，需要重载父类 removeAllMsgs 方法，并自己移除。
     */
    registerEvents(): void {
        super.registerEvents();
    }

    getBoundaryWorldPos() {
        const w_pos = this.node.getWorldPosition();
        const size = this.node.getComponent(UITransform).contentSize;
        w_pos.add3f(0, size.height / 2, 0)
        return w_pos;;
    }

    updateSymbolLbl(num: number) {
        this._label.string = num + "";
    }

    dropByPos(moveDis:Vec3,dropTime:number,call?:Function){
        tween(this.node)
        .by(dropTime,{position:moveDis},{easing:"quadIn"})
        .by(0.05, { position: v3(0, 8, 0) })
        .by(0.05, { position: v3(0, -8, 0) })
        .by(0.02, { position: v3(0, 5, 0) })
        .by(0.02, { position: v3(0, -5, 0) })
        .call(()=>{
            call && call();
        })
        .start();
    }

}
