## 0.20.0 (2024-06-23)

* added event passive options to Matter.Mouse, closes #930, closes #976 ([e888f3c](https://github.com/liabru/matter-js/commit/e888f3c)), closes [#930](https://github.com/liabru/matter-js/issues/930) [#976](https://github.com/liabru/matter-js/issues/976)
* added arrow key navigation of examples in development demo ([45cad77](https://github.com/liabru/matter-js/commit/45cad77))
* added body removal to Example.remove ([1209e88](https://github.com/liabru/matter-js/commit/1209e88))
* added Constraint.currentLength, closes #1184 ([812f8af](https://github.com/liabru/matter-js/commit/812f8af)), closes [#1184](https://github.com/liabru/matter-js/issues/1184)
* added doc and warning for `Bodies.trapezioid` slope parameter range, closes #1075 ([7ea5bc1](https://github.com/liabru/matter-js/commit/7ea5bc1)), closes [#1075](https://github.com/liabru/matter-js/issues/1075)
* added docs for `body.chamfer` property, closes #1059 ([5ed985d](https://github.com/liabru/matter-js/commit/5ed985d)), closes [#1059](https://github.com/liabru/matter-js/issues/1059)
* added engine beforeSolve event, closes #1173 ([8dd0e99](https://github.com/liabru/matter-js/commit/8dd0e99)), closes [#1173](https://github.com/liabru/matter-js/issues/1173)
* added event.timestamp and event.delta to collision events, closes #368 ([2af54d5](https://github.com/liabru/matter-js/commit/2af54d5)), closes [#368](https://github.com/liabru/matter-js/issues/368)
* added Example.renderResize ([b88c82f](https://github.com/liabru/matter-js/commit/b88c82f))
* added Example.stress4 ([0f0ac93](https://github.com/liabru/matter-js/commit/0f0ac93))
* added Example.substep ([205aaa5](https://github.com/liabru/matter-js/commit/205aaa5))
* added high delta warning to Matter.Engine ([72e6e89](https://github.com/liabru/matter-js/commit/72e6e89))
* added local pairs functions in Pairs.update ([e9da32c](https://github.com/liabru/matter-js/commit/e9da32c))
* added new Matter.Runner with default fixed timestep ([3e61951](https://github.com/liabru/matter-js/commit/3e61951))
* added pixel ratio scaling to render debug stats ([7ec38a1](https://github.com/liabru/matter-js/commit/7ec38a1))
* added render.options.wireframeStrokeStyle, closes #406 ([401553d](https://github.com/liabru/matter-js/commit/401553d)), closes [#406](https://github.com/liabru/matter-js/issues/406)
* added Render.setSize, closes #955, closes #595 ([fc05839](https://github.com/liabru/matter-js/commit/fc05839)), closes [#955](https://github.com/liabru/matter-js/issues/955) [#595](https://github.com/liabru/matter-js/issues/595)
* added repeats and updates options to test tools ([6142991](https://github.com/liabru/matter-js/commit/6142991))
* added updates per frame to Matter.Render debug ([a5b5767](https://github.com/liabru/matter-js/commit/a5b5767))
* changed Composte.removeComposite and Composte.removeBody to reset body.sleepCounter ([6d10c3d](https://github.com/liabru/matter-js/commit/6d10c3d))
* changed Pair.id format to use shorter ids ([5b6f30b](https://github.com/liabru/matter-js/commit/5b6f30b))
* fixed collision events for sleeping pairs, closes #1077 ([51f49ce](https://github.com/liabru/matter-js/commit/51f49ce)), closes [#1077](https://github.com/liabru/matter-js/issues/1077)
* fixed missing `mouse.sourceEvents.mousewheel`, closes #1146 ([272049a](https://github.com/liabru/matter-js/commit/272049a)), closes [#1146](https://github.com/liabru/matter-js/issues/1146)
* fixed Body.setStatic when applied multiple times, closes #641 ([9655785](https://github.com/liabru/matter-js/commit/9655785)), closes [#641](https://github.com/liabru/matter-js/issues/641)
* fixed compare tool layer order in demo testbed ([a3e801a](https://github.com/liabru/matter-js/commit/a3e801a)) ([0cc4d96](https://github.com/liabru/matter-js/commit/0cc4d96))
* fixed Runner.stop docs re. runner.enabled, closes #586, closes #1054 ([2ecc563](https://github.com/liabru/matter-js/commit/2ecc563)), closes [#586](https://github.com/liabru/matter-js/issues/586) [#1054](https://github.com/liabru/matter-js/issues/1054)
* improved Example.substep comments ([8046341](https://github.com/liabru/matter-js/commit/8046341))
* improved Matter.Runner ([b8a1563](https://github.com/liabru/matter-js/commit/b8a1563)) ([7206600](https://github.com/liabru/matter-js/commit/7206600))
* improved Matter.Runner docs ([283cd96](https://github.com/liabru/matter-js/commit/283cd96)) ([dc693e7](https://github.com/liabru/matter-js/commit/dc693e7)) ([6e302a8](https://github.com/liabru/matter-js/commit/6e302a8))
* improved test comparison report ([962fba5](https://github.com/liabru/matter-js/commit/962fba5)) ([2cc1c1c](https://github.com/liabru/matter-js/commit/2cc1c1c))
* improved `body.parts` docs ([013698b](https://github.com/liabru/matter-js/commit/013698b)) ([411af06](https://github.com/liabru/matter-js/commit/411af06)), closes #600 ([c1f9584](https://github.com/liabru/matter-js/commit/c1f9584)), closes [#600](https://github.com/liabru/matter-js/issues/600)
* optimised Collision._findSupports ([653a110](https://github.com/liabru/matter-js/commit/653a110))
* optimised Collision.collides ([6f8a54b](https://github.com/liabru/matter-js/commit/6f8a54b))
* optimised contacts and supports memory and gc use ([97d502e](https://github.com/liabru/matter-js/commit/97d502e))
* optimised pairs and collisions memory and gc use ([f9208df](https://github.com/liabru/matter-js/commit/f9208df))
* optimised Resolver.solvePosition ([89963f7](https://github.com/liabru/matter-js/commit/89963f7))
* optimised Resolver.solveVelocity ([182ba90](https://github.com/liabru/matter-js/commit/182ba90))
* preserve pair.contacts order ([e891d37](https://github.com/liabru/matter-js/commit/e891d37))
* reduced canvas hit testing in demo when using matter-tools ([da99acb](https://github.com/liabru/matter-js/commit/da99acb))
* removed redundant runner.isFixed from examples ([aba0e9e](https://github.com/liabru/matter-js/commit/aba0e9e))
* removed Collision._projectToAxis ([4c56e5b](https://github.com/liabru/matter-js/commit/4c56e5b))
* removed pair.confirmedActive ([72bc203](https://github.com/liabru/matter-js/commit/72bc203))
* renamed Composites function xx and yy params, closes #1095 ([6bda7e8](https://github.com/liabru/matter-js/commit/6bda7e8)), closes [#1095](https://github.com/liabru/matter-js/issues/1095)
* updated development demo render options ([0b131a4](https://github.com/liabru/matter-js/commit/0b131a4))
* updated benchmark tests ([e668c02](https://github.com/liabru/matter-js/commit/e668c02))

## 0.19.0 (2023-02-16)

See the release [readme](https://github.com/liabru/matter-js/blob/0.19.0/README.md) for further information.

* added readme note about vue watchers ([035481c](https://github.com/liabru/matter-js/commit/035481c))
* added readonly body.deltaTime ([0784a5b](https://github.com/liabru/matter-js/commit/0784a5b))
* added speed setters to Body.set ([3ff6ff4](https://github.com/liabru/matter-js/commit/3ff6ff4))
* added support for Matter.Runner and Matter.Render in tests ([7d7bad0](https://github.com/liabru/matter-js/commit/7d7bad0))
* added updateVelocity argument to Body.setPosition, Body.setAngle, Body.translate, Body.rotate ([db8b73f](https://github.com/liabru/matter-js/commit/db8b73f))
* changed engine collisionStart event to trigger after resolving and after updating body velocities ([70600a8](https://github.com/liabru/matter-js/commit/70600a8))
* changed examples to be delta independent ([d7e4f58](https://github.com/liabru/matter-js/commit/d7e4f58))
* deprecated render.controller property ([04d229e](https://github.com/liabru/matter-js/commit/04d229e))
* derived velocity from position in setters ([b6de9ed](https://github.com/liabru/matter-js/commit/b6de9ed))
* fixed issues with engine event.delta ([6f5af77](https://github.com/liabru/matter-js/commit/6f5af77))
* handle null constraint points in Constraint.pointAWorld and Constraint.pointBWorld ([e414464](https://github.com/liabru/matter-js/commit/e414464))
* improved Body.applyForce docs ([3a8264c](https://github.com/liabru/matter-js/commit/3a8264c))
* improved delta factors in resolver and constraint stiffness ([9dc6be7](https://github.com/liabru/matter-js/commit/9dc6be7))
* improved Matter.Body docs for functions and properties including readonly ([85a9eb2](https://github.com/liabru/matter-js/commit/85a9eb2))
* improved Matter.Engine docs ([50fc8f2](https://github.com/liabru/matter-js/commit/50fc8f2))
* improved slingshot example constraint ([c6a1a6d](https://github.com/liabru/matter-js/commit/c6a1a6d))
* improved delta consistency ([87af8a1](https://github.com/liabru/matter-js/commit/87af8a1))
* improved Example.newtonsCradle ([b2bd492](https://github.com/liabru/matter-js/commit/b2bd492))
* removed render element warning ([459425b](https://github.com/liabru/matter-js/commit/459425b))
* removed unused delta params ([a572968](https://github.com/liabru/matter-js/commit/a572968))
* updated body docs ([6bb2855](https://github.com/liabru/matter-js/commit/6bb2855))
* updated body velocity properties after resolving ([d52f7e6](https://github.com/liabru/matter-js/commit/d52f7e6))
* updated Example.manipulation ([5ddac71](https://github.com/liabru/matter-js/commit/5ddac71))
* updated Example.ragdoll ([ec38638](https://github.com/liabru/matter-js/commit/ec38638))
* updated Example.staticFriction and Example.timeScale ([11d5e73](https://github.com/liabru/matter-js/commit/11d5e73))
* updated Matter.Body docs ([db780c3](https://github.com/liabru/matter-js/commit/db780c3))
* updated timing improvements ([10a2a07](https://github.com/liabru/matter-js/commit/10a2a07))
* used Body.getVelocity in Matter.Render ([bf90bdd](https://github.com/liabru/matter-js/commit/bf90bdd))
* used speed getter in Matter.Sleeping and Matter.Render ([6579dfd](https://github.com/liabru/matter-js/commit/6579dfd))



## 0.18.0 (2021-12-15)

* added test capture sort to improve comparison ([ea3c11b](https://github.com/liabru/matter-js/commit/ea3c11b))
* added triangles to mixed bodies example ([b116f64](https://github.com/liabru/matter-js/commit/b116f64))
* added behaviour metric to tests and refactor tests ([8125966](https://github.com/liabru/matter-js/commit/8125966))
* added benchmark test command ([7f34c45](https://github.com/liabru/matter-js/commit/7f34c45))
* added broadphase to Matter.Detector ([a6b5e7d](https://github.com/liabru/matter-js/commit/a6b5e7d))
* added cache checks to Matter.Composite ([32fd285](https://github.com/liabru/matter-js/commit/32fd285))
* added example for Composite.remove ([bc07f56](https://github.com/liabru/matter-js/commit/bc07f56))
* added example stress 3 ([d0ee246](https://github.com/liabru/matter-js/commit/d0ee246))
* added filesize to test comparison report ([b3a8aa3](https://github.com/liabru/matter-js/commit/b3a8aa3))
* added Matter.Collision ([9037f36](https://github.com/liabru/matter-js/commit/9037f36))
* added memory comparison to tests ([bedf84c](https://github.com/liabru/matter-js/commit/bedf84c))
* added note about webpack performance to readme ([80cf76b](https://github.com/liabru/matter-js/commit/80cf76b))
* added stable sorting to test worker and refactor ([81dd2fb](https://github.com/liabru/matter-js/commit/81dd2fb))
* added support for build metadata in Plugin.versionParse ([8bfaff0](https://github.com/liabru/matter-js/commit/8bfaff0))
* changed raycasting example events to enable use in tests ([10afaea](https://github.com/liabru/matter-js/commit/10afaea))
* changed build config to 'source-map' devtool ([e909b04](https://github.com/liabru/matter-js/commit/e909b04))
* changed tests to use a production build rather than source ([55feb89](https://github.com/liabru/matter-js/commit/55feb89))
* deprecated Matter.Grid ([e366d0e](https://github.com/liabru/matter-js/commit/e366d0e))
* fixed sync issues on demo compare tool ([826ed46](https://github.com/liabru/matter-js/commit/826ed46))
* improved performance measurement accuracy in tests ([cd289ec](https://github.com/liabru/matter-js/commit/cd289ec))
* improved test comparison report ([de04c00](https://github.com/liabru/matter-js/commit/de04c00))
* optimised Matter.Detector ([c7cec16](https://github.com/liabru/matter-js/commit/c7cec16)), ([fd1a70e](https://github.com/liabru/matter-js/commit/fd1a70e)), ([caeb07e](https://github.com/liabru/matter-js/commit/caeb07e)), ([efede6e](https://github.com/liabru/matter-js/commit/efede6e))
* optimised Matter.Composite ([52e7977](https://github.com/liabru/matter-js/commit/52e7977))
* optimised Matter.Pair ([d8a6380](https://github.com/liabru/matter-js/commit/d8a6380)), ([48673db](https://github.com/liabru/matter-js/commit/48673db)), ([1073dde](https://github.com/liabru/matter-js/commit/1073dde))
* optimised Matter.Pairs ([a30707f](https://github.com/liabru/matter-js/commit/a30707f)), ([a882a74](https://github.com/liabru/matter-js/commit/a882a74))
* optimised Matter.Resolver ([fceb0ca](https://github.com/liabru/matter-js/commit/fceb0ca)), ([49fbfba](https://github.com/liabru/matter-js/commit/49fbfba)), ([0b07a31](https://github.com/liabru/matter-js/commit/0b07a31)), ([f847f4c](https://github.com/liabru/matter-js/commit/f847f4c)), ([3cf65e8](https://github.com/liabru/matter-js/commit/3cf65e8)), ([30b899c](https://github.com/liabru/matter-js/commit/30b899c)), ([e4b35d3](https://github.com/liabru/matter-js/commit/e4b35d3))
* optimised Matter.SAT ([0d90a17](https://github.com/liabru/matter-js/commit/0d90a17)), ([2096961](https://github.com/liabru/matter-js/commit/2096961)), ([0af144c](https://github.com/liabru/matter-js/commit/0af144c))
* optimised Matter.Vertices ([c198878](https://github.com/liabru/matter-js/commit/c198878)), ([6883d0d](https://github.com/liabru/matter-js/commit/6883d0d)), ([792ae2e](https://github.com/liabru/matter-js/commit/792ae2e))
* refactor test worker and prevent test cache ([ca2fe75](https://github.com/liabru/matter-js/commit/ca2fe75)), ([bcc3168](https://github.com/liabru/matter-js/commit/bcc3168))
* replaced Matter.SAT with Matter.Collision ([b9e7d9d](https://github.com/liabru/matter-js/commit/b9e7d9d))
* show debug stats in dev demo ([2f14ec5](https://github.com/liabru/matter-js/commit/2f14ec5))
* updated dev dependencies ([c5028d5](https://github.com/liabru/matter-js/commit/c5028d5))
* updated examples ([c80ed5c](https://github.com/liabru/matter-js/commit/c80ed5c))
* updated test scripts ([afa467a](https://github.com/liabru/matter-js/commit/afa467a))
* use force exit in tests ([8adf810](https://github.com/liabru/matter-js/commit/8adf810))
* use Matter.Runner in test worker ([2581595](https://github.com/liabru/matter-js/commit/2581595))



## <small>0.17.1 (2021-04-14)</small>

* deprecate Engine.run alias replaced by Runner.run ([5817046](https://github.com/liabru/matter-js/commit/5817046))



## 0.17.0 (2021-04-11)

* add Common.setDecomp and Common.getDecomp ([313c150](https://github.com/liabru/matter-js/commit/313c150))
* add demo build config and refactor demo ([653a647](https://github.com/liabru/matter-js/commit/653a647))
* add docs for all Matter.Render options ([ec3eecc](https://github.com/liabru/matter-js/commit/ec3eecc))
* add title to all examples ([f4d72ba](https://github.com/liabru/matter-js/commit/f4d72ba))
* added Common.deprecated ([ffa3193](https://github.com/liabru/matter-js/commit/ffa3193))
* added Common.warnOnce ([6957dbf](https://github.com/liabru/matter-js/commit/6957dbf))
* added Date.now fallback to Common.now, closes #739 ([c06c107](https://github.com/liabru/matter-js/commit/c06c107)), closes [#739](https://github.com/liabru/matter-js/issues/739)
* added debug stats and performance monitoring to Matter.Render ([119881b](https://github.com/liabru/matter-js/commit/119881b))
* added doc watch script ([164456b](https://github.com/liabru/matter-js/commit/164456b))
* added docs for additional engine timing and render properties ([8017bdb](https://github.com/liabru/matter-js/commit/8017bdb))
* added Example.stats ([9915007](https://github.com/liabru/matter-js/commit/9915007))
* added lastDelta and lastElapsed to engine.timing ([6dc703f](https://github.com/liabru/matter-js/commit/6dc703f))
* build demo ([0816454](https://github.com/liabru/matter-js/commit/0816454))
* change all examples to use Composite.add instead of the alias World.add ([a3f298f](https://github.com/liabru/matter-js/commit/a3f298f))
* changed engine.broadphase to engine.grid ([b74e400](https://github.com/liabru/matter-js/commit/b74e400))
* changed Example.views to use render events ([3ac3498](https://github.com/liabru/matter-js/commit/3ac3498))
* changed world.gravity to engine.gravity ([6abb3b7](https://github.com/liabru/matter-js/commit/6abb3b7))
* deprecated Composites.car and added to car example ([cd9c5d4](https://github.com/liabru/matter-js/commit/cd9c5d4))
* deprecated Composites.newtonsCradle and added to newtonsCradle example ([9ad980b](https://github.com/liabru/matter-js/commit/9ad980b))
* deprecated Composites.softBody and added to softBody and cloth examples ([818f354](https://github.com/liabru/matter-js/commit/818f354))
* improve Render.debug ([1753bf0](https://github.com/liabru/matter-js/commit/1753bf0))
* migrate Matter.World to the equivalent Matter.Composite ([5dbec9b](https://github.com/liabru/matter-js/commit/5dbec9b))
* remove deprecated backwards compatibility engine events from Matter.Runner ([76bf80e](https://github.com/liabru/matter-js/commit/76bf80e))
* remove deprecated backwards compatibility render integration from Matter.Engine ([1aa8ed0](https://github.com/liabru/matter-js/commit/1aa8ed0))
* remove deprecated backwards compatibility render integration from Matter.Runner ([6805f85](https://github.com/liabru/matter-js/commit/6805f85))
* remove deprecated Matter.Metrics ([63a9e98](https://github.com/liabru/matter-js/commit/63a9e98))
* remove deprecated Matter.RenderPixi ([08a515b](https://github.com/liabru/matter-js/commit/08a515b))
* remove unused render shadow function ([e49834d](https://github.com/liabru/matter-js/commit/e49834d))
* run all examples in browser tests ([5734bfd](https://github.com/liabru/matter-js/commit/5734bfd))
* set render showDebug option on examples stress and stress2 ([f2ef3aa](https://github.com/liabru/matter-js/commit/f2ef3aa))
* update matter-tools ([f8d366a](https://github.com/liabru/matter-js/commit/f8d366a))



## <small>0.16.1 (2021-01-31)</small>

* add log capture and reporting in tests ([7bfd3c2](https://github.com/liabru/matter-js/commit/7bfd3c2))
* add matter-wrap as dev dependency ([ef7c4c6](https://github.com/liabru/matter-js/commit/ef7c4c6))
* catch missing plugin require in examples ([1ba1255](https://github.com/liabru/matter-js/commit/1ba1255))
* change example matter-wrap require precedence ([aa1e4e7](https://github.com/liabru/matter-js/commit/aa1e4e7))
* change perf threshold in test ([7b00354](https://github.com/liabru/matter-js/commit/7b00354))
* change test worker decomp require ([5e746b0](https://github.com/liabru/matter-js/commit/5e746b0))
* disable jest cache ([8ee0ebb](https://github.com/liabru/matter-js/commit/8ee0ebb))
* enable useful dev server features ([839f7d9](https://github.com/liabru/matter-js/commit/839f7d9))
* fix decomp require and improve warning message ([e87f64a](https://github.com/liabru/matter-js/commit/e87f64a))
* fix dev server externals ([1f2f9fe](https://github.com/liabru/matter-js/commit/1f2f9fe))
* fix named require in test ([92080ff](https://github.com/liabru/matter-js/commit/92080ff))
* improve CI speed ([1af64eb](https://github.com/liabru/matter-js/commit/1af64eb))
* improve docs for Bodies.fromVertices ([2ade78f](https://github.com/liabru/matter-js/commit/2ade78f))
* improve stack examples with exact contact ([522f4e8](https://github.com/liabru/matter-js/commit/522f4e8))
* improve test report log ([b5326f8](https://github.com/liabru/matter-js/commit/b5326f8))



## 0.16.0 (2021-01-17)

* added removeDuplicatePoints option from poly-decomp 0.3.0 to Bodies.fromVertices ([#639](https://github.com/liabru/matter-js/issues/639), [947cb97](https://github.com/liabru/matter-js/commit/947cb97), [a9694e6](https://github.com/liabru/matter-js/commit/a9694e6))
* added support for > and >= operators in plugin version ranges ([0792716](https://github.com/liabru/matter-js/commit/0792716))
* added support for example versioning in tests ([31d0ace](https://github.com/liabru/matter-js/commit/31d0ace))
* added version targets for examples ([142b7de](https://github.com/liabru/matter-js/commit/142b7de))
* added warning check on browser tests ([12377cc](https://github.com/liabru/matter-js/commit/12377cc))
* changed svg and terrain example to use fetch ([5551cd5](https://github.com/liabru/matter-js/commit/5551cd5))
* changed deprecated comments to avoid confusion ([1e73cab](https://github.com/liabru/matter-js/commit/1e73cab))
* fixed poly-decomp external require ([882e07c](https://github.com/liabru/matter-js/commit/882e07c))
* removed bower.json ([f71d4c0](https://github.com/liabru/matter-js/commit/f71d4c0))
* removed unused dev dependency run-sequence ([be592fd](https://github.com/liabru/matter-js/commit/be592fd))
* updated dev dependencies ([151eb30](https://github.com/liabru/matter-js/commit/151eb30))
* updated matter-tools ([5c66458](https://github.com/liabru/matter-js/commit/5c66458))
* updated matter-tools ([33e8fe8](https://github.com/liabru/matter-js/commit/33e8fe8))
* updated demo matter-tools ([a694ae5](https://github.com/liabru/matter-js/commit/a694ae5))
* updated demo pathseg ([9c5325b](https://github.com/liabru/matter-js/commit/9c5325b))
* updated readme ([3089b41](https://github.com/liabru/matter-js/commit/3089b41))



## 0.15.0 (2020-12-24)

* add window global, stub require and handle bad values in test tools ([497ac80](https://github.com/liabru/matter-js/commit/497ac80))
* added Body.setCentre, closes #684, closes #461, closes #679 ([2ec247b](https://github.com/liabru/matter-js/commit/2ec247b)), closes [#684](https://github.com/liabru/matter-js/issues/684) [#461](https://github.com/liabru/matter-js/issues/461) [#679](https://github.com/liabru/matter-js/issues/679)
* added browser tests ([ceb7cd5](https://github.com/liabru/matter-js/commit/ceb7cd5))
* Added build comparison tools and tests ([b7c938a](https://github.com/liabru/matter-js/commit/b7c938a))
* added check for window in Common.now ([9ef9d02](https://github.com/liabru/matter-js/commit/9ef9d02))
* added comparison output file option to test tools ([45aae25](https://github.com/liabru/matter-js/commit/45aae25))
* Added config and test files to lint ([21e4ea6](https://github.com/liabru/matter-js/commit/21e4ea6))
* added Constraint.pointAWorld and Constraint.pointBWorld ([3c32969](https://github.com/liabru/matter-js/commit/3c32969))
* added examples to dev server bundle and commit built examples ([fe80478](https://github.com/liabru/matter-js/commit/fe80478))
* added module export to examples ([f9ea799](https://github.com/liabru/matter-js/commit/f9ea799))
* added overlap metric to test tools ([3fd674d](https://github.com/liabru/matter-js/commit/3fd674d))
* added release scripts ([341c247](https://github.com/liabru/matter-js/commit/341c247))
* added tag push to release task ([060283b](https://github.com/liabru/matter-js/commit/060283b))
* added timing to engine snapshot ([e0cdbb8](https://github.com/liabru/matter-js/commit/e0cdbb8))
* Added watch content base to dev server ([f471d4e](https://github.com/liabru/matter-js/commit/f471d4e))
* added webpack build script ([046013e](https://github.com/liabru/matter-js/commit/046013e))
* changed alpha build configuration ([182c84a](https://github.com/liabru/matter-js/commit/182c84a))
* changed demo to auto populate examples with sourceLink and init ([5b0d34b](https://github.com/liabru/matter-js/commit/5b0d34b))
* changed demo to serve without sub-directory ([823bbc0](https://github.com/liabru/matter-js/commit/823bbc0))
* changed docs build config ([864452d](https://github.com/liabru/matter-js/commit/864452d))
* changed example tests to use jest ([104d319](https://github.com/liabru/matter-js/commit/104d319))
* fix decomp import in Bodies.fromVertices ([94e9614](https://github.com/liabru/matter-js/commit/94e9614))
* fix decomp require ([0af1645](https://github.com/liabru/matter-js/commit/0af1645))
* fix issues with render pixel ratio, closes #686, closes #687 ([d577477](https://github.com/liabru/matter-js/commit/d577477)), closes [#686](https://github.com/liabru/matter-js/issues/686) [#687](https://github.com/liabru/matter-js/issues/687)
* fix lint ([5a0079d](https://github.com/liabru/matter-js/commit/5a0079d))
* fix lint issues ([9ca21c1](https://github.com/liabru/matter-js/commit/9ca21c1))
* fix path to build in test worker ([fcdb4fa](https://github.com/liabru/matter-js/commit/fcdb4fa))
* fix preversion script ([c368c14](https://github.com/liabru/matter-js/commit/c368c14))
* fix terrain example module export ([4a967ec](https://github.com/liabru/matter-js/commit/4a967ec))
* Fix typo in docs ([c486635](https://github.com/liabru/matter-js/commit/c486635))
* fixed plugins in compare ([82bb415](https://github.com/liabru/matter-js/commit/82bb415))
* implemented threaded comparison testing ([285d70d](https://github.com/liabru/matter-js/commit/285d70d))
* Optimized Body's hidden class ([b3220cf](https://github.com/liabru/matter-js/commit/b3220cf))
* Optimized Events.trigger method when no event is emitted ([b17cb48](https://github.com/liabru/matter-js/commit/b17cb48))
* remove gulp ([6a28090](https://github.com/liabru/matter-js/commit/6a28090))
* remove old demo libs ([13c7eb5](https://github.com/liabru/matter-js/commit/13c7eb5))
* removed unused gulp release tasks ([e5a7311](https://github.com/liabru/matter-js/commit/e5a7311))
* removed yuidocjs dev dependency ([ee848d2](https://github.com/liabru/matter-js/commit/ee848d2))
* Set loose build version on dev server ([1fcf292](https://github.com/liabru/matter-js/commit/1fcf292))
* update build script ([90abab6](https://github.com/liabru/matter-js/commit/90abab6))
* update default render theme ([d258411](https://github.com/liabru/matter-js/commit/d258411))
* update demo and example render styles ([6dd5ec5](https://github.com/liabru/matter-js/commit/6dd5ec5))
* update dependencies ([e1e058c](https://github.com/liabru/matter-js/commit/e1e058c)) ([5f5b8a1](https://github.com/liabru/matter-js/commit/5f5b8a1))
* update examples build config and scripts ([69afb11](https://github.com/liabru/matter-js/commit/69afb11))
* update package lock ([ac3da07](https://github.com/liabru/matter-js/commit/ac3da07))
* updated build scripts ([6b698ea](https://github.com/liabru/matter-js/commit/6b698ea))
* updated ci ([288b9cd](https://github.com/liabru/matter-js/commit/288b9cd))
* updated docs ([50cf171](https://github.com/liabru/matter-js/commit/50cf171))
* updated readme ([ea5c012](https://github.com/liabru/matter-js/commit/ea5c012)) ([61b1963](https://github.com/liabru/matter-js/commit/61b1963))



<a name="0.14.2"></a>
## <small>0.14.2 (2018-06-11)</small>

* added missing polyfill warning to Svg.pathToVertices ([511de5b](https://github.com/liabru/matter-js/commit/511de5b))
* fix Composite.bounds global issue, closes #627, closes #544 ([f7f77b4](https://github.com/liabru/matter-js/commit/f7f77b4)), closes [#627](https://github.com/liabru/matter-js/issues/627) [#544](https://github.com/liabru/matter-js/issues/544)
* fix docs for Vector.angle, closes #471 ([db30d79](https://github.com/liabru/matter-js/commit/db30d79)), closes [#471](https://github.com/liabru/matter-js/issues/471)
* Fixed constraint pointB documentation ([0b5ce1d](https://github.com/liabru/matter-js/commit/0b5ce1d))
* fixed require for external libraries, closes #629, closes #559, closes #593, closes #365, closes #62 ([0cf97f5](https://github.com/liabru/matter-js/commit/0cf97f5)), closes [#629](https://github.com/liabru/matter-js/issues/629) [#559](https://github.com/liabru/matter-js/issues/559) [#593](https://github.com/liabru/matter-js/issues/593) [#365](https://github.com/liabru/matter-js/issues/365) [#629](https://github.com/liabru/matter-js/issues/629)
* remove browserify-shim ([e3c176e](https://github.com/liabru/matter-js/commit/e3c176e))
* updated pathseg library, closes #548, closes #602, closes #424 ([1e5758f](https://github.com/liabru/matter-js/commit/1e5758f)), closes [#548](https://github.com/liabru/matter-js/issues/548) [#602](https://github.com/liabru/matter-js/issues/602) [#424](https://github.com/liabru/matter-js/issues/424)



<a name="0.14.1"></a>
## 0.14.1 (2018-01-10)

* fix Common.isElement on node, closes #535 ([ec38eeb](https://github.com/liabru/matter-js/commit/ec38eeb)), closes [#535](https://github.com/liabru/matter-js/issues/535)



<a name="0.14.0"></a>
# 0.14.0 (2017-11-30)

* added .eslintignore ([2279e15](https://github.com/liabru/matter-js/commit/2279e15))
* added examples build task ([6108a31](https://github.com/liabru/matter-js/commit/6108a31))
* added missing docs for Matter.World aliases ([841bf97](https://github.com/liabru/matter-js/commit/841bf97))
* added Query.collides, closes #478 ([6593a72](https://github.com/liabru/matter-js/commit/6593a72)), closes [#478](https://github.com/liabru/matter-js/issues/478)
* change examples to render using a fixed resolution ([0895d81](https://github.com/liabru/matter-js/commit/0895d81))
* Do not warn on missing render.element if the canvas is already parented (because it was passed in at ([a529ec9](https://github.com/liabru/matter-js/commit/a529ec9))
* fix `point` argument of Body.scale, closes #428 ([894c1ef](https://github.com/liabru/matter-js/commit/894c1ef)), closes [#428](https://github.com/liabru/matter-js/issues/428)
* fix Body.scale for compound bodies ([50a89d0](https://github.com/liabru/matter-js/commit/50a89d0))
* fix centroid for static compound bodies, closes #483 ([ece66e6](https://github.com/liabru/matter-js/commit/ece66e6)), closes [#483](https://github.com/liabru/matter-js/issues/483)
* fix Common.isElement, closes #501, closes #507, closes #459, closes #468, closes #517 ([18a0845](https://github.com/liabru/matter-js/commit/18a0845)), closes [#501](https://github.com/liabru/matter-js/issues/501) [#507](https://github.com/liabru/matter-js/issues/507) [#459](https://github.com/liabru/matter-js/issues/459) [#468](https://github.com/liabru/matter-js/issues/468) [#517](https://github.com/liabru/matter-js/issues/517)
* fix inertia change in Body.setMass, closes #378 ([f7d1877](https://github.com/liabru/matter-js/commit/f7d1877)), closes [#378](https://github.com/liabru/matter-js/issues/378)
* fix Vertices.chamfer radius argument, closes #467 ([3bceef4](https://github.com/liabru/matter-js/commit/3bceef4)), closes [#467](https://github.com/liabru/matter-js/issues/467)
* improved docs for constraints on compound bodies, closes #442 ([3307760](https://github.com/liabru/matter-js/commit/3307760)), closes [#442](https://github.com/liabru/matter-js/issues/442)
* moved all private functions to module namespaces ([64be5a5](https://github.com/liabru/matter-js/commit/64be5a5))
* moved private Matter.Engine functions on to namespace, closes #523 ([9eae36f](https://github.com/liabru/matter-js/commit/9eae36f)), closes [#523](https://github.com/liabru/matter-js/issues/523)
* remove spelling mistake ([e5c4b47](https://github.com/liabru/matter-js/commit/e5c4b47))



<a name="0.13.0"></a>
# 0.13.0 (2017-07-06)

* added Composite.bounds ([79ffcf8](https://github.com/liabru/matter-js/commit/79ffcf8))
* added constraint damping ([44c4d1f](https://github.com/liabru/matter-js/commit/44c4d1f))
* added constraint.render.type and constraint.render.anchor ([0952516](https://github.com/liabru/matter-js/commit/0952516))
* added Example.constraints ([b93c08f](https://github.com/liabru/matter-js/commit/b93c08f))
* added Example.doublePendulum ([a7aa47d](https://github.com/liabru/matter-js/commit/a7aa47d))
* added Examples.ragdoll ([48611c5](https://github.com/liabru/matter-js/commit/48611c5))
* added optional output argument to Vector.rotate ([59d62be](https://github.com/liabru/matter-js/commit/59d62be))
* added rotation point parameter to Body.rotate, closes #410 ([749ed50](https://github.com/liabru/matter-js/commit/749ed50)), closes [#410](https://github.com/liabru/matter-js/issues/410)
* added second pass for constraint solving ([f49d053](https://github.com/liabru/matter-js/commit/f49d053))
* change constraint solve order ([a5bd6b2](https://github.com/liabru/matter-js/commit/a5bd6b2))
* changed lint rules ([d1fbe95](https://github.com/liabru/matter-js/commit/d1fbe95))
* fix constraint.angularStiffness ([ab0283b](https://github.com/liabru/matter-js/commit/ab0283b))
* fix Example.collisionFiltering rendering ([74a7cfc](https://github.com/liabru/matter-js/commit/74a7cfc))
* fix lint errors ([774d8bc](https://github.com/liabru/matter-js/commit/774d8bc))
* fix soft body stiffness ([1bae2de](https://github.com/liabru/matter-js/commit/1bae2de))
* fixed Common.now ([2b76c4c](https://github.com/liabru/matter-js/commit/2b76c4c))
* fixed constraint torque calculation ([a8d1950](https://github.com/liabru/matter-js/commit/a8d1950))
* fixed constraint torque calculation ([068fdc0](https://github.com/liabru/matter-js/commit/068fdc0))
* fixed Examples.compound constraint offset ([e6babf0](https://github.com/liabru/matter-js/commit/e6babf0))
* fixed various constraints in examples ([ac67ef8](https://github.com/liabru/matter-js/commit/ac67ef8))
* fixed various problems with constraints ([26a60e4](https://github.com/liabru/matter-js/commit/26a60e4))
* implemented constraint warming ([daf26af](https://github.com/liabru/matter-js/commit/daf26af))
* improved Example.car using pin constraint ([130e6b3](https://github.com/liabru/matter-js/commit/130e6b3))
* improved Example.catapult using pin constraint ([0e15099](https://github.com/liabru/matter-js/commit/0e15099))
* improved Example.chains using pin constraint ([9d2f0ff](https://github.com/liabru/matter-js/commit/9d2f0ff))
* improved Examples.bridge ([b277b39](https://github.com/liabru/matter-js/commit/b277b39))
* improved Examples.bridge ([b6e5973](https://github.com/liabru/matter-js/commit/b6e5973))
* improved position resolver ([71998a0](https://github.com/liabru/matter-js/commit/71998a0))
* improved spring and pin rendering ([837c43b](https://github.com/liabru/matter-js/commit/837c43b))
* refactored Common.isElement ([295cffe](https://github.com/liabru/matter-js/commit/295cffe))
* removed Common.shadeColor ([d63b0c2](https://github.com/liabru/matter-js/commit/d63b0c2))
* tweaked Example.doublePendulum ([4894008](https://github.com/liabru/matter-js/commit/4894008))
* update alpha build ([fe9b05d](https://github.com/liabru/matter-js/commit/fe9b05d))
* update alpha build ([b874f4d](https://github.com/liabru/matter-js/commit/b874f4d))
* update alpha build ([08aa3f2](https://github.com/liabru/matter-js/commit/08aa3f2))
* update readme and remove redundant plugins ([2560a68](https://github.com/liabru/matter-js/commit/2560a68))
* Update README.md ([4168d3c](https://github.com/liabru/matter-js/commit/4168d3c))
* updated license and contributing ([d2af721](https://github.com/liabru/matter-js/commit/d2af721))
* updated readme ([26c1200](https://github.com/liabru/matter-js/commit/26c1200))
* upgraded matter-tools ([477f2d7](https://github.com/liabru/matter-js/commit/477f2d7))
* upgraded matter-wrap ([c9294eb](https://github.com/liabru/matter-js/commit/c9294eb))



<a name="0.12.0"></a>
# 0.12.0 (2017-02-02)

* add poly-decamp require shim ([c72a9d0](https://github.com/liabru/matter-js/commit/c72a9d0))
* added body.plugin, composite.plugin, constraint.plugin, engine.plugin properties ([b353393](https://github.com/liabru/matter-js/commit/b353393))
* added Render.lookAt ([47443b3](https://github.com/liabru/matter-js/commit/47443b3))
* added Render.startViewTransform and Render.endViewTransform ([c8e5d5c](https://github.com/liabru/matter-js/commit/c8e5d5c))
* change Matter.MouseConstraint to use engine beforeUpdate event, closes #73 ([ffb128c](https://github.com/liabru/matter-js/commit/ffb128c)), closes [#73](https://github.com/liabru/matter-js/issues/73)
* changed default render styles ([719ad64](https://github.com/liabru/matter-js/commit/719ad64))
* changed plugins to use body.plugin ([3fdf343](https://github.com/liabru/matter-js/commit/3fdf343))
* fix Body.setStatic(body, false), closes #187 ([a815ce4](https://github.com/liabru/matter-js/commit/a815ce4)), closes [#187](https://github.com/liabru/matter-js/issues/187)
* fix build temporarily ([805ff2a](https://github.com/liabru/matter-js/commit/805ff2a))
* fix lint ([0ce686d](https://github.com/liabru/matter-js/commit/0ce686d))
* fix lint ([714b8ae](https://github.com/liabru/matter-js/commit/714b8ae))
* fix Render.grid ([dd83386](https://github.com/liabru/matter-js/commit/dd83386))
* fix test npm script ([6285df9](https://github.com/liabru/matter-js/commit/6285df9))
* fix v8 optimisation issues ([86c4a61](https://github.com/liabru/matter-js/commit/86c4a61))
* Fixes #220 ([74de894](https://github.com/liabru/matter-js/commit/74de894)), closes [#220](https://github.com/liabru/matter-js/issues/220)
* improved demo and examples ([1a40f27](https://github.com/liabru/matter-js/commit/1a40f27))
* improved demo and examples ([ace1a9f](https://github.com/liabru/matter-js/commit/ace1a9f))
* improved demo and examples ([8cdbb38](https://github.com/liabru/matter-js/commit/8cdbb38))
* Update to latest poly-decomp.js API ([3d8f88e](https://github.com/liabru/matter-js/commit/3d8f88e))
* updated alpha build ([6c19f0b](https://github.com/liabru/matter-js/commit/6c19f0b))
* updated dependencies ([8c140bd](https://github.com/liabru/matter-js/commit/8c140bd))
* updated matter-tools ([def8d22](https://github.com/liabru/matter-js/commit/def8d22))



<a name="0.11.1"></a>
## 0.11.1 (2016-11-09)


* added derequire to build ([ded796c](https://github.com/liabru/matter-js/commit/ded796c))



<a name="0.11.0"></a>
# 0.11.0 (2016-11-04)


* add logo to readme ([d54dec3](https://github.com/liabru/matter-js/commit/d54dec3))
* added docs for Matter.Plugin with tweaks ([3883981](https://github.com/liabru/matter-js/commit/3883981))
* added Example.attractors ([758bbe8](https://github.com/liabru/matter-js/commit/758bbe8))
* added Matter.before, Matter.after, Common.chainPathBefore, Common.chainPathAfter, Common.get, Common ([50ad7ca](https://github.com/liabru/matter-js/commit/50ad7ca))
* added Matter.Plugin initial implementation ([e84c537](https://github.com/liabru/matter-js/commit/e84c537))
* added note in docs about vertices order ([ad033f5](https://github.com/liabru/matter-js/commit/ad033f5))
* added plugin status logging ([51b7b1d](https://github.com/liabru/matter-js/commit/51b7b1d))
* added plugins matter-attractors, matter-gravity, matter-world-wrap, removed test plugins ([59bfa0b](https://github.com/liabru/matter-js/commit/59bfa0b))
* change plugins to use best practices ([37d4258](https://github.com/liabru/matter-js/commit/37d4258))
* change travis node version to latest stable ([ee33686](https://github.com/liabru/matter-js/commit/ee33686))
* changed naming approach for prerelease versions ([83ae546](https://github.com/liabru/matter-js/commit/83ae546))
* fix build flags ([29d182c](https://github.com/liabru/matter-js/commit/29d182c))
* fix build task for travis ([6aa3661](https://github.com/liabru/matter-js/commit/6aa3661))
* fix gravity reset in demo ([c00df81](https://github.com/liabru/matter-js/commit/c00df81))
* fix gulp build version replacement ([faf6bec](https://github.com/liabru/matter-js/commit/faf6bec))
* fix Matter.Mouse when element does not have fixed dimensions, closes #73 ([1340159](https://github.com/liabru/matter-js/commit/1340159)), closes [#73](https://github.com/liabru/matter-js/issues/73)
* fix release tasks ([549983d](https://github.com/liabru/matter-js/commit/549983d))
* fix requestAnimationFrame polyfill for Matter.Runner, closes #252 ([7c8f6ce](https://github.com/liabru/matter-js/commit/7c8f6ce)), closes [#252](https://github.com/liabru/matter-js/issues/252)
* fix tests ([54e7d9c](https://github.com/liabru/matter-js/commit/54e7d9c))
* fixed Body.create with no options ([0e5a457](https://github.com/liabru/matter-js/commit/0e5a457))
* fixed issue with Matter.RenderPixi not being cleared when bodies removed, closes #218 ([4972af8](https://github.com/liabru/matter-js/commit/4972af8)), closes [#218](https://github.com/liabru/matter-js/issues/218)
* fixed various Matter.Plugin issues ([05d0961](https://github.com/liabru/matter-js/commit/05d0961))
* improve docs ([9856e3c](https://github.com/liabru/matter-js/commit/9856e3c))
* improved logging ([d4d64ed](https://github.com/liabru/matter-js/commit/d4d64ed))
* Limit packaging extraneous files ([3accec6](https://github.com/liabru/matter-js/commit/3accec6))
* Merge branch 'jackismissing-master' ([3452465](https://github.com/liabru/matter-js/commit/3452465))
* Merge branch 'master' of https://github.com/jackismissing/matter-js into jackismissing-master ([ba19130](https://github.com/liabru/matter-js/commit/ba19130))
* Merge branch 'plugins' ([60d0839](https://github.com/liabru/matter-js/commit/60d0839))
* Merge pull request #1 from jackismissing/jackismissing-patch-1 ([46a2bf6](https://github.com/liabru/matter-js/commit/46a2bf6))
* Merge pull request #244 from MarkHerhold/master ([3449ca5](https://github.com/liabru/matter-js/commit/3449ca5))
* refactor plugin system ([8da170f](https://github.com/liabru/matter-js/commit/8da170f))
* refactored plugins ([b4a3453](https://github.com/liabru/matter-js/commit/b4a3453))
* remove and ignore all test refs ([7a7187a](https://github.com/liabru/matter-js/commit/7a7187a))
* RenderPixi.js - added missing dependencies ([aec19ae](https://github.com/liabru/matter-js/commit/aec19ae))
* update Matter.Plugin docs ([6f8b705](https://github.com/liabru/matter-js/commit/6f8b705))
* updated edge build ([1d05499](https://github.com/liabru/matter-js/commit/1d05499))
* updated edge build ([0bdaece](https://github.com/liabru/matter-js/commit/0bdaece))
* updated readme ([a408854](https://github.com/liabru/matter-js/commit/a408854))
* updated readme ([4da2e25](https://github.com/liabru/matter-js/commit/4da2e25))
* updated readme ([9ccc028](https://github.com/liabru/matter-js/commit/9ccc028))
* updated readme ([faf534a](https://github.com/liabru/matter-js/commit/faf534a))
* updated readme ([5ca9aca](https://github.com/liabru/matter-js/commit/5ca9aca))
* updated readme ([e3e9080](https://github.com/liabru/matter-js/commit/e3e9080))
* updated readme ([c4cce9e](https://github.com/liabru/matter-js/commit/c4cce9e))
* updated readme ([4b5837e](https://github.com/liabru/matter-js/commit/4b5837e))
* updated readme ([098f224](https://github.com/liabru/matter-js/commit/098f224))



<a name="0.10.0"></a>
# 0.10.0 (2016-05-01)


* added release:push:docs task ([04cbd1d](https://github.com/liabru/matter-js/commit/04cbd1d))
* decouple Matter.Render from Matter.Engine ([de823eb](https://github.com/liabru/matter-js/commit/de823eb))
* decouple Matter.RenderPixi ([72f90b9](https://github.com/liabru/matter-js/commit/72f90b9))
* deprecated Matter.RenderPixi ([e8c899a](https://github.com/liabru/matter-js/commit/e8c899a))
* deprecated Matter.RenderPixi ([a6b97cd](https://github.com/liabru/matter-js/commit/a6b97cd))
* fix tests ([f59e220](https://github.com/liabru/matter-js/commit/f59e220))
* fix tests ([c26684e](https://github.com/liabru/matter-js/commit/c26684e))
* Merge branch 'decouple-renderer' ([31067c9](https://github.com/liabru/matter-js/commit/31067c9))



<a name="0.9.3"></a>
## 0.9.3 (2016-04-19)


* added readonly to docs for type property, closes #235 ([afd7531](https://github.com/liabru/matter-js/commit/afd7531)), closes [#235](https://github.com/liabru/matter-js/issues/235)
* Engine uses provided world; fixes issue #230 ([158c404](https://github.com/liabru/matter-js/commit/158c404)), closes [#230](https://github.com/liabru/matter-js/issues/230)
* fix issue with removed bodies causing collisions ([23a773a](https://github.com/liabru/matter-js/commit/23a773a))
* fix Matter.Engine.create docs to show element param is optional ([e2e7c0b](https://github.com/liabru/matter-js/commit/e2e7c0b))
* handle missing options in Engine.create ([f36fe2c](https://github.com/liabru/matter-js/commit/f36fe2c))
* improved release tasks ([e13d2d2](https://github.com/liabru/matter-js/commit/e13d2d2))
* Merge branch 'master' of github.com:liabru/matter-js ([d373172](https://github.com/liabru/matter-js/commit/d373172))
* Merge pull request #237 from iamjoshua/master ([b724959](https://github.com/liabru/matter-js/commit/b724959)), closes [#230](https://github.com/liabru/matter-js/issues/230)
* set release task to default to patch ([9d396fe](https://github.com/liabru/matter-js/commit/9d396fe))
* updated edge build ([7eb9ac7](https://github.com/liabru/matter-js/commit/7eb9ac7))



<a name="0.9.2"></a>
## 0.9.2 (2016-04-07)


* Add permeability example and doc entry ([6e7add1](https://github.com/liabru/matter-js/commit/6e7add1))
* Add permeable objects ([1573359](https://github.com/liabru/matter-js/commit/1573359))
* Change permeable name to sensors, add isSensor to Pair ([28084b0](https://github.com/liabru/matter-js/commit/28084b0))
* Document World bounds and Grid bucket size. ([5054c97](https://github.com/liabru/matter-js/commit/5054c97))
* fix Body.scale for circles, closes #234 ([f428d6b](https://github.com/liabru/matter-js/commit/f428d6b)), closes [#234](https://github.com/liabru/matter-js/issues/234)
* Fix the out-of-bounds check in grid broadphase ([a20a9fb](https://github.com/liabru/matter-js/commit/a20a9fb))
* Merge pull request #224 from brollb/223-bounds-ignored-in-renderer ([1944f6a](https://github.com/liabru/matter-js/commit/1944f6a)), closes [#223](https://github.com/liabru/matter-js/issues/223)
* Merge pull request #231 from Rantanen/patch-1 ([b6f6a03](https://github.com/liabru/matter-js/commit/b6f6a03))
* Merge pull request #232 from Rantanen/docs ([79fa57e](https://github.com/liabru/matter-js/commit/79fa57e))
* Merged sensors from Misiur-master ([e1a52d5](https://github.com/liabru/matter-js/commit/e1a52d5))
* Update README.md ([a5b535d](https://github.com/liabru/matter-js/commit/a5b535d))
* Update README.md ([a31ab39](https://github.com/liabru/matter-js/commit/a31ab39))
* Updated `hasBounds` default value. Fixes #223 ([053ea76](https://github.com/liabru/matter-js/commit/053ea76)), closes [#223](https://github.com/liabru/matter-js/issues/223)
* updated test refs ([93ba111](https://github.com/liabru/matter-js/commit/93ba111))



<a name="0.9.1"></a>
## 0.9.1 (2016-02-15)


* added default for delta parameter in Engine.update, closes #200 ([490d232](https://github.com/liabru/matter-js/commit/490d232)), closes [#200](https://github.com/liabru/matter-js/issues/200)
* added docs for body.render.opacity ([adcb610](https://github.com/liabru/matter-js/commit/adcb610))
* added SVGPathSeg polyfill, closes #196 ([8fcb893](https://github.com/liabru/matter-js/commit/8fcb893)), closes [#196](https://github.com/liabru/matter-js/issues/196)
* Adding the opacity attribute to be able to draw semi-transarent sprites ([5b755a1](https://github.com/liabru/matter-js/commit/5b755a1))
* allow passing of pixi objects to Matter.RenderPixi at creation, closes #193 ([dbdabcc](https://github.com/liabru/matter-js/commit/dbdabcc)), closes [#193](https://github.com/liabru/matter-js/issues/193)
* change main reference in package.json ([633c305](https://github.com/liabru/matter-js/commit/633c305))
* Changed bounds checking MIN_VALUE to -MAX_VALUE. Fixes #202 ([dd5e260](https://github.com/liabru/matter-js/commit/dd5e260)), closes [#202](https://github.com/liabru/matter-js/issues/202)
* fix issue with Bodies.circle label option, closes #195 ([e7e8c26](https://github.com/liabru/matter-js/commit/e7e8c26)), closes [#195](https://github.com/liabru/matter-js/issues/195)
* fix lint issue ([b4e875b](https://github.com/liabru/matter-js/commit/b4e875b))
* fixed build issue ([bb3d43f](https://github.com/liabru/matter-js/commit/bb3d43f))
* fixed rendering of angle indicators ([aaffee3](https://github.com/liabru/matter-js/commit/aaffee3))
* fixed rendering of compound bodies ([99dd6c5](https://github.com/liabru/matter-js/commit/99dd6c5))
* fixes to body opacity rendering ([8ac06b2](https://github.com/liabru/matter-js/commit/8ac06b2))
* Merge branch 'master' of https://github.com/ma1069/matter-js into ma1069-master ([c99e6af](https://github.com/liabru/matter-js/commit/c99e6af))
* Merge pull request #199 from kevinboudot/master ([34fa27a](https://github.com/liabru/matter-js/commit/34fa27a))
* remove redundant console.log from gulpfile ([b5006e3](https://github.com/liabru/matter-js/commit/b5006e3))
* Update README.md ([1bfb758](https://github.com/liabru/matter-js/commit/1bfb758))
* updated edge build ([cc80837](https://github.com/liabru/matter-js/commit/cc80837))
* updated test refs ([cfdc0b3](https://github.com/liabru/matter-js/commit/cfdc0b3))
* updated test refs ([4d65dd1](https://github.com/liabru/matter-js/commit/4d65dd1))



<a name="0.9.0"></a>
# 0.9.0 (2016-01-16)

### release summary

* improved documentation
* improved performance
* improved stability
* improved accuracy
* improved friction
* improved sleeping
* improved constraints
* improved examples

* added concave body support
* added compound body support
* added collision filters
* added Matter.Body property setters
* added Matter.Sleeping events
* added Matter.Composite events
* added Matter.Composite transforms
* added Matter.MouseConstraint events
* added Matter.Render events
* added Matter.Runner
* added support for nodejs
* added support for high dpi rendering
* added multiple examples
* added automated tests

* migrated from grunt to gulp
* migrated to browserify
* migrated to pixi.js v3

* fixed multiple issues (see commit log)


### commit log

* Add Pixi DisplayObjectContainer to allow view bounds in webGL ([97f0f8d](https://github.com/liabru/matter-js/commit/97f0f8d))
* added beforeRender and afterRender events to Matter.Render ([aa48322](https://github.com/liabru/matter-js/commit/aa48322))
* added body sleepStart and sleepEnd events, closes #91 ([bc26469](https://github.com/liabru/matter-js/commit/bc26469)), closes [#91](https://github.com/liabru/matter-js/issues/91)
* added Body.nextCategory ([d249165](https://github.com/liabru/matter-js/commit/d249165))
* added Body.set ([235b6c8](https://github.com/liabru/matter-js/commit/235b6c8))
* added Body.setMass, Body.setDensity, Body.setInertia ([ca978fa](https://github.com/liabru/matter-js/commit/ca978fa))
* added Body.setPosition, Body.setAngle, Body.setVelocity, Body.setAngularVelocity ([7ed28f7](https://github.com/liabru/matter-js/commit/7ed28f7))
* added Body.setVertices and Vector.clone ([b6dbb25](https://github.com/liabru/matter-js/commit/b6dbb25))
* added building and contributing to readme ([9a59e34](https://github.com/liabru/matter-js/commit/9a59e34))
* added collisionFilter support to MouseConstraint ([cee8d55](https://github.com/liabru/matter-js/commit/cee8d55))
* added composite events ([2841522](https://github.com/liabru/matter-js/commit/2841522))
* added composite events example to Demo.events ([296d47e](https://github.com/liabru/matter-js/commit/296d47e))
* added Composite.translate, Composite.rotate, Composite.scale ([4c4962f](https://github.com/liabru/matter-js/commit/4c4962f))
* added compound support to Query.ray ([10e5d0f](https://github.com/liabru/matter-js/commit/10e5d0f))
* added constraint to Demo.compound ([87fbf51](https://github.com/liabru/matter-js/commit/87fbf51))
* added CONTRIBUTING.md ([7c936d5](https://github.com/liabru/matter-js/commit/7c936d5))
* added CONTRIBUTING.md ([261c794](https://github.com/liabru/matter-js/commit/261c794))
* added Demo.compositeManipulation ([4051823](https://github.com/liabru/matter-js/commit/4051823))
* added Demo.compound ([b7bf5d6](https://github.com/liabru/matter-js/commit/b7bf5d6))
* added Demo.concave, added Bodies.fromVertices, added Vertices.isConvex, fixed compound properties ([0b8efa5](https://github.com/liabru/matter-js/commit/0b8efa5))
* added Demo.manipulation ([0a453a2](https://github.com/liabru/matter-js/commit/0a453a2))
* added Demo.setManualControl ([203252a](https://github.com/liabru/matter-js/commit/203252a))
* added Demo.slingshot ([3043baa](https://github.com/liabru/matter-js/commit/3043baa))
* added Demo.staticFriction ([4491dfd](https://github.com/liabru/matter-js/commit/4491dfd))
* added Demo.svg, Demo.compoundStack, Demo.concave ([17589bc](https://github.com/liabru/matter-js/commit/17589bc))
* added Demo.terrain ([3132d70](https://github.com/liabru/matter-js/commit/3132d70))
* added docs ([200fcbe](https://github.com/liabru/matter-js/commit/200fcbe))
* added docs for engine.timing.isFixed ([e22ceeb](https://github.com/liabru/matter-js/commit/e22ceeb))
* added drag events to MouseConstraint, closes #45 ([c254c8d](https://github.com/liabru/matter-js/commit/c254c8d)), closes [#45](https://github.com/liabru/matter-js/issues/45)
* added early out in Constraint.postSolveAll, pass body.velocity when updating bounds ([8210dbe](https://github.com/liabru/matter-js/commit/8210dbe))
* added internal edge flagging to Bodies.fromVertices ([ca75fde](https://github.com/liabru/matter-js/commit/ca75fde))
* added Matter.Svg.pathToPoints ([7822ead](https://github.com/liabru/matter-js/commit/7822ead))
* added Matter.version ([e0a6de0](https://github.com/liabru/matter-js/commit/e0a6de0))
* added Matter.World extends  Matter.Composite to docs ([b3921fb](https://github.com/liabru/matter-js/commit/b3921fb))
* added minimum area check to Bodies.fromVertices ([bf11ee5](https://github.com/liabru/matter-js/commit/bf11ee5))
* added missing dependency to Render.js ([df5f16c](https://github.com/liabru/matter-js/commit/df5f16c))
* added mouse constraint collision mask example to demo ([440e9d2](https://github.com/liabru/matter-js/commit/440e9d2))
* added Mouse.create warning for omitted element ([af83e27](https://github.com/liabru/matter-js/commit/af83e27))
* added MouseConstraint.create warning for omitted element ([b6603ca](https://github.com/liabru/matter-js/commit/b6603ca))
* added node demo tests ([71c1ae8](https://github.com/liabru/matter-js/commit/71c1ae8))
* added options to Metrics.create ([1b7e27d](https://github.com/liabru/matter-js/commit/1b7e27d))
* added Query.point ([98ea7c7](https://github.com/liabru/matter-js/commit/98ea7c7))
* added release tasks ([5479fbc](https://github.com/liabru/matter-js/commit/5479fbc))
* added Render.create warning for omitted element ([0583cdb](https://github.com/liabru/matter-js/commit/0583cdb))
* added render.options.showMousePosition ([e191d44](https://github.com/liabru/matter-js/commit/e191d44))
* added Render.showInternalEdges, added rendering bounds + axes + positions for compounds, fixed rende ([5ab2bf3](https://github.com/liabru/matter-js/commit/5ab2bf3))
* added Render.vertexNumbers, Render.bodyConvexHulls ([9c139ed](https://github.com/liabru/matter-js/commit/9c139ed))
* added Runner.create and Runner.tick ([5c69f2e](https://github.com/liabru/matter-js/commit/5c69f2e))
* added source link to demo ([1e756d3](https://github.com/liabru/matter-js/commit/1e756d3))
* added sprite offsets relative to centre of mass, closes #153 ([3de9d00](https://github.com/liabru/matter-js/commit/3de9d00)), closes [#153](https://github.com/liabru/matter-js/issues/153)
* added startdrag and enddrag events to Demo.events ([7c75614](https://github.com/liabru/matter-js/commit/7c75614))
* added support for compound bodies in MouseConstraint ([d6829bf](https://github.com/liabru/matter-js/commit/d6829bf))
* added support for hidpi rendering ([4746eb9](https://github.com/liabru/matter-js/commit/4746eb9))
* added support for multiple vertices input in Bodies.fromVertices ([e8205f8](https://github.com/liabru/matter-js/commit/e8205f8))
* added support for sprite scale in RenderPixi, closes #54 ([8dea166](https://github.com/liabru/matter-js/commit/8dea166)), closes [#54](https://github.com/liabru/matter-js/issues/54)
* added testDemo to grunt test ([08c5648](https://github.com/liabru/matter-js/commit/08c5648))
* added time scaling to Sleeping ([0ae2d02](https://github.com/liabru/matter-js/commit/0ae2d02))
* added Vector.create ([b327a40](https://github.com/liabru/matter-js/commit/b327a40))
* Allow for negative force to bring a body out of sleeping state. ([d585e80](https://github.com/liabru/matter-js/commit/d585e80))
* appease jshint ([89140ae](https://github.com/liabru/matter-js/commit/89140ae))
* appease jshint ([18a2627](https://github.com/liabru/matter-js/commit/18a2627))
* change browser tests to use JSON.stringify ([75af920](https://github.com/liabru/matter-js/commit/75af920))
* change gravity scale to variable rather than a constant ([a38b227](https://github.com/liabru/matter-js/commit/a38b227))
* change main to edge build ([9d0e82b](https://github.com/liabru/matter-js/commit/9d0e82b))
* change travis to only lint rather than full test (until tests are finished and documented) ([ce478cb](https://github.com/liabru/matter-js/commit/ce478cb))
* change world.bounds to Infinity, remove world bounds check from Engine, closes #67 ([8b5192d](https://github.com/liabru/matter-js/commit/8b5192d)), closes [#67](https://github.com/liabru/matter-js/issues/67)
* changed Body._initProperties to use Body.setVertices ([2d04389](https://github.com/liabru/matter-js/commit/2d04389))
* changed bower main to build/matter.js ([7412335](https://github.com/liabru/matter-js/commit/7412335))
* changed certain Matter.Composite methods to private in docs ([8aa148d](https://github.com/liabru/matter-js/commit/8aa148d))
* changed Common.log to use console.warn ([c220f41](https://github.com/liabru/matter-js/commit/c220f41))
* changed default minimum area in Bodies.fromVertices ([998ab33](https://github.com/liabru/matter-js/commit/998ab33))
* changed demo to use Matter.Runner and Matter.Render events ([a1d4748](https://github.com/liabru/matter-js/commit/a1d4748))
* changed friction impulse limiting approach ([de4784c](https://github.com/liabru/matter-js/commit/de4784c))
* changed Grid.create to accept an options object ([eedd1f2](https://github.com/liabru/matter-js/commit/eedd1f2))
* changed jquery reference (matter-tools) to local copy ([0849773](https://github.com/liabru/matter-js/commit/0849773))
* changed Math.random to Common.random and use a seeded RNG ([0a46cb2](https://github.com/liabru/matter-js/commit/0a46cb2))
* changed Mouse.create to return as a plain object ([eaa9767](https://github.com/liabru/matter-js/commit/eaa9767))
* changed Render.bodyIds to show all parts ([3ed8034](https://github.com/liabru/matter-js/commit/3ed8034))
* changed Sleeping constants to be public (module level) ([7eadea9](https://github.com/liabru/matter-js/commit/7eadea9))
* changed vertex number render fillstyle ([bc88406](https://github.com/liabru/matter-js/commit/bc88406))
* changed Vertices.create and Vertices.fromPath to create and return a new array rather than apply in- ([e3e462e](https://github.com/liabru/matter-js/commit/e3e462e))
* cleanup ([5888ffc](https://github.com/liabru/matter-js/commit/5888ffc))
* cleanup Svg.pathToPoints ([8bf3278](https://github.com/liabru/matter-js/commit/8bf3278))
* cleanup Svg.pathToVertices ([7db3d28](https://github.com/liabru/matter-js/commit/7db3d28))
* demo tweaks ([d55c700](https://github.com/liabru/matter-js/commit/d55c700))
* demo tweaks ([22445c7](https://github.com/liabru/matter-js/commit/22445c7))
* disabled angle indicators on some demos ([74bc8ae](https://github.com/liabru/matter-js/commit/74bc8ae))
* don't calculate gravity force if there is no actual gravity ([e54802c](https://github.com/liabru/matter-js/commit/e54802c))
* dont draw offscreen constraints. Set visible flag on offscreen sprites ([e263ecb](https://github.com/liabru/matter-js/commit/e263ecb))
* Ensure passed canvas abides by render options ([0b51dd6](https://github.com/liabru/matter-js/commit/0b51dd6))
* expose demo instance externally ([a9122ed](https://github.com/liabru/matter-js/commit/a9122ed))
* fix angle indicators for compound bodies ([8031090](https://github.com/liabru/matter-js/commit/8031090))
* fix bug in Composites.stack when skipping bodies ([b34669e](https://github.com/liabru/matter-js/commit/b34669e))
* fix bug when using timing.isFixed, closes #44 ([0933620](https://github.com/liabru/matter-js/commit/0933620)), closes [#44](https://github.com/liabru/matter-js/issues/44)
* fix concat dependency ([84a22ba](https://github.com/liabru/matter-js/commit/84a22ba))
* fix demo for tests ([5e6b22b](https://github.com/liabru/matter-js/commit/5e6b22b))
* fix Demo.reset to fully reset ids ([500d566](https://github.com/liabru/matter-js/commit/500d566))
* fix Demo.stress stability ([d0fdd29](https://github.com/liabru/matter-js/commit/d0fdd29))
* Fix for travis ([05f1c46](https://github.com/liabru/matter-js/commit/05f1c46))
* fix grunt for travis ([d405910](https://github.com/liabru/matter-js/commit/d405910))
* fix grunt for travis ([f55d806](https://github.com/liabru/matter-js/commit/f55d806))
* fix gulp issues ([4173e70](https://github.com/liabru/matter-js/commit/4173e70))
* fix gulp issues ([3bd556d](https://github.com/liabru/matter-js/commit/3bd556d))
* fix handling of engine.render ([c46e915](https://github.com/liabru/matter-js/commit/c46e915))
* fix issue in Render.inspector on Chrome ([86fcfcd](https://github.com/liabru/matter-js/commit/86fcfcd))
* fix issue of undefined body.parts in constructor ([9d3755a](https://github.com/liabru/matter-js/commit/9d3755a))
* fix issue when Bodies.trapezoid slope === 1, closes #138 ([449774c](https://github.com/liabru/matter-js/commit/449774c)), closes [#138](https://github.com/liabru/matter-js/issues/138)
* fix issue with mouse when changing renderers, closes #96 ([796faeb](https://github.com/liabru/matter-js/commit/796faeb)), closes [#96](https://github.com/liabru/matter-js/issues/96)
* fix issue with Render.debug when no timing passed, closes #171 and #176 ([087fab2](https://github.com/liabru/matter-js/commit/087fab2)), closes [#171](https://github.com/liabru/matter-js/issues/171) [#176](https://github.com/liabru/matter-js/issues/176)
* fix jshint ([b0f72ab](https://github.com/liabru/matter-js/commit/b0f72ab))
* fix lint issue ([9a599f1](https://github.com/liabru/matter-js/commit/9a599f1))
* fix Matter.Demo for node ([2de1161](https://github.com/liabru/matter-js/commit/2de1161))
* fix Matter.Demo for node ([06eea3e](https://github.com/liabru/matter-js/commit/06eea3e))
* fix Matter.Runner for node ([ad55b85](https://github.com/liabru/matter-js/commit/ad55b85))
* fix mobile demo, remove dev.html, fix debug info rendering ([9d5c27a](https://github.com/liabru/matter-js/commit/9d5c27a))
* fix orientation event bug in DemoMobile ([f770a7c](https://github.com/liabru/matter-js/commit/f770a7c))
* fix pair properties for compounds ([b8f3784](https://github.com/liabru/matter-js/commit/b8f3784))
* fix runner for tests, limit precision of refs ([352bfd6](https://github.com/liabru/matter-js/commit/352bfd6))
* fix standalone option ([de16529](https://github.com/liabru/matter-js/commit/de16529))
* fix support for nodejs ([b669ea0](https://github.com/liabru/matter-js/commit/b669ea0))
* fix tests ([eccf0a7](https://github.com/liabru/matter-js/commit/eccf0a7))
* fix travis ([3ce6c3a](https://github.com/liabru/matter-js/commit/3ce6c3a))
* fix travis issue ([131ed5e](https://github.com/liabru/matter-js/commit/131ed5e))
* fix undefined variables, added jshint checks, closes #102 ([536e55f](https://github.com/liabru/matter-js/commit/536e55f)), closes [#102](https://github.com/liabru/matter-js/issues/102)
* fixed Body.rotate ([c5212e1](https://github.com/liabru/matter-js/commit/c5212e1))
* fixed Body.setVertices ([73ded98](https://github.com/liabru/matter-js/commit/73ded98))
* fixed bug in constraints for compounds ([13fcb4b](https://github.com/liabru/matter-js/commit/13fcb4b))
* fixed bug in Demo.reset that was creating multiple MouseConstraint ([8204d97](https://github.com/liabru/matter-js/commit/8204d97))
* fixed build tasks ([69ff33f](https://github.com/liabru/matter-js/commit/69ff33f))
* fixed build tasks, closes #161 ([d1b8705](https://github.com/liabru/matter-js/commit/d1b8705)), closes [#161](https://github.com/liabru/matter-js/issues/161)
* fixed chaining for some Matter.Vertices methods ([8746185](https://github.com/liabru/matter-js/commit/8746185))
* fixed collision detection issue, closes #12 ([3e48825](https://github.com/liabru/matter-js/commit/3e48825)), closes [#12](https://github.com/liabru/matter-js/issues/12)
* fixed collision incident and reference body mapping ([757fffa](https://github.com/liabru/matter-js/commit/757fffa))
* fixed collision rendering ([bc9a051](https://github.com/liabru/matter-js/commit/bc9a051))
* fixed Common.now, closes #55 ([8555c0c](https://github.com/liabru/matter-js/commit/8555c0c)), closes [#55](https://github.com/liabru/matter-js/issues/55)
* fixed compound body stability, improved position resolver ([e01dd22](https://github.com/liabru/matter-js/commit/e01dd22))
* fixed critical inertia calculation issue, a potential breaking change, so Body._inertiaScale added t ([9a55b0c](https://github.com/liabru/matter-js/commit/9a55b0c))
* fixed Example.timescale ([19656cd](https://github.com/liabru/matter-js/commit/19656cd))
* fixed friction in Demo.manipulation ([95ae911](https://github.com/liabru/matter-js/commit/95ae911))
* fixed gulp shell task args ([c2b0f30](https://github.com/liabru/matter-js/commit/c2b0f30))
* fixed incorrect bounds issue when passing angle in Body.create ([810bd26](https://github.com/liabru/matter-js/commit/810bd26))
* fixed issue with Body.applyForce torque, closes #64 ([3f9364c](https://github.com/liabru/matter-js/commit/3f9364c)), closes [#64](https://github.com/liabru/matter-js/issues/64)
* fixed issue with docs ([3a16f90](https://github.com/liabru/matter-js/commit/3a16f90))
* fixed issue with MouseConstraint.create, closes #185 ([dff0e30](https://github.com/liabru/matter-js/commit/dff0e30)), closes [#185](https://github.com/liabru/matter-js/issues/185)
* fixed issues with friction stability ([1db98a3](https://github.com/liabru/matter-js/commit/1db98a3))
* Fixed missed variable declaration. ([a940d96](https://github.com/liabru/matter-js/commit/a940d96))
* fixed options pass through on Bodies.fromVertices ([eb29367](https://github.com/liabru/matter-js/commit/eb29367))
* fixed Query.ray, Number.MIN_VALUE seems to cause SAT.collides to fail ([ccbb98b](https://github.com/liabru/matter-js/commit/ccbb98b))
* fixed RenderPixi for compound bodies ([6679b9c](https://github.com/liabru/matter-js/commit/6679b9c))
* fixed SAT overlap calculation for containment case ([685f2bd](https://github.com/liabru/matter-js/commit/685f2bd))
* fixed scaling on RenderPixi view bounds ([c1964e2](https://github.com/liabru/matter-js/commit/c1964e2))
* fixed support finding logic ([bc7dfc7](https://github.com/liabru/matter-js/commit/bc7dfc7))
* fixed Vertices.fromPath when parsing scientific notation ([dae684d](https://github.com/liabru/matter-js/commit/dae684d))
* fixes for compound bodies ([87f9065](https://github.com/liabru/matter-js/commit/87f9065))
* formatting merge ([d4cbdbb](https://github.com/liabru/matter-js/commit/d4cbdbb))
* further work on compound implementation ([d2f79b4](https://github.com/liabru/matter-js/commit/d2f79b4))
* hide axis indicator on compound bodies ([6a26696](https://github.com/liabru/matter-js/commit/6a26696))
* ignoring .idea ([066a416](https://github.com/liabru/matter-js/commit/066a416))
* implemented automated browser tests ([a88b3ba](https://github.com/liabru/matter-js/commit/a88b3ba))
* implemented compound bodies, added Body.setParts ([f554d6c](https://github.com/liabru/matter-js/commit/f554d6c))
* implemented static compound bodies ([90adf14](https://github.com/liabru/matter-js/commit/90adf14))
* implemented temporary vector pool ([7a477f2](https://github.com/liabru/matter-js/commit/7a477f2))
* improve Composite.car ([5ff2182](https://github.com/liabru/matter-js/commit/5ff2182))
* improved collision detection for compounds ([84d9f59](https://github.com/liabru/matter-js/commit/84d9f59))
* improved Demo.manipulation ([e186ccd](https://github.com/liabru/matter-js/commit/e186ccd))
* improved docs ([2317f02](https://github.com/liabru/matter-js/commit/2317f02))
* improved docs ([2e6afd4](https://github.com/liabru/matter-js/commit/2e6afd4))
* improved examples ([6e1f8e9](https://github.com/liabru/matter-js/commit/6e1f8e9))
* improved friction, added body.frictionStatic ([937c7bf](https://github.com/liabru/matter-js/commit/937c7bf))
* improved traction for Composites.car ([95eddb0](https://github.com/liabru/matter-js/commit/95eddb0))
* increased tollerance on internal edge finding ([40905e8](https://github.com/liabru/matter-js/commit/40905e8))
* initial work on browser tests ([6a88256](https://github.com/liabru/matter-js/commit/6a88256))
* initial work on compound bodies ([243fce4](https://github.com/liabru/matter-js/commit/243fce4))
* Make background:'transparent' work like canvas renderer ([f9123f9](https://github.com/liabru/matter-js/commit/f9123f9))
* Merge branch 'browser-tests' ([a6b82c1](https://github.com/liabru/matter-js/commit/a6b82c1))
* Merge branch 'collision-filters' of https://github.com/GustavCarlson/matter-js into GustavCarlson-co ([3a32bda](https://github.com/liabru/matter-js/commit/3a32bda))
* Merge branch 'GustavCarlson-collision-filters' ([a58fe2a](https://github.com/liabru/matter-js/commit/a58fe2a))
* Merge branch 'master' into runner-improve ([a48d219](https://github.com/liabru/matter-js/commit/a48d219))
* Merge branch 'master' into topic/addBounds ([a461fc7](https://github.com/liabru/matter-js/commit/a461fc7))
* Merge branch 'master' of github.com:liabru/matter-js ([4067108](https://github.com/liabru/matter-js/commit/4067108))
* Merge branch 'master' of https://github.com/rfoligno/matter-js into rfoligno-master ([41b4b7f](https://github.com/liabru/matter-js/commit/41b4b7f))
* Merge branch 'master' of https://github.com/schahriar/matter-js into schahriar-master ([2510cdf](https://github.com/liabru/matter-js/commit/2510cdf))
* Merge branch 'no-gravity-optim' of https://github.com/BlackDice/matter-js into BlackDice-no-gravity- ([1b8574a](https://github.com/liabru/matter-js/commit/1b8574a))
* Merge branch 'node-tests' into browserify ([6e0e7e4](https://github.com/liabru/matter-js/commit/6e0e7e4))
* Merge branch 'pr/60' ([42dc72d](https://github.com/liabru/matter-js/commit/42dc72d))
* Merge branch 'pr/95' ([eed9167](https://github.com/liabru/matter-js/commit/eed9167))
* Merge branch 'runner-improve' into browserify ([9e3438f](https://github.com/liabru/matter-js/commit/9e3438f))
* Merge pull request #30 from mrspeaker/master ([e95e328](https://github.com/liabru/matter-js/commit/e95e328))
* Merge pull request #31 from mrspeaker/topic/addBounds ([6652bb4](https://github.com/liabru/matter-js/commit/6652bb4))
* Merge pull request #51 from tumult/pair_refreshes_from_body_values ([7c1efb6](https://github.com/liabru/matter-js/commit/7c1efb6))
* Merge remote-tracking branch 'origin/pr/33' ([c6a9414](https://github.com/liabru/matter-js/commit/c6a9414))
* merge tumult:old_ie_fixes + tweaks ([6e1ab9a](https://github.com/liabru/matter-js/commit/6e1ab9a))
* migrated from grunt to gulp, jshint to eslint ([19bb655](https://github.com/liabru/matter-js/commit/19bb655))
* Missing argument whose default is 1. ([61855ab](https://github.com/liabru/matter-js/commit/61855ab))
* More fine-grained collision filtering in the style of Box2D ([dd4fc65](https://github.com/liabru/matter-js/commit/dd4fc65))
* move /tests to /test ([ad403ae](https://github.com/liabru/matter-js/commit/ad403ae))
* move Demo.* to Example.* ([b722012](https://github.com/liabru/matter-js/commit/b722012))
* move license in build ([9ba8a2a](https://github.com/liabru/matter-js/commit/9ba8a2a))
* move require statements below module export ([99c3bb3](https://github.com/liabru/matter-js/commit/99c3bb3))
* moved collision events into Engine.update, changed collisionStart to trigger before collisions resol ([69b1d05](https://github.com/liabru/matter-js/commit/69b1d05))
* moved Engine.run to Matter.Runner ([6911395](https://github.com/liabru/matter-js/commit/6911395))
* moved engine.timing properties, tick events and Engine.render into Matter.Runner module ([dcdc43d](https://github.com/liabru/matter-js/commit/dcdc43d))
* pass width and height options to Pixi webGL renderer ([a9278fc](https://github.com/liabru/matter-js/commit/a9278fc))
* publish to npm ([a12fbcb](https://github.com/liabru/matter-js/commit/a12fbcb))
* refactor Bodies.fromVertices ([4a2c6e7](https://github.com/liabru/matter-js/commit/4a2c6e7))
* refactor Demo.create ([c0b24da](https://github.com/liabru/matter-js/commit/c0b24da))
* refactor Demo.init ([fb76605](https://github.com/liabru/matter-js/commit/fb76605))
* remove constraint torque clamp ([6f89250](https://github.com/liabru/matter-js/commit/6f89250))
* removed Body.resetForcesAll, removed Body.applyGravityAll, removed Body.updateAll ([9aa0945](https://github.com/liabru/matter-js/commit/9aa0945))
* removed collision.supportCorrected instead using bodyB.position, added render.options.showSeparation ([2b6a8d3](https://github.com/liabru/matter-js/commit/2b6a8d3))
* removed complexity check in Bodies.fromVertices, enforce clockwise sort ([2d1ef0d](https://github.com/liabru/matter-js/commit/2d1ef0d))
* removed Detector.bruteForce ([e04de5f](https://github.com/liabru/matter-js/commit/e04de5f))
* removed engine.broadphase.current, removed engine.broadphase.instance, changed engine.broadphase to  ([6dd0c05](https://github.com/liabru/matter-js/commit/6dd0c05))
* removed engine.input, removed Engine mouse events, added MouseConstraint mouse events ([fb5d899](https://github.com/liabru/matter-js/commit/fb5d899))
* removed line width change from Body.setStatic ([04955bb](https://github.com/liabru/matter-js/commit/04955bb))
* removed Matter.Metrics from release builds (now dev only) ([968bba2](https://github.com/liabru/matter-js/commit/968bba2))
* removed old build ([a068bec](https://github.com/liabru/matter-js/commit/a068bec))
* removed redundant property ([14392b4](https://github.com/liabru/matter-js/commit/14392b4))
* removed Render.clear (redundant) ([0a15d7d](https://github.com/liabru/matter-js/commit/0a15d7d))
* removed Render.setBackground (now use render.options) ([01bc813](https://github.com/liabru/matter-js/commit/01bc813))
* removed unused vars from examples ([0bff037](https://github.com/liabru/matter-js/commit/0bff037))
* removed version number from edge build name ([e6b998e](https://github.com/liabru/matter-js/commit/e6b998e))
* render normals pointing out of static bodies ([d082b3a](https://github.com/liabru/matter-js/commit/d082b3a))
* skip presolve when impulse 0 ([296059c](https://github.com/liabru/matter-js/commit/296059c))
* skip unnecessary loops in Composites.mesh, closes #85 ([0a73a64](https://github.com/liabru/matter-js/commit/0a73a64)), closes [#85](https://github.com/liabru/matter-js/issues/85)
* Some fixes in pixi.js v3 update ([96735dd](https://github.com/liabru/matter-js/commit/96735dd))
* Spellchecking ([940976a](https://github.com/liabru/matter-js/commit/940976a))
* Spellchecking ([c2e0c23](https://github.com/liabru/matter-js/commit/c2e0c23))
* Spellchecking ([cd5d401](https://github.com/liabru/matter-js/commit/cd5d401))
* Spellchecking ([611a429](https://github.com/liabru/matter-js/commit/611a429))
* Spellchecking ([723ddcf](https://github.com/liabru/matter-js/commit/723ddcf))
* Spellchecking ([65d5d93](https://github.com/liabru/matter-js/commit/65d5d93))
* Spellchecking ([3127654](https://github.com/liabru/matter-js/commit/3127654))
* tweak jshint ([71df1b9](https://github.com/liabru/matter-js/commit/71df1b9))
* tweaks to collision filtering ([5060c76](https://github.com/liabru/matter-js/commit/5060c76))
* tweaks to Matter.Runner ([ce474da](https://github.com/liabru/matter-js/commit/ce474da))
* Update JSDoc ([25ab2a3](https://github.com/liabru/matter-js/commit/25ab2a3))
* Update JSDoc ([18e0642](https://github.com/liabru/matter-js/commit/18e0642))
* Update JSDoc ([71ef6c2](https://github.com/liabru/matter-js/commit/71ef6c2))
* Update JSDoc ([10a46b7](https://github.com/liabru/matter-js/commit/10a46b7))
* Update JSDoc ([5b87f47](https://github.com/liabru/matter-js/commit/5b87f47))
* Update JSDoc ([d17eb6c](https://github.com/liabru/matter-js/commit/d17eb6c))
* Update JSDoc ([aa3eabc](https://github.com/liabru/matter-js/commit/aa3eabc))
* update node version for travis ([e698b6b](https://github.com/liabru/matter-js/commit/e698b6b))
* updated browser test refs ([1810f93](https://github.com/liabru/matter-js/commit/1810f93))
* updated browser test refs ([ae32d63](https://github.com/liabru/matter-js/commit/ae32d63))
* updated browser test refs ([31fb748](https://github.com/liabru/matter-js/commit/31fb748))
* updated contributing notes ([8b89e87](https://github.com/liabru/matter-js/commit/8b89e87))
* updated docs for collisionFilter ([9f10f88](https://github.com/liabru/matter-js/commit/9f10f88))
* updated edge build ([2fa1570](https://github.com/liabru/matter-js/commit/2fa1570))
* updated edge build ([02ab198](https://github.com/liabru/matter-js/commit/02ab198))
* updated edge build ([37a86cd](https://github.com/liabru/matter-js/commit/37a86cd))
* updated edge build ([cd00353](https://github.com/liabru/matter-js/commit/cd00353))
* updated edge build ([37ccc84](https://github.com/liabru/matter-js/commit/37ccc84))
* updated edge build ([bf3f986](https://github.com/liabru/matter-js/commit/bf3f986))
* updated edge build ([16733ad](https://github.com/liabru/matter-js/commit/16733ad))
* updated edge build ([2f2d416](https://github.com/liabru/matter-js/commit/2f2d416))
* updated edge build ([5770013](https://github.com/liabru/matter-js/commit/5770013))
* updated edge build ([43fd2e3](https://github.com/liabru/matter-js/commit/43fd2e3))
* updated edge build ([fbb7c1a](https://github.com/liabru/matter-js/commit/fbb7c1a))
* updated edge build ([d6cbd07](https://github.com/liabru/matter-js/commit/d6cbd07))
* updated edge build ([9561d5d](https://github.com/liabru/matter-js/commit/9561d5d))
* updated edge build ([a80fbc1](https://github.com/liabru/matter-js/commit/a80fbc1))
* updated edge build ([5b2b060](https://github.com/liabru/matter-js/commit/5b2b060))
* updated edge build ([d22b1b4](https://github.com/liabru/matter-js/commit/d22b1b4))
* updated edge build ([2ab20b0](https://github.com/liabru/matter-js/commit/2ab20b0))
* updated edge build ([f2635ab](https://github.com/liabru/matter-js/commit/f2635ab))
* updated matter-tools ([c969767](https://github.com/liabru/matter-js/commit/c969767))
* updated matter-tools ([4ecad0f](https://github.com/liabru/matter-js/commit/4ecad0f))
* updated node test refs ([b1e6a45](https://github.com/liabru/matter-js/commit/b1e6a45))
* Updated pixi.js to v3 ([419d2ad](https://github.com/liabru/matter-js/commit/419d2ad))
* updated readme ([137580c](https://github.com/liabru/matter-js/commit/137580c))
* updated readme ([f4f3bf7](https://github.com/liabru/matter-js/commit/f4f3bf7))
* updated readme ([d2dcc77](https://github.com/liabru/matter-js/commit/d2dcc77))
* updated readme ([2806fd3](https://github.com/liabru/matter-js/commit/2806fd3))
* updated readme ([3e5abab](https://github.com/liabru/matter-js/commit/3e5abab))
* updated readme ([8f2f8ee](https://github.com/liabru/matter-js/commit/8f2f8ee))
* updated readme ([6cd00b1](https://github.com/liabru/matter-js/commit/6cd00b1))
* updated test refs ([b79ece2](https://github.com/liabru/matter-js/commit/b79ece2))
* updated test refs ([1a55259](https://github.com/liabru/matter-js/commit/1a55259))
* updated test refs ([110aea8](https://github.com/liabru/matter-js/commit/110aea8))
* updated test refs ([729e2bf](https://github.com/liabru/matter-js/commit/729e2bf))
* upgraded pixi.js to v3.0.6 ([d03145e](https://github.com/liabru/matter-js/commit/d03145e))
* use actual canvas size for default render bounds ([c3129b8](https://github.com/liabru/matter-js/commit/c3129b8))
* use browserify ([00251e5](https://github.com/liabru/matter-js/commit/00251e5))
* use build folder for demo ([fa47d5c](https://github.com/liabru/matter-js/commit/fa47d5c))
* use different port for test server, fix test precision limiter ([c1f71b9](https://github.com/liabru/matter-js/commit/c1f71b9))
* Use own Common.indexOf method for IE 6-8 compatibility ([b91af36](https://github.com/liabru/matter-js/commit/b91af36))
* When updating pairs use current values from bodies as they may have changed ([f0e7491](https://github.com/liabru/matter-js/commit/f0e7491))



# Matter.js Changelog

[brm.io/matter-js](http://brm.io/matter-js)

----------

## 0.8.0-alpha - 2014-05-05

#### Release Highlights

- added [Views](http://brm.io/matter-js-demo/#views) demo
- added [Time Scaling](http://brm.io/matter-js-demo/#timescale) demo
- added [Rounded Corners (Chamfering)](http://brm.io/matter-js-demo#rounded) demo
- added [Raycasting](http://brm.io/matter-js-demo/#raycasting) demo
- added Query module, including raycasting
- added 3 useful new Composite methods
- added support for mouse wheel, mouse scaling and offsets
- added Body.scale for scaling bodies on the fly
- added Body.timeScale for slowing down bodies per-body
- added Body.setStatic for correctly setting static
- added Vertices.chamfer for rounding corners of any set of vertices
- added integration of chamfer to body factories
- added engine.timing.isFixed option to disable dynamic timing
- added render.bounds for translating and scaling views
- easier use of Engine.update and Engine.render for those using custom game loops
- fixed issues with time scaling
- fixed error in calculation of centre of mass
- removed Matter.Gui in preparation for the [MatterTools](https://github.com/liabru/matter-tools) project launch

#### Added

- added Demo.views
- added Demo.timescale
- added Demo.rounded
- added Demo.raycasting
- added demo support for hash + '-inspect' to start the [MatterTools](https://github.com/liabru/matter-tools) inspector
- added Composite.rebase
- added Composite.move
- added Composite.get
- added Matter.Query
- added Query.ray
- added Query.region
- added Bounds.translate
- added Bounds.shift
- added Mouse.setScale
- added Mouse.setPosition
- added mouse.absolute
- added mouse.wheelDelta
- added mouse.offset
- added Body.setStatic
- added Body.scale
- added body.timeScale
- added Vector.angle
- added Vertices.chamfer for rounding corners
- added Engine.render
- added engine.timing.isFixed option
- added render.bounds for translating and scaling views
- added Common.nextId
- added body.label
- added constraint.label
- added composite.label

#### Changed

- changed engine.timing.timestamp to be simulation based rather than wall-clock based
- changed correction to now be optional in Engine.update (defaults to 1)
- changed Events.on to return callback
- changed Events.off to accept callbacks for removal
- changed vertices in Bounds.create to optional
- changed engine.timeScale to engine.timing.timeScale
- moved Matter.Inspector and Matter.Gui to the [MatterTools](https://github.com/liabru/matter-tools) project
- moved event documentation to end of file for clarity
- moved respective engine event triggers into Engine.update and Engine.render

#### Removed

- removed body.render.path (redundant)
- removed Body.nextId
- removed Constraint.nextId
- removed Composite.nextId
- removed Body.updateProperties (now a private method)

#### Fixed

- fixed issues with timing.timeScale
- fixed constraints now account for timeScale
- fixed Vertices.centre calculation to get correct centre of mass

## 0.7.0-alpha - 2014-04-01

#### Release Highlights

- added six new demos
	- all demos are now mobile friendly
- added new event system
	- engine, mouse and collision events
- added sprite texture rendering support
- added WebGL renderer (pixi.js)
- improved `Composite` (and `World`)
	- batch adding
	- type agnostic adding
	- body removal
- major performance increases all round
	- collision detection caching
	- batched rendering
	- improved pair management
	- memory leaks fixed
- stability improvements
	- bodies rest better due to collision caching
	- bodies sleep better
	- constraints are much less volatile
- fixes for a number of issues (see fixes)

#### Added

- added demos 
	- sprites
	- events
	- catapult
	- cloth
	- soft body
	- bridge
- added collision caching and reuse for improved performance
	- added metrics for collision reuse
- added `Events` module ([Issue #8](https://github.com/liabru/matter-js/issues/8))
	- engine events
	- mouse events
	- collision events
- added composite functions, including
	- batch adding (`Composite.add` / `World.add`)
	- type agnostic adding (`Composite.add` / `World.add`)
	- body removal (`Composite.remove` / `World.remove`)
- added factory functions
	- constraint meshing (`Composites.mesh`)
	- soft body factory (`Composites.softBody`)
- added `RenderPixi`, a pixi.js WebGL renderer
	- added `Gui` option to switch renderer
	- added `Mouse.setElement`
- added `render.visible` flag to `Body` and `Constraint` ([Issue #10](https://github.com/liabru/matter-js/issues/10))
- added `id` to `Constraint` and `Composite`
- added `type` names to `Body`, `Constraint`, `Composite`
- added `Common` functions
	- `Common.colorToNumber`
	- `Common.log`
	- `Common.clone`
- added jsdoc annotations
- added travis-ci integration
- added yuidoc build tasks
- added multiple build modes to `Gruntfile` (dev, release, edge)
- added repository to `package.json`, so Browserify may be used
- added `CHANGELOG.md`

#### Changed

- renamed module `Manager` to `Pairs`
- changed `Composite` to be tree-based
- changed timestep to be smoothed over 1s for stability
- changed default `constraintIterations` to 2 for stability
- changed demo to use the new composite functions
- changed right click to now remove bodies in the demos
- changed `Common.now` to use high-resolution timing
- changed `MouseConstraint` to reference a single constraint rather than a list
- changed `Constraint` to now use a `render` property
- changed `Metrics` to only track FPS by default, use the `extended` flag for full metrics

#### Removed

- removed the default in `MouseConstraint`, you must now instantiate one manually

#### Fixed

- fixed a memory leak in `Grid`
- fixed a memory leak in `Manager`
- fixed debug text now uses `Metrics` correctly
- fixed issues regarding passing custom `Render` modules ([Issue #7](https://github.com/liabru/matter-js/issues/7))
- fixed issue in `Common.extend` with `null` properties
- fixed issue with sleeping, now ignores inactive pairs
- fixed issues with `Body.applyForce` ([Issue #7](https://github.com/liabru/matter-js/issues/7))

## 0.5.0-alpha - 2014-02-28

- initial release