System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _crd;

  /**
   * 快速绑定节点、组件的装饰器的工厂
   * @param nodeName 节点名
   * @param bindType 绑定的类型
   * @param isAutoAddComp 对应节点上不存在指定类型的组件时，是否自动添加，默认为false。当 buildType 为 Node 时，该值无效。
   * @returns 
   */
  function quickBind(nodeName, bindType, isAutoAddComp) {
    if (isAutoAddComp === void 0) {
      isAutoAddComp = false;
    }

    /**
     * 快速绑定节点、组件的装饰器。
     * @target 装饰的目标对象，对于静态成员来说是类的构造函数，对于实例成员来说是类的原型对象。
     * @propertyName 装饰的属性名
     */
    return function (target, propertyName) {
      if (!target.hasOwnProperty("_$bindMap$_")) {
        target._$bindMap$_ = new Map();
      }

      var bindInfo = {
        nodeName: nodeName,
        isAutoAddComp: isAutoAddComp,
        bindType: bindType
      };

      target._$bindMap$_.set(propertyName, bindInfo);
    };
  }

  _export("quickBind", quickBind);

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "f8d02fuq65C5KhkjCoJIv+f", "Decorator", undefined);

      /**
       * 装饰器、装饰器工厂
       */

      /** 快速绑定的组件类型 */
      __checkObsolete__(['Animation', 'Component', 'Node']);
      /** 快速绑定的节点、组件的信息 */

      /**
       * 使用快速绑定装饰器的目标数据结构
       * _$bindMap$_: Map<类的属性名, IBindInfo>
       */


      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=4e6c0078856d6e4628f8bd2957b892dd654dec03.js.map