System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, Node, _crd;

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      Node = _cc.Node;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "dbe5fNCe8hFzpa4lcKHIbwd", "NodeExt", undefined);
      /**
       * Node 类的扩展
       */


      __checkObsolete__(['Component', 'Node', '__private']);

      /**
       * 通过名称查找子节点(包含自己本身)
       */
      Node.prototype.findChildByName = function (name) {
        if (this.name === name) {
          // 自己就是这个节点 直接返回自己
          return this;
        }

        var nodeArr = this.children.slice();
        var firstNode = nodeArr.shift();

        while (firstNode) {
          if (firstNode.name === name) {
            // 找到了
            return firstNode;
          } // 把该节点的子节点都放入遍历池


          nodeArr.push(...firstNode.children); // 将该节点从遍历数组中移除

          firstNode = nodeArr.shift();
        }

        return null;
      };
      /**
       * 通过名称数组查找子节点，并返回子节点字典
       */


      Node.prototype.findChildMapByNameArr = function (nameArr) {
        nameArr = nameArr.slice();
        var nodeMap = new Map();
        var childArr = this.children.slice();
        var firstNode = childArr.shift();

        var _loop = function _loop() {
          var childName = firstNode.name;
          var findIdx = nameArr.findIndex(name => name === childName);

          if (findIdx !== -1) {
            // 找到了
            nodeMap.set(childName, firstNode);
            nameArr.splice(findIdx, 1);

            if (nameArr.length === 0) {
              // 所有节点均已找到
              return {
                v: nodeMap
              };
            }
          } // 把该节点的子节点都放入遍历池


          childArr.push(...firstNode.children); // 将该节点从遍历数组中移除

          firstNode = childArr.shift();
        },
            _ret;

        while (firstNode) {
          _ret = _loop();
          if (_ret) return _ret.v;
        } // 部分节点未找到


        return nodeMap;
      };
      /**
       * 通过名称查找子节点上的组件
       */


      Node.prototype.findCompByName = function (name, compType) {
        var nodeArr = this.children.slice();
        var firstNode = nodeArr.shift();

        while (firstNode) {
          if (firstNode.name === name) {
            // 找到了
            var comp = firstNode.getComponent(compType);

            if (comp) {
              return comp;
            }
          } // 把该节点的子节点都放入遍历池


          nodeArr.push(...firstNode.children); // 将该节点从遍历数组中移除

          firstNode = nodeArr.shift();
        }

        return null;
      };
      /**
       * 批量查找子节点上的组件
       */


      Node.prototype.findCompMap = function (compTypeMap) {
        var compMap = new Map();
        var nodeArr = this.children.slice();
        var firstNode = nodeArr.shift();

        while (firstNode) {
          var _childName = firstNode.name;

          var _compType = compTypeMap.get(_childName);

          if (_compType) {
            // 找到同名节点
            var comp = firstNode.getComponent(_compType);

            if (comp) {
              // 找到了组件
              compMap.set(_childName, comp);
              compTypeMap.delete(_childName);

              if (compTypeMap.size === 0) {
                // 所有组件均已找到
                return compMap;
              }
            }
          } // 把该节点的子节点都放入遍历池


          nodeArr.push(...firstNode.children); // 将该节点从遍历数组中移除

          firstNode = nodeArr.shift();
        } // 部分组件未找到


        var noFoundTipStr = '未找到的节点：';
        compTypeMap.forEach((compType, name) => {
          noFoundTipStr += "\n\t[" + name + ", " + compType.name + "],";
        });
        return compMap;
      };
      /**
       * 批量查找子节点上的组件
       */


      Node.prototype.findNodeAndCompMap = function (nodeAndCompTypeMap) {
        var compMap = new Map();
        var nodeArr = this.children.slice();
        var firstNode = nodeArr.shift();

        while (firstNode) {
          var _childName2 = firstNode.name;

          var _compType2 = nodeAndCompTypeMap.get(_childName2);

          if (_compType2) {
            // 找到同名节点
            if (_compType2 === Node) {
              compMap.set(_childName2, firstNode);
              nodeAndCompTypeMap.delete(_childName2);

              if (nodeAndCompTypeMap.size === 0) {
                // 所有组件均已找到
                return compMap;
              }
            } else {
              var comp = firstNode.getComponent(_compType2);

              if (comp) {
                // 找到了组件
                compMap.set(_childName2, comp);
                nodeAndCompTypeMap.delete(_childName2);

                if (nodeAndCompTypeMap.size === 0) {
                  // 所有组件均已找到
                  return compMap;
                }
              }
            }
          } // 把该节点的子节点都放入遍历池


          nodeArr.push(...firstNode.children); // 将该节点从遍历数组中移除

          firstNode = nodeArr.shift();
        } // 部分组件未找到


        var noFoundTipStr = '未找到的节点：';
        nodeAndCompTypeMap.forEach((compType, name) => {
          noFoundTipStr += "\n\t[" + name + ", " + compType.name + "],";
        });
        return compMap;
      };
      /**
       * 获取Node下挂载的 Component 没找到就创建
       */


      Node.prototype.getOrAddComponent = function (typeOrClassName) {
        var _this$getComponent;

        // @ts-ignore
        return (_this$getComponent = this.getComponent(typeOrClassName)) != null ? _this$getComponent : this.addComponent(typeOrClassName);
      };

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=c5afa6855f5b4a06fecf47f16269edbe7ad8982b.js.map