"use strict";
cc._RF.push(module, '3dee8Dlcj9B8al7ZxP+q9gL', 'CalendarView');
// scripts/CalendarView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarView = void 0;
var ItemCalendarDay_1 = require("./ItemCalendarDay");
/*
 * @Author       : -------
 * @Date         : 2025-05-15 20:58:37
 * @LastEditors  : -------
 * @LastEditTime : 2025-05-16 17:00:28
 * @Description  : file content
 * 如果需要扩展为滑动，可以使用虚拟PageView，以calendar_table_page为子页进行扩展
 * 由于虚拟PageView很多实现都不相同，各个项目也可能不同，我也没有非常好用PageView
 * 所以需要使用可以选择自己合适的实现
 */
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var CalendarView = /** @class */ (function (_super) {
    __extends(CalendarView, _super);
    function CalendarView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.nextPgaeNd = null;
        _this.prevPgaeNd = null;
        _this.lblCurDate = null;
        _this.lblSelectDate = null;
        _this._currentYear = 0;
        _this._currentMonth = 0;
        _this._curSelectCell = null;
        return _this;
    }
    CalendarView.prototype.onLoad = function () {
        this._initData();
        this._initUI();
    };
    CalendarView.prototype.onEnable = function () {
        this._addEvent();
    };
    CalendarView.prototype.onDisable = function () {
        this._removeEvent();
    };
    CalendarView.prototype._initData = function () {
        var currentDate = new Date();
        this._currentYear = currentDate.getFullYear();
        this._currentMonth = currentDate.getMonth() + 1;
    };
    CalendarView.prototype._initUI = function () {
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._addEvent = function () {
        var _a, _b;
        cc.director.getScene().on("event_select_cell_day", this._onSelectCellDay, this);
        (_a = this.prevPgaeNd) === null || _a === void 0 ? void 0 : _a.on(cc.Node.EventType.TOUCH_END, this._onPrevPage, this);
        (_b = this.nextPgaeNd) === null || _b === void 0 ? void 0 : _b.on(cc.Node.EventType.TOUCH_END, this._onNextPage, this);
    };
    CalendarView.prototype._removeEvent = function () {
        var _a, _b;
        cc.director.getScene().off("event_select_cell_day", this._onSelectCellDay, this);
        (_a = this.prevPgaeNd) === null || _a === void 0 ? void 0 : _a.off(cc.Node.EventType.TOUCH_END, this._onPrevPage, this);
        (_b = this.nextPgaeNd) === null || _b === void 0 ? void 0 : _b.off(cc.Node.EventType.TOUCH_END, this._onNextPage, this);
    };
    CalendarView.prototype._onSelectCellDay = function (date) {
        if (this._curSelectCell && this._isSameDate(date, this._curSelectCell)) {
            return;
        }
        this.lblSelectDate && (this.lblSelectDate.string = date.year + "-" + date.month + "-" + date.day);
        this._curSelectCell = date;
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._onPrevPage = function () {
        if (this._currentMonth === 1) {
            this._currentYear -= 1;
            this._currentMonth = 12;
        }
        else {
            this._currentMonth -= 1;
        }
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._onNextPage = function () {
        if (this._currentMonth === 12) {
            this._currentYear += 1;
            this._currentMonth = 1;
        }
        else {
            this._currentMonth += 1;
        }
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._isSameDate = function (a, b) {
        return a.year === b.year && a.month === b.month && a.day === b.day;
    };
    CalendarView.prototype._refreshCurrentMonthView = function () {
        var monthGrid = this._getMonthGrid(this._currentYear, this._currentMonth);
        var weekdayRows = this._rearrangeByWeekday(monthGrid);
        var calenderTable = this.node.getChildByName("calendar_table_page");
        for (var i = 0; i < weekdayRows.length; ++i) {
            var weekDaysNd = calenderTable.children[i];
            var weekDays = weekdayRows[i];
            for (var j = 0; j < weekDays.length; ++j) {
                var dayData = weekDays[j];
                var dayItem = weekDaysNd.children[j].getComponent(ItemCalendarDay_1.ItemCalendarDay);
                dayItem.date = dayData;
                dayItem.isSelected = this._curSelectCell && this._isSameDate(dayData, this._curSelectCell);
                dayItem.updateView();
            }
        }
        this.lblCurDate && (this.lblCurDate.string = this._currentYear + "-" + this._currentMonth);
    };
    /**
     * 获取当前月份的数据，其中包括补足的上月和下月的部分日期
     * @example
     * [
     *      ........
     *    { year: 2025, month: 4, day: 30, isCurrentMonth: false },
     *    { year: 2025, month: 5, day: 1, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 2, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 3, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 4, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 5, isCurrentMonth: true },
     *      ........
     *      ........
     *      ........
     *    { year: 2025, month: 5, day: 31, isCurrentMonth: true },
     *      ........
     * ]
     * @param year
     * @param month
     * @returns
     */
    CalendarView.prototype._getMonthGrid = function (year, month) {
        var result = [];
        // 当前月第一天
        var firstDay = new Date(year, month - 1, 1);
        // 当前月第一天是星期几
        var firstWeekDay = firstDay.getDay(); // 0 = Sunday
        // 上个月
        var prevMonth = month === 1 ? 12 : month - 1;
        // 上一年
        var prevYear = month === 1 ? year - 1 : year;
        // 上一年的最后一天
        var prevLastDate = new Date(prevYear, prevMonth, 0).getDate();
        // 填充上个月
        for (var i = firstWeekDay - 1; i >= 0; i--) {
            result.push({
                year: prevYear,
                month: prevMonth,
                day: prevLastDate - i,
                isCurrentMonth: false,
            });
        }
        // 填充当前月
        var currentLastDate = new Date(year, month, 0).getDate();
        for (var day = 1; day <= currentLastDate; day++) {
            result.push({
                year: year,
                month: month,
                day: day,
                isCurrentMonth: true,
            });
        }
        // 补足到 7*6 = 42 格，填充下个月
        while (result.length < 42) {
            var nextDay = result.length - (firstWeekDay + currentLastDate - 1) + 1;
            var nextMonth = month === 12 ? 1 : month + 1;
            var nextYear = month === 12 ? year + 1 : year;
            result.push({
                year: nextYear,
                month: nextMonth,
                day: nextDay,
                isCurrentMonth: false,
            });
        }
        return result;
    };
    /**
     * 根据星期分组，一个星期编号对应5个日期
     * @example
        "星期日: 30, 6, 13, 20, 27"
        "星期一: 31, 7, 14, 21, 28"
        "星期二: 1, 8, 15, 22, 29"
        "星期三: 2, 9, 16, 23, 30"
        "星期四: 3, 10, 17, 24, 2"
        "星期五: 4, 11, 18, 25, 3"
        "星期六: 5, 12, 19, 26, 4"
     * @param flatArray
     * @returns
     */
    CalendarView.prototype._rearrangeByWeekday = function (flatArray) {
        var weekdayRows = [[], [], [], [], [], [], []]; // 0 = Sunday
        for (var i = 0; i < flatArray.length; i++) {
            var weekday = i % 7;
            weekdayRows[weekday].push(flatArray[i]);
        }
        return weekdayRows;
    };
    __decorate([
        property(cc.Node)
    ], CalendarView.prototype, "nextPgaeNd", void 0);
    __decorate([
        property(cc.Node)
    ], CalendarView.prototype, "prevPgaeNd", void 0);
    __decorate([
        property(cc.Label)
    ], CalendarView.prototype, "lblCurDate", void 0);
    __decorate([
        property(cc.Label)
    ], CalendarView.prototype, "lblSelectDate", void 0);
    CalendarView = __decorate([
        ccclass
    ], CalendarView);
    return CalendarView;
}(cc.Component));
exports.CalendarView = CalendarView;

cc._RF.pop();