"use strict";
cc._RF.push(module, 'c6611QBEx1FdpikrAcH/z/6', 'ItemCalendarDay');
// scripts/ItemCalendarDay.ts

"use strict";
/*
 * @Author       : -------
 * @Date         : 2025-05-15 20:58:37
 * @LastEditors  : -------
 * @LastEditTime : 2025-05-16 17:01:56
 * @Description  : file content
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemCalendarDay = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ItemCalendarDay = /** @class */ (function (_super) {
    __extends(ItemCalendarDay, _super);
    function ItemCalendarDay() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lblDay = null;
        _this.bgTouch = null;
        _this._date = null;
        _this._isSelected = false;
        return _this;
    }
    ItemCalendarDay.prototype.onEnable = function () {
        this._addEvent();
    };
    ItemCalendarDay.prototype.onDisable = function () {
        this._removeEvent();
    };
    ItemCalendarDay.prototype._addEvent = function () {
        this.bgTouch.node.on(cc.Node.EventType.TOUCH_END, this._onTonchCell, this);
    };
    ItemCalendarDay.prototype._removeEvent = function () {
        this.bgTouch.node.off(cc.Node.EventType.TOUCH_END, this._onTonchCell, this);
    };
    ItemCalendarDay.prototype._onTonchCell = function () {
        cc.director.getScene().emit("event_select_cell_day", this._date);
    };
    Object.defineProperty(ItemCalendarDay.prototype, "date", {
        set: function (date) {
            this._date = date;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemCalendarDay.prototype, "isSelected", {
        set: function (isSelected) {
            this._isSelected = isSelected;
        },
        enumerable: false,
        configurable: true
    });
    ItemCalendarDay.prototype.updateView = function () {
        if (!this._date) {
            cc.error("[updateView] \u5FC5\u987B\u5148\u8BBE\u7F6Edate");
            return;
        }
        if (this._date.isCurrentMonth) {
            this.lblDay.string = this._date.day.toString();
            this.lblDay.node.color = cc.Color.BLACK;
            this.bgTouch.enabled = false;
            this.bgTouch.node.active = true;
        }
        else {
            this.lblDay.string = "";
            this.bgTouch.node.active = false;
        }
        if (this._isSelected) {
            this.bgTouch.enabled = this._isSelected;
            this.lblDay.node.color = cc.Color.WHITE;
            this.bgTouch.enabled = true;
        }
    };
    __decorate([
        property(cc.Label)
    ], ItemCalendarDay.prototype, "lblDay", void 0);
    __decorate([
        property(cc.Sprite)
    ], ItemCalendarDay.prototype, "bgTouch", void 0);
    ItemCalendarDay = __decorate([
        ccclass
    ], ItemCalendarDay);
    return ItemCalendarDay;
}(cc.Component));
exports.ItemCalendarDay = ItemCalendarDay;

cc._RF.pop();