
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/scripts/CalendarView');
require('./assets/scripts/ICalendarCell');
require('./assets/scripts/ItemCalendarDay');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/ItemCalendarDay.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'c6611QBEx1FdpikrAcH/z/6', 'ItemCalendarDay');
// scripts/ItemCalendarDay.ts

"use strict";
/*
 * @Author       : -------
 * @Date         : 2025-05-15 20:58:37
 * @LastEditors  : -------
 * @LastEditTime : 2025-05-16 17:01:56
 * @Description  : file content
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemCalendarDay = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ItemCalendarDay = /** @class */ (function (_super) {
    __extends(ItemCalendarDay, _super);
    function ItemCalendarDay() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lblDay = null;
        _this.bgTouch = null;
        _this._date = null;
        _this._isSelected = false;
        return _this;
    }
    ItemCalendarDay.prototype.onEnable = function () {
        this._addEvent();
    };
    ItemCalendarDay.prototype.onDisable = function () {
        this._removeEvent();
    };
    ItemCalendarDay.prototype._addEvent = function () {
        this.bgTouch.node.on(cc.Node.EventType.TOUCH_END, this._onTonchCell, this);
    };
    ItemCalendarDay.prototype._removeEvent = function () {
        this.bgTouch.node.off(cc.Node.EventType.TOUCH_END, this._onTonchCell, this);
    };
    ItemCalendarDay.prototype._onTonchCell = function () {
        cc.director.getScene().emit("event_select_cell_day", this._date);
    };
    Object.defineProperty(ItemCalendarDay.prototype, "date", {
        set: function (date) {
            this._date = date;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemCalendarDay.prototype, "isSelected", {
        set: function (isSelected) {
            this._isSelected = isSelected;
        },
        enumerable: false,
        configurable: true
    });
    ItemCalendarDay.prototype.updateView = function () {
        if (!this._date) {
            cc.error("[updateView] \u5FC5\u987B\u5148\u8BBE\u7F6Edate");
            return;
        }
        if (this._date.isCurrentMonth) {
            this.lblDay.string = this._date.day.toString();
            this.lblDay.node.color = cc.Color.BLACK;
            this.bgTouch.enabled = false;
            this.bgTouch.node.active = true;
        }
        else {
            this.lblDay.string = "";
            this.bgTouch.node.active = false;
        }
        if (this._isSelected) {
            this.bgTouch.enabled = this._isSelected;
            this.lblDay.node.color = cc.Color.WHITE;
            this.bgTouch.enabled = true;
        }
    };
    __decorate([
        property(cc.Label)
    ], ItemCalendarDay.prototype, "lblDay", void 0);
    __decorate([
        property(cc.Sprite)
    ], ItemCalendarDay.prototype, "bgTouch", void 0);
    ItemCalendarDay = __decorate([
        ccclass
    ], ItemCalendarDay);
    return ItemCalendarDay;
}(cc.Component));
exports.ItemCalendarDay = ItemCalendarDay;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/CalendarView.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '3dee8Dlcj9B8al7ZxP+q9gL', 'CalendarView');
// scripts/CalendarView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarView = void 0;
var ItemCalendarDay_1 = require("./ItemCalendarDay");
/*
 * @Author       : -------
 * @Date         : 2025-05-15 20:58:37
 * @LastEditors  : -------
 * @LastEditTime : 2025-05-16 17:00:28
 * @Description  : file content
 * 如果需要扩展为滑动，可以使用虚拟PageView，以calendar_table_page为子页进行扩展
 * 由于虚拟PageView很多实现都不相同，各个项目也可能不同，我也没有非常好用PageView
 * 所以需要使用可以选择自己合适的实现
 */
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var CalendarView = /** @class */ (function (_super) {
    __extends(CalendarView, _super);
    function CalendarView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.nextPgaeNd = null;
        _this.prevPgaeNd = null;
        _this.lblCurDate = null;
        _this.lblSelectDate = null;
        _this._currentYear = 0;
        _this._currentMonth = 0;
        _this._curSelectCell = null;
        return _this;
    }
    CalendarView.prototype.onLoad = function () {
        this._initData();
        this._initUI();
    };
    CalendarView.prototype.onEnable = function () {
        this._addEvent();
    };
    CalendarView.prototype.onDisable = function () {
        this._removeEvent();
    };
    CalendarView.prototype._initData = function () {
        var currentDate = new Date();
        this._currentYear = currentDate.getFullYear();
        this._currentMonth = currentDate.getMonth() + 1;
    };
    CalendarView.prototype._initUI = function () {
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._addEvent = function () {
        var _a, _b;
        cc.director.getScene().on("event_select_cell_day", this._onSelectCellDay, this);
        (_a = this.prevPgaeNd) === null || _a === void 0 ? void 0 : _a.on(cc.Node.EventType.TOUCH_END, this._onPrevPage, this);
        (_b = this.nextPgaeNd) === null || _b === void 0 ? void 0 : _b.on(cc.Node.EventType.TOUCH_END, this._onNextPage, this);
    };
    CalendarView.prototype._removeEvent = function () {
        var _a, _b;
        cc.director.getScene().off("event_select_cell_day", this._onSelectCellDay, this);
        (_a = this.prevPgaeNd) === null || _a === void 0 ? void 0 : _a.off(cc.Node.EventType.TOUCH_END, this._onPrevPage, this);
        (_b = this.nextPgaeNd) === null || _b === void 0 ? void 0 : _b.off(cc.Node.EventType.TOUCH_END, this._onNextPage, this);
    };
    CalendarView.prototype._onSelectCellDay = function (date) {
        if (this._curSelectCell && this._isSameDate(date, this._curSelectCell)) {
            return;
        }
        this.lblSelectDate && (this.lblSelectDate.string = date.year + "-" + date.month + "-" + date.day);
        this._curSelectCell = date;
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._onPrevPage = function () {
        if (this._currentMonth === 1) {
            this._currentYear -= 1;
            this._currentMonth = 12;
        }
        else {
            this._currentMonth -= 1;
        }
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._onNextPage = function () {
        if (this._currentMonth === 12) {
            this._currentYear += 1;
            this._currentMonth = 1;
        }
        else {
            this._currentMonth += 1;
        }
        this._refreshCurrentMonthView();
    };
    CalendarView.prototype._isSameDate = function (a, b) {
        return a.year === b.year && a.month === b.month && a.day === b.day;
    };
    CalendarView.prototype._refreshCurrentMonthView = function () {
        var monthGrid = this._getMonthGrid(this._currentYear, this._currentMonth);
        var weekdayRows = this._rearrangeByWeekday(monthGrid);
        var calenderTable = this.node.getChildByName("calendar_table_page");
        for (var i = 0; i < weekdayRows.length; ++i) {
            var weekDaysNd = calenderTable.children[i];
            var weekDays = weekdayRows[i];
            for (var j = 0; j < weekDays.length; ++j) {
                var dayData = weekDays[j];
                var dayItem = weekDaysNd.children[j].getComponent(ItemCalendarDay_1.ItemCalendarDay);
                dayItem.date = dayData;
                dayItem.isSelected = this._curSelectCell && this._isSameDate(dayData, this._curSelectCell);
                dayItem.updateView();
            }
        }
        this.lblCurDate && (this.lblCurDate.string = this._currentYear + "-" + this._currentMonth);
    };
    /**
     * 获取当前月份的数据，其中包括补足的上月和下月的部分日期
     * @example
     * [
     *      ........
     *    { year: 2025, month: 4, day: 30, isCurrentMonth: false },
     *    { year: 2025, month: 5, day: 1, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 2, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 3, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 4, isCurrentMonth: true },
     *    { year: 2025, month: 5, day: 5, isCurrentMonth: true },
     *      ........
     *      ........
     *      ........
     *    { year: 2025, month: 5, day: 31, isCurrentMonth: true },
     *      ........
     * ]
     * @param year
     * @param month
     * @returns
     */
    CalendarView.prototype._getMonthGrid = function (year, month) {
        var result = [];
        // 当前月第一天
        var firstDay = new Date(year, month - 1, 1);
        // 当前月第一天是星期几
        var firstWeekDay = firstDay.getDay(); // 0 = Sunday
        // 上个月
        var prevMonth = month === 1 ? 12 : month - 1;
        // 上一年
        var prevYear = month === 1 ? year - 1 : year;
        // 上一年的最后一天
        var prevLastDate = new Date(prevYear, prevMonth, 0).getDate();
        // 填充上个月
        for (var i = firstWeekDay - 1; i >= 0; i--) {
            result.push({
                year: prevYear,
                month: prevMonth,
                day: prevLastDate - i,
                isCurrentMonth: false,
            });
        }
        // 填充当前月
        var currentLastDate = new Date(year, month, 0).getDate();
        for (var day = 1; day <= currentLastDate; day++) {
            result.push({
                year: year,
                month: month,
                day: day,
                isCurrentMonth: true,
            });
        }
        // 补足到 7*6 = 42 格，填充下个月
        while (result.length < 42) {
            var nextDay = result.length - (firstWeekDay + currentLastDate - 1) + 1;
            var nextMonth = month === 12 ? 1 : month + 1;
            var nextYear = month === 12 ? year + 1 : year;
            result.push({
                year: nextYear,
                month: nextMonth,
                day: nextDay,
                isCurrentMonth: false,
            });
        }
        return result;
    };
    /**
     * 根据星期分组，一个星期编号对应5个日期
     * @example
        "星期日: 30, 6, 13, 20, 27"
        "星期一: 31, 7, 14, 21, 28"
        "星期二: 1, 8, 15, 22, 29"
        "星期三: 2, 9, 16, 23, 30"
        "星期四: 3, 10, 17, 24, 2"
        "星期五: 4, 11, 18, 25, 3"
        "星期六: 5, 12, 19, 26, 4"
     * @param flatArray
     * @returns
     */
    CalendarView.prototype._rearrangeByWeekday = function (flatArray) {
        var weekdayRows = [[], [], [], [], [], [], []]; // 0 = Sunday
        for (var i = 0; i < flatArray.length; i++) {
            var weekday = i % 7;
            weekdayRows[weekday].push(flatArray[i]);
        }
        return weekdayRows;
    };
    __decorate([
        property(cc.Node)
    ], CalendarView.prototype, "nextPgaeNd", void 0);
    __decorate([
        property(cc.Node)
    ], CalendarView.prototype, "prevPgaeNd", void 0);
    __decorate([
        property(cc.Label)
    ], CalendarView.prototype, "lblCurDate", void 0);
    __decorate([
        property(cc.Label)
    ], CalendarView.prototype, "lblSelectDate", void 0);
    CalendarView = __decorate([
        ccclass
    ], CalendarView);
    return CalendarView;
}(cc.Component));
exports.CalendarView = CalendarView;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/ICalendarCell.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '2eb81y68IRGUJ4JY39BNRnz', 'ICalendarCell');
// scripts/ICalendarCell.ts

"use strict";
/*
 * @Author       : -------
 * @Date         : 2025-05-16 13:46:36
 * @LastEditors  : -------
 * @LastEditTime : 2025-05-16 17:01:39
 * @Description  : file content
 */
Object.defineProperty(exports, "__esModule", { value: true });

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9zY3JpcHRzL0lDYWxlbmRhckNlbGwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7R0FNRyIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBAQXV0aG9yICAgICAgIDogLS0tLS0tLVxuICogQERhdGUgICAgICAgICA6IDIwMjUtMDUtMTYgMTM6NDY6MzZcbiAqIEBMYXN0RWRpdG9ycyAgOiAtLS0tLS0tXG4gKiBATGFzdEVkaXRUaW1lIDogMjAyNS0wNS0xNiAxNzowMTozOVxuICogQERlc2NyaXB0aW9uICA6IGZpbGUgY29udGVudFxuICovXG5cbmV4cG9ydCBpbnRlcmZhY2UgSUNhbGVuZGFyQ2VsbCB7XG4gICAgeWVhcjogbnVtYmVyOyAvLyDlubTku71cbiAgICBtb250aDogbnVtYmVyOyAvLyDmnIjku70xfjEyXG4gICAgZGF5OiBudW1iZXI7IC8vIOaXpeacnyAxfjMxXG4gICAgaXNDdXJyZW50TW9udGg6IGJvb2xlYW47IC8vIOaYr+WQpuaYr+W9k+WJjeaciFxufVxuIl19
//------QC-SOURCE-SPLIT------
