import { _decorator, Component, Node, assetManager, AssetManager, error, Prefab, instantiate } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {
    start() {
        assetManager.loadBundle("res1",async (err, bundle : AssetManager.Bundle)=> {
            if (err) {
                error(err);
                return;
            }
            let deps = bundle.deps;
            if(deps.length !== 0){
                for(let i = 0;i < deps.length;++i){
                    let err = await new Promise(resolve => {
                        let bundleName = deps[i];
                        assetManager.loadBundle(bundleName ,((err, bundle1) => {
                            resolve(err);
                        }))
                    });
                    if(err){
                        error(err);
                        return;
                    }
                }
            }
            bundle.load("test",Prefab,(err,prefab)=>{
                if(prefab){
                    this.node.addChild(instantiate(prefab));
                }else {
                    error(err);
                }
            })
        })
    }
}


