const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {


    private logo: cc.Node = null;

    @property
    text: string = 'hello';

    enterRoom() {
        cc.resources.load("cocos", cc.Prefab, (err, prefab: cc.Prefab) => {
            let node = cc.instantiate(prefab);
            node.opacity = 1;
            this.node.addChild(node)
            this.logo = node;
            cc.tween(node).delay(0).to(0.5, { opacity: 255 }).call(() => {

            }).start();
        })
    }

    exitRoom() {
        if (this.logo != null) {
            this.logo.opacity = 255;
            cc.tween(this.logo).to(0.5, { opacity: 0 }).call(() => {
                this.logo.removeFromParent();
                this.logo.destroy();
                this.logo = null
            }).start();
        }
    }
}
