/**
 * 对应的声明在creatorExtension.d.ts中
 */

 import { Node, Quat, quat, UITransform, v3, Vec3 } from "cc";
 
 /**
  * 将Node节点下的本地坐标转换为世界坐标
  */
 Node.prototype.transformLocalToWorldPoint = function(localPoint:Vec3):Vec3{
     let result = v3(0,0,0);
     Vec3.copy(result,localPoint);
     let cur = this;
     //@ts-ignore
     while (cur && cur._lrot) {
         //@ts-ignore
         Vec3.transformRTS(result, result, cur._lrot, cur._lpos, cur._lscale);
         //@ts-ignore
         cur = cur._parent;
     }
     return result;
 }
 
 /**
  * 将世界坐标转换为Node节点下的本地坐标
  */
 Node.prototype.transformWorldToLocalPoint = function(worldPoint: Vec3):Vec3{
     let result = v3(0,0,0);
     Vec3.copy(result,worldPoint);
     let cur = this;
     let i = 0;
     let array = [];
     //@ts-ignore
     while (cur._parent && cur._parent._lrot) {
         array[i++] = cur;
         //@ts-ignore
         cur = cur._parent;
     }
     while (i >= 0) {
         //@ts-ignore
         Vec3.transformInverseRTS(result, result, cur._lrot, cur._lpos, cur._lscale);
         cur = array[--i];
     }
     return result;
 }

 
 /**
  * 将相对角度转换为世界角度
  * 不考虑翻转的情况，所以计算结果可能有误
  */
 Node.prototype.transformLocalToWorldRotationFromEuler = function(localRotationEuler:Vec3):Vec3{
     let resultEuler = v3(0,0,0);
     let resultQuat = quat(0,0,0,0);
     let _lrot = quat(0,0,0,0);
     Quat.fromEuler(_lrot,localRotationEuler.x,localRotationEuler.y,localRotationEuler.z);
     Quat.multiply(resultQuat, this.getWorldRotation(), _lrot);
     resultQuat.getEulerAngles(resultEuler);
     return resultEuler;
 }
 
 
 /**
  * 将相对缩放转换为世界缩放
  */
 Node.prototype.transformLocalToWorldScale = function(localScale:Vec3):Vec3{
     let scaleX = localScale.x;
     let scaleY = localScale.y;
     let scaleZ = localScale.z;
 
     let parent = this;
     while (parent) {
         scaleX *= parent.scale.x;
         scaleY *= parent.scale.y;
         scaleZ *= parent.scale.z;
         //@ts-ignore
         parent = parent.parent;
     }
     return new Vec3(scaleX,scaleY,scaleZ);
 }

 
 export {}; 