/** 
 * CocosCreator扩展方法 
**/
declare module "cc" {
  
    /**
     * 扩展Node类：NodeExtensions类
     */
    interface Node {
        /**
         * 将Node的本地坐标转换为世界坐标
         * @param localPos 
         */
        transformLocalToWorldPoint(localPoint:Vec3):Vec3;

        /**
         * 将世界坐标转换为Node本地坐标
         * @param localPos 
         */
        transformWorldToLocalPoint(worldPoint:Vec3):Vec3;

        /**
		 * 将相对角度转换为世界角度
		 * @param localRotation 
		 */
		transformLocalToWorldRotationFromEuler(localRotation:Vec3):Vec3;

        /**
		 * 将相对缩放转换为世界缩放
		 * @param localRotation 
		 */
		transformLocalToWorldScale(localScale:Vec3):Vec3;

    }

}
