import { _decorator, CCBoolean, Component, instantiate, Node, tween, v3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {
    @property(CCBoolean)
    testScale = false;
    start() {
        if (this.testScale) {
            this.createNode();
        }
    }

    createNode() {
        let node = this.node.children[1];
        let list: Node[] = [];
        for (let i = 0; i < 100; ++i) {
            let item = instantiate(node);
            item.setParent(this.node);
            list.push(item);
            if(this.testScale){
                tween(item).to(100,{scale : v3(10,10,10)}).to(100,{scale : v3(1,1,1)}).start();
            }
        }
        if (!this.testScale) {
            this.scheduleOnce(() => {
                this.scheduleOnce(() => {
                    for (let i = 0; i < list.length; ++i) {
                        let item = list[i];
                        item.destroy();
                    }
                })
            })
        }
    }

    update(deltaTime: number) {
        if (!this.testScale) {
            this.createNode();
        }
    }
}

