
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/srcipt/game.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '3a7cf3wDPxAM5oWbI8zEfgo', 'game');
// srcipt/game.js

"use strict";

// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
cc.Class({
  "extends": cc.Component,
  properties: {
    tiledMap: cc.TiledMap // foo: {
    //     // ATTRIBUTES:
    //     default: null,        // The default value will be used only when the component attaching
    //                           // to a node for the first time
    //     type: cc.SpriteFrame, // optional, default is typeof default
    //     serializable: true,   // optional, default is true
    // },
    // bar: {
    //     get () {
    //         return this._bar;
    //     },
    //     set (value) {
    //         this._bar = value;
    //     }
    // },

  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //   开启物理引擎
    var p = cc.director.getPhysicsManager();
    p.enabled = true; // 碰撞局域的描绘

    p.debugDrawFlags = true;
    p.gravity = cc.v2(0, 0);
  },
  start: function start() {
    // let tiledMap = this.mapNode.getComponent(cc.TiledMap);
    // console.log(tiledMap);
    // 每一小块的距离
    var tiledSize = this.tiledMap.getTileSize(); //   拿到wall城墙
    // console.log(tiledSize);

    var layer = this.tiledMap.getLayer("wall"); // 拿到块数

    console.log(layer); // let layerSize = this.tiledMap.getLayerSize();
    // console.log(layerSize);
    // 迷雾
    // let smogLayer = tiledMap.getLayer("smog");
    // smogLayer.node.active = true;

    var mapSize = this.tiledMap.getMapSize();

    for (var i = 0; i < mapSize.width; i++) {
      for (var j = 0; j < mapSize.height; j++) {
        var v2Tile = cc.v2(i, j); //拿到Tiled对象

        var oTiled = layer.getTiledTileAt(i, j, true); //对象不存在 继续下一次循环

        if (!oTiled) continue; //gid === 0 继续下一次循环

        if (0 === oTiled.gid) continue; //拿到tile对应的世界坐标

        var v2WorldPos = this.getPosByTile(v2Tile); //创建一个节点

        var oNode = new cc.Node(); //设置父节点

        oNode.parent = this.node; //将世界坐标转化为this.node下的本地坐标

        oNode.setPosition(this.node.convertToNodeSpaceAR(v2WorldPos)); //创建物理

        oNode.group = "wall";
        var body = oNode.addComponent(cc.RigidBody);
        body.type = cc.RigidBodyType.Static;
        var collider = oNode.addComponent(cc.PhysicsBoxCollider); // collider.offset = cc.v2(tiledSize.width /2, tiledSize.height / 2);

        collider.size = tiledSize;
        collider.apply();
      }
    }
  },
  //像素坐标转化为格子坐标
  getTiledByPos: function getTiledByPos(worldPos) {
    var pos = this.tiledMap.node.convertToNodeSpaceAR(worldPos);
    var tilePos = cc.v2(0, 0);
    var tileSize = this.tiledMap.getTileSize();
    var mapSize = this.tiledMap.getMapSize();
    tilePos.x = Math.floor(pos.x / tileSize.width);
    tilePos.y = Math.floor((tileSize.height * mapSize.height - pos.y) / tileSize.height);
    return tilePos;
  },
  //格子坐标转化为像素坐标
  getPosByTile: function getPosByTile(tile) {
    var tileSize = this.tiledMap.getTileSize();
    var mapSize = this.tiledMap.getMapSize();
    var x = tile.x * tileSize.width + tileSize.width / 2;
    var y = tileSize.height * mapSize.height - tile.y * tileSize.height - tileSize.height / 2;
    return cc.v2(x, y);
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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