
import { _decorator, Component, Node, Prefab, instantiate, RigidBody } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Collidertest')
export class Collidertest extends Component {
    // [1]
    // dummy = '';

    // [2]
    @property({type:Prefab})
    replacement:Prefab; 

    start () {
        this.scheduleOnce(()=>{
            this.node.active = false;
            let n = instantiate(this.replacement);
            n.parent = this.node.parent;
            n.setScale(this.node.getScale());
            n.setPosition(this.node.getPosition());
            for (let v of n.children){
                let r = v.getComponent(RigidBody) || v.addComponent(RigidBody);
                r.isDynamic = true;
                this.scheduleOnce(()=>{
                    console.log(123)
                })
                setTimeout(()=>{
                    console.log('??', v.position)
                })
            }

            
        }, 2);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
