import { _decorator, Button, Component, director, Label, Node } from 'cc';
import { GameMgr } from '../../scenes/GameMgr';
const { ccclass, property } = _decorator;

@ccclass('RemoteDemoCtrl')
export class RemoteDemoCtrl extends Component {
    @property(Label)
    private label: Label = null;

    @property(Button)
    private backBtn: Button = null;

    start() {
        this.label.string = GameMgr.getInstance().getScore().toString();
        this.backBtn.node.on(Button.EventType.CLICK, this.onBackBtnClick, this);
    }

    onBackBtnClick() {
        director.loadScene('main-demo');
    }

}

